/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.Consumer;
import java.util.List;

public final class UpdateFilesHelper {
    private UpdateFilesHelper() {
    }

    public static void iterateFileGroupFilesDeletedOnServerFirst(UpdatedFiles updatedFiles, Callback callback2) {
        FileGroup changedOnServer = updatedFiles.getGroupById("CHANGED_ON_SERVER");
        if (changedOnServer != null) {
            List children = changedOnServer.getChildren();
            for (FileGroup child : children) {
                if (!"REMOVED_FROM_REPOSITORY".equals(child.getId())) continue;
                UpdateFilesHelper.iterateGroup(child, callback2);
            }
        }
        List groups = updatedFiles.getTopLevelGroups();
        for (FileGroup group : groups) {
            UpdateFilesHelper.iterateGroup(group, callback2);
            for (FileGroup childGroup : group.getChildren()) {
                if ("REMOVED_FROM_REPOSITORY".equals(childGroup.getId())) continue;
                UpdateFilesHelper.iterateGroup(childGroup, callback2);
            }
        }
    }

    private static void iterateGroup(FileGroup group, Callback callback2) {
        for (String file : group.getFiles()) {
            callback2.onFile(file, group.getId());
        }
    }

    public static void iterateFileGroupFiles(UpdatedFiles updatedFiles, Callback callback2) {
        List groups = updatedFiles.getTopLevelGroups();
        for (FileGroup group : groups) {
            UpdateFilesHelper.iterateGroup(group, callback2);
            for (FileGroup childGroup : group.getChildren()) {
                UpdateFilesHelper.iterateGroup(childGroup, callback2);
            }
        }
    }

    private static void iterateGroup(FileGroup group, Consumer<? super Couple<String>> callback2) {
        for (FileGroup.UpdatedFile updatedFile : group.getUpdatedFiles()) {
            callback2.consume((Object)Couple.of((Object)updatedFile.getPath(), (Object)updatedFile.getVcsName()));
        }
    }

    public static void iterateAffectedFiles(UpdatedFiles updatedFiles, Consumer<? super Couple<String>> callback2) {
        List groups = updatedFiles.getTopLevelGroups();
        for (FileGroup group : groups) {
            UpdateFilesHelper.iterateGroup(group, callback2);
            for (FileGroup childGroup : group.getChildren()) {
                UpdateFilesHelper.iterateGroup(childGroup, callback2);
            }
        }
    }

    public static interface Callback {
        public void onFile(String var1, String var2);
    }
}

