/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.application.options.colors.fileStatus.FileStatusColorsConfigurable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfigurableProvider;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictConfigurable;
import com.intellij.openapi.vcs.changes.ui.IgnoredSettingsPanel;
import com.intellij.openapi.vcs.configurable.CommitDialogConfigurable;
import com.intellij.openapi.vcs.configurable.IssueNavigationConfigurationPanel;
import com.intellij.openapi.vcs.configurable.ShelfProjectConfigurable;
import com.intellij.openapi.vcs.configurable.VcsBackgroundOperationsConfigurable;
import com.intellij.openapi.vcs.configurable.VcsDirectoryConfigurationPanel;
import com.intellij.openapi.vcs.configurable.VcsGeneralConfigurationConfigurable;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsManagerConfigurable
extends SearchableConfigurable.Parent.Abstract
implements Configurable.NoScroll,
Configurable.WithEpDependencies {
    @NotNull
    private final Project myProject;
    private VcsDirectoryConfigurationPanel myMappings;
    private VcsGeneralConfigurationConfigurable myGeneralPanel;

    public VcsManagerConfigurable(@NotNull Project project) {
        if (project == null) {
            VcsManagerConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        List<BaseExtensionPointName<?>> list = Arrays.asList(VcsEP.EP_NAME, VcsConfigurableProvider.EP_NAME);
        if (list == null) {
            VcsManagerConfigurable.$$$reportNull$$$0(1);
        }
        return list;
    }

    public JComponent createComponent() {
        this.myMappings = new VcsDirectoryConfigurationPanel(this.myProject);
        return this.myMappings;
    }

    public boolean hasOwnContent() {
        return true;
    }

    public boolean isModified() {
        return this.myMappings != null && this.myMappings.isModified();
    }

    public void apply() throws ConfigurationException {
        super.apply();
        this.myMappings.apply();
    }

    public void reset() {
        super.reset();
        this.myMappings.reset();
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        if (this.myMappings != null) {
            this.myMappings.disposeUIResources();
        }
        if (this.myGeneralPanel != null) {
            this.myGeneralPanel.disposeUIResources();
        }
        this.myMappings = null;
    }

    public String getDisplayName() {
        return VcsBundle.message((String)"version.control.main.configurable.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return "project.propVCSSupport.Mappings";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            VcsManagerConfigurable.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected Configurable[] buildConfigurables() {
        this.myGeneralPanel = new VcsGeneralConfigurationConfigurable(this.myProject, this);
        ArrayList<Object> result2 = new ArrayList<Object>();
        result2.add(this.myGeneralPanel);
        result2.add(new VcsBackgroundOperationsConfigurable(this.myProject));
        boolean ignoreSettingsAvailable = Registry.is((String)"vcs.ignorefile.generation", (boolean)true);
        if (!this.myProject.isDefault() && ignoreSettingsAvailable) {
            result2.add((Object)new IgnoredSettingsPanel(this.myProject));
        }
        result2.add(new IssueNavigationConfigurationPanel(this.myProject));
        if (!this.myProject.isDefault()) {
            result2.add((Object)new ChangelistConflictConfigurable(ChangeListManagerImpl.getInstanceImpl(this.myProject)));
        }
        result2.add((Object)new CommitDialogConfigurable(this.myProject));
        result2.add(new ShelfProjectConfigurable(this.myProject));
        for (VcsConfigurableProvider provider : (VcsConfigurableProvider[])VcsConfigurableProvider.EP_NAME.getExtensions()) {
            ContainerUtil.addIfNotNull(result2, (Object)provider.getConfigurable(this.myProject));
        }
        result2.add(new FileStatusColorsConfigurable());
        Set projectConfigurableIds = ContainerUtil.map2Set((Collection)Configurable.PROJECT_CONFIGURABLE.getExtensions((AreaInstance)this.myProject), ep -> ep.id);
        for (VcsDescriptor descriptor : ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllVcss()) {
            if (projectConfigurableIds.contains(VcsManagerConfigurable.getVcsConfigurableId(descriptor.getDisplayName()))) continue;
            result2.add((Configurable)ConfigurableWrapper.wrapConfigurable((ConfigurableEP)new VcsConfigurableEP(this.myProject, descriptor)));
        }
        return result2.toArray(new Configurable[0]);
    }

    @Nullable
    public VcsDirectoryConfigurationPanel getMappings() {
        return this.myMappings;
    }

    @NotNull
    public static String getVcsConfigurableId(@NotNull String displayName) {
        if (displayName == null) {
            VcsManagerConfigurable.$$$reportNull$$$0(3);
        }
        String string = "vcs." + displayName;
        if (string == null) {
            VcsManagerConfigurable.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsConfigurableId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVcsConfigurableId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VcsConfigurableEP
    extends ConfigurableEP<Configurable> {
        private static final int WEIGHT = -500;
        @NotNull
        private final VcsDescriptor myDescriptor;

        VcsConfigurableEP(@NotNull Project project, @NotNull VcsDescriptor descriptor) {
            if (project == null) {
                VcsConfigurableEP.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                VcsConfigurableEP.$$$reportNull$$$0(1);
            }
            super(project);
            this.myDescriptor = descriptor;
            this.displayName = descriptor.getDisplayName();
            this.id = VcsManagerConfigurable.getVcsConfigurableId(descriptor.getDisplayName());
            this.groupWeight = -500;
        }

        @NotNull
        protected ConfigurableEP.ObjectProducer createProducer() {
            return new ConfigurableEP.ObjectProducer(){

                protected Object createElement() {
                    return Objects.requireNonNull(ProjectLevelVcsManager.getInstance((Project)this.getProject()).findVcsByName(myDescriptor.getName())).getConfigurable();
                }

                protected boolean canCreateElement() {
                    return true;
                }

                protected Class<?> getType() {
                    return SearchableConfigurable.class;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable$VcsConfigurableEP";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

