/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.configurable.CommitOptionsConfigurable;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UI;
import com.intellij.vcs.commit.CommitWorkflowManager;
import com.intellij.vcs.commit.message.CommitMessageInspectionsPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class CommitDialogSettingsPanel
implements ConfigurableUi<VcsConfiguration>,
Disposable {
    @NotNull
    private final Project myProject;
    private JPanel myCommitFromLocalChangesPanel;
    private JBCheckBox myCommitFromLocalChanges;
    private JBCheckBox myShowUnversionedFiles;
    private JPanel myMainPanel;
    private CommitMessageInspectionsPanel myInspectionsPanel;
    private CommitOptionsConfigurable myCommitOptions;
    private JBCheckBox myClearInitialCommitMessage;
    private JBCheckBox myForceNonEmptyCommitMessage;
    private JBCheckBox myMoveUncommittedToAnotherChangeList;
    private ComboBox<VcsShowConfirmationOption.Value> myMoveToFailedCommitChangeList;
    private final EnumComboBoxModel<VcsShowConfirmationOption.Value> myMoveToFailedCommitChangeListModel;

    public CommitDialogSettingsPanel(@NotNull Project project) {
        if (project == null) {
            CommitDialogSettingsPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myMoveToFailedCommitChangeListModel = new EnumComboBoxModel(VcsShowConfirmationOption.Value.class);
        this.myMoveToFailedCommitChangeList.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", VcsShowConfirmationOption::getConfirmationOptionText));
        this.myMoveToFailedCommitChangeList.setModel(this.myMoveToFailedCommitChangeListModel);
    }

    @NotNull
    private static VcsApplicationSettings getAppSettings() {
        VcsApplicationSettings vcsApplicationSettings = VcsApplicationSettings.getInstance();
        if (vcsApplicationSettings == null) {
            CommitDialogSettingsPanel.$$$reportNull$$$0(1);
        }
        return vcsApplicationSettings;
    }

    public void reset(@NotNull VcsConfiguration settings) {
        if (settings == null) {
            CommitDialogSettingsPanel.$$$reportNull$$$0(2);
        }
        this.myCommitFromLocalChanges.setSelected(CommitDialogSettingsPanel.getAppSettings().COMMIT_FROM_LOCAL_CHANGES);
        this.myShowUnversionedFiles.setSelected(settings.SHOW_UNVERSIONED_FILES_WHILE_COMMIT);
        this.myClearInitialCommitMessage.setSelected(settings.CLEAR_INITIAL_COMMIT_MESSAGE);
        this.myForceNonEmptyCommitMessage.setSelected(settings.FORCE_NON_EMPTY_COMMENT);
        this.myMoveUncommittedToAnotherChangeList.setSelected(settings.OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT);
        this.myMoveToFailedCommitChangeListModel.setSelectedItem((Enum)settings.MOVE_TO_FAILED_COMMIT_CHANGELIST);
        this.myInspectionsPanel.reset();
        this.myCommitOptions.reset();
    }

    public boolean isModified(@NotNull VcsConfiguration settings) {
        if (settings == null) {
            CommitDialogSettingsPanel.$$$reportNull$$$0(3);
        }
        return CommitDialogSettingsPanel.getAppSettings().COMMIT_FROM_LOCAL_CHANGES != this.myCommitFromLocalChanges.isSelected() || settings.SHOW_UNVERSIONED_FILES_WHILE_COMMIT != this.myShowUnversionedFiles.isSelected() || settings.CLEAR_INITIAL_COMMIT_MESSAGE != this.myClearInitialCommitMessage.isSelected() || settings.FORCE_NON_EMPTY_COMMENT != this.myForceNonEmptyCommitMessage.isSelected() || settings.OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT != this.myMoveUncommittedToAnotherChangeList.isSelected() || settings.MOVE_TO_FAILED_COMMIT_CHANGELIST != this.myMoveToFailedCommitChangeListModel.getSelectedItem() || this.myInspectionsPanel.isModified() || this.myCommitOptions.isModified();
    }

    public void apply(@NotNull VcsConfiguration settings) throws ConfigurationException {
        if (settings == null) {
            CommitDialogSettingsPanel.$$$reportNull$$$0(4);
        }
        CommitWorkflowManager.setCommitFromLocalChanges(this.myCommitFromLocalChanges.isSelected());
        settings.SHOW_UNVERSIONED_FILES_WHILE_COMMIT = this.myShowUnversionedFiles.isSelected();
        settings.CLEAR_INITIAL_COMMIT_MESSAGE = this.myClearInitialCommitMessage.isSelected();
        settings.FORCE_NON_EMPTY_COMMENT = this.myForceNonEmptyCommitMessage.isSelected();
        settings.OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT = this.myMoveUncommittedToAnotherChangeList.isSelected();
        settings.MOVE_TO_FAILED_COMMIT_CHANGELIST = (VcsShowConfirmationOption.Value)this.myMoveToFailedCommitChangeListModel.getSelectedItem();
        this.myInspectionsPanel.apply();
        this.myCommitOptions.apply();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            CommitDialogSettingsPanel.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myCommitFromLocalChanges = new JBCheckBox(VcsBundle.message((String)"settings.commit.without.dialog", (Object[])new Object[0]));
        this.myCommitFromLocalChangesPanel = UI.PanelFactory.panel((JComponent)this.myCommitFromLocalChanges).withComment(VcsBundle.message((String)"settings.commit.without.dialog.applies.to.git.mercurial", (Object[])new Object[0])).createPanel();
        this.myInspectionsPanel = new CommitMessageInspectionsPanel(this.myProject);
        this.myCommitOptions = new CommitOptionsConfigurable(this.myProject);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myInspectionsPanel);
        Disposer.dispose((Disposable)this.myCommitOptions);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox2;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myShowUnversionedFiles = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/VcsBundle", CommitDialogSettingsPanel.class).getString("settings.show.unversioned.files"));
        jPanel.add((Component)jBCheckBox4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jPanel.add((Component)jPanel2, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndentWithoutInsets.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/VcsBundle", CommitDialogSettingsPanel.class).getString("settings.commit.message.inspections"), (int)0, (int)0, null, null));
        CommitMessageInspectionsPanel commitMessageInspectionsPanel = this.myInspectionsPanel;
        jPanel2.add((Component)((Object)commitMessageInspectionsPanel), new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.myClearInitialCommitMessage = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/VcsBundle", CommitDialogSettingsPanel.class).getString("checkbox.clear.initial.commit.message"));
        jPanel.add((Component)jBCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForceNonEmptyCommitMessage = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/VcsBundle", CommitDialogSettingsPanel.class).getString("checkbox.force.non.empty.messages"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMoveUncommittedToAnotherChangeList = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/VcsBundle", CommitDialogSettingsPanel.class).getString("checkbox.changelist.move.offer"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 2));
        jPanel.add((Component)jPanel3, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/VcsBundle", CommitDialogSettingsPanel.class).getString("create.changelist.on.failed.commit"));
        Component component = jPanel3.add((Component)jBLabel);
        this.myMoveToFailedCommitChangeList = comboBox2 = new ComboBox();
        Component component2 = jPanel3.add((Component)comboBox2);
        CommitOptionsConfigurable commitOptionsConfigurable = this.myCommitOptions;
        jPanel.add((Component)((Object)commitOptionsConfigurable), new GridConstraints(7, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = this.myCommitFromLocalChangesPanel;
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBLabel.setLabelFor((Component)comboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/configurable/CommitDialogSettingsPanel";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/configurable/CommitDialogSettingsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

