/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.ModifiableWorkspaceEntity;
import com.intellij.workspaceModel.storage.MutableExternalEntityMapping;
import com.intellij.workspaceModel.storage.PersistentEntityId;
import com.intellij.workspaceModel.storage.VirtualFileUrl;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageDiffBuilder;
import com.intellij.workspaceModel.storage.WorkspaceEntityWithPersistentId;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.ClassConversion;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverter;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt;
import com.intellij.workspaceModel.storage.impl.ConnectionId;
import com.intellij.workspaceModel.storage.impl.EntitiesKt;
import com.intellij.workspaceModel.storage.impl.EntityFamily;
import com.intellij.workspaceModel.storage.impl.EntityId;
import com.intellij.workspaceModel.storage.impl.EntityReferenceImpl;
import com.intellij.workspaceModel.storage.impl.ImmutableEntitiesBarrel;
import com.intellij.workspaceModel.storage.impl.ModifiableWorkspaceEntityBase;
import com.intellij.workspaceModel.storage.impl.MutableEntitiesBarrel;
import com.intellij.workspaceModel.storage.impl.MutableEntityFamily;
import com.intellij.workspaceModel.storage.impl.MutableRefsTable;
import com.intellij.workspaceModel.storage.impl.MutableStorageIndexes;
import com.intellij.workspaceModel.storage.impl.RefsTable;
import com.intellij.workspaceModel.storage.impl.SoftLinkable;
import com.intellij.workspaceModel.storage.impl.StorageIndexes;
import com.intellij.workspaceModel.storage.impl.StrictMode;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageBuilderImpl;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageImpl;
import com.intellij.workspaceModel.storage.impl.exceptions.AddDiffExceptionKt;
import com.intellij.workspaceModel.storage.impl.exceptions.PersistentIdAlreadyExistsException;
import com.intellij.workspaceModel.storage.impl.exceptions.ReplaceBySourceExceptionKt;
import com.intellij.workspaceModel.storage.impl.external.MutableExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.indices.EntityStorageInternalIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0000\u0018\u0000 }2\u00020\u00012\u00020\u0002:\u0003|}~B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!H\u0002J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&H\u0016JV\u0010'\u001a\u0002H(\"\u000e\b\u0000\u0010)*\b\u0012\u0004\u0012\u0002H(0*\"\b\b\u0001\u0010(*\u00020$2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H)0,2\u0006\u0010-\u001a\u00020.2\u0017\u0010/\u001a\u0013\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u00020\u001d00\u00a2\u0006\u0002\b1H\u0016\u00a2\u0006\u0002\u00102JV\u00103\u001a\u00020\u001d\"\b\b\u0000\u0010(*\u00020$2\u0006\u00104\u001a\u00020\u001f2\u0018\u00105\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\u001f060\u000b2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\u001f0#2\f\u00109\u001a\b\u0012\u0004\u0012\u0002H(0:H\u0002J'\u0010;\u001a\u0002H(\"\b\b\u0000\u0010(*\u00020$2\u0006\u0010<\u001a\u0002H(2\u0006\u0010=\u001a\u00020.H\u0016\u00a2\u0006\u0002\u0010>JN\u0010?\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H(0:\u0012\u0004\u0012\u00020\u001f06\"\b\b\u0000\u0010(*\u00020$2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002H(0:2\u0006\u0010+\u001a\u00020A2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0CH\u0002J*\u0010D\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030,\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030E0\u000b0#2\u0006\u0010F\u001a\u00020GH\u0016J%\u0010H\u001a\u00020\u001d\"\b\b\u0000\u0010(*\u00020$2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002H(0:H\u0000\u00a2\u0006\u0002\bJJ%\u0010K\u001a\b\u0012\u0004\u0012\u0002HM0L\"\b\b\u0000\u0010M*\u00020$2\u0006\u0010<\u001a\u0002HMH\u0016\u00a2\u0006\u0002\u0010NJ\u001c\u0010O\u001a\b\u0012\u0004\u0012\u0002H(0P\"\u0004\b\u0000\u0010(2\u0006\u0010Q\u001a\u00020RH\u0016J\r\u0010S\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\bTJ\b\u0010U\u001a\u00020VH\u0016JV\u0010W\u001a\u0002H(\"\u000e\b\u0000\u0010)*\b\u0012\u0004\u0012\u0002H(0*\"\b\b\u0001\u0010(*\u00020$2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H)0,2\u0006\u0010<\u001a\u0002H(2\u0017\u0010X\u001a\u0013\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u00020\u001d00\u00a2\u0006\u0002\b1H\u0016\u00a2\u0006\u0002\u0010YJ\u0010\u0010Z\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020$H\u0016J\u0016\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u001f0[2\u0006\u0010\\\u001a\u00020\u001fH\u0002J\u000e\u0010]\u001a\u00020\u001d2\u0006\u0010Q\u001a\u00020RJ$\u0010^\u001a\u00020\u001d2\u0012\u0010_\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020V002\u0006\u0010`\u001a\u00020GH\u0016Jr\u0010a\u001a\u00020\u001d\"\b\b\u0000\u0010(*\u00020$2\f\u0010b\u001a\b\u0012\u0004\u0012\u0002H(0:2\u0006\u0010+\u001a\u00020A2\u0018\u0010c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\u001f060\u000b2\u0018\u0010d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\u001f060\u000b2\u0014\u0010e\u001a\u0010\u0012\u0004\u0012\u000207\u0012\u0006\u0012\u0004\u0018\u00010\u001f0#H\u0002J\b\u0010f\u001a\u00020\u001dH\u0016J\b\u0010g\u001a\u00020hH\u0016J#\u0010i\u001a\u00020\u001d2\u0018\u0010j\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0010\u0012\u0004\u0012\u00020\u001d00H\u0082\bJ \u0010k\u001a\u00020\u001d2\n\u0010l\u001a\u0006\u0012\u0002\b\u00030m2\n\u0010n\u001a\u0006\u0012\u0002\b\u00030mH\u0002J>\u0010o\u001a\u00020\u001d2\u0006\u0010p\u001a\u00020\u001f2\u0018\u0010q\u001a\u0014\u0012\u0004\u0012\u000207\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0r0#2\u0012\u0010s\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\u001f0#H\u0002J6\u0010t\u001a\u00020\u001d\"\b\b\u0000\u0010(*\u00020$2\u0006\u0010u\u001a\u00020$2\f\u0010l\u001a\b\u0012\u0002\b\u0003\u0018\u00010m2\f\u00109\u001a\b\u0012\u0004\u0012\u0002H(0:H\u0002JB\u0010v\u001a\f\u0012\u0006\b\u0001\u0012\u00020$\u0018\u00010:*\u0016\u0012\u0004\u0012\u00020x\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020$0:0w2\u000e\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0:2\u0006\u0010y\u001a\u00020\u0002H\u0002J\u0010\u0010z\u001a\u00020V*\u0006\u0012\u0002\b\u00030:H\u0002J\u0018\u0010{\u001a\u00020x*\u0006\u0012\u0002\b\u00030:2\u0006\u0010y\u001a\u00020\u0002H\u0002R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\bX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u0006X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u007f"}, d2={"Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "entitiesByType", "Lcom/intellij/workspaceModel/storage/impl/MutableEntitiesBarrel;", "refs", "Lcom/intellij/workspaceModel/storage/impl/MutableRefsTable;", "indexes", "Lcom/intellij/workspaceModel/storage/impl/MutableStorageIndexes;", "(Lcom/intellij/workspaceModel/storage/impl/MutableEntitiesBarrel;Lcom/intellij/workspaceModel/storage/impl/MutableRefsTable;Lcom/intellij/workspaceModel/storage/impl/MutableStorageIndexes;)V", "changeLog", "", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$ChangeEntry;", "getChangeLog", "()Ljava/util/List;", "changeLogImpl", "", "getEntitiesByType$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/MutableEntitiesBarrel;", "getIndexes$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/MutableStorageIndexes;", "<set-?>", "", "modificationCount", "getModificationCount", "()J", "getRefs$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/MutableRefsTable;", "accumulateEntitiesToRemove", "", "id", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "accumulator", "", "addDiff", "", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "diff", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageDiffBuilder;", "addEntity", "T", "M", "Lcom/intellij/workspaceModel/storage/ModifiableWorkspaceEntity;", "clazz", "Ljava/lang/Class;", "source", "Lcom/intellij/workspaceModel/storage/EntitySource;", "initializer", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Class;Lcom/intellij/workspaceModel/storage/EntitySource;Lkotlin/jvm/functions/Function1;)Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "addReplaceEvent", "pid", "beforeChildren", "Lkotlin/Pair;", "Lcom/intellij/workspaceModel/storage/impl/ConnectionId;", "beforeParents", "copiedData", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "changeSource", "e", "newSource", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntity;Lcom/intellij/workspaceModel/storage/EntitySource;)Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "cloneEntity", "entity", "", "replaceMap", "", "collectChanges", "Lcom/intellij/workspaceModel/storage/EntityChange;", "original", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "createAddEvent", "pEntityData", "createAddEvent$intellij_platform_workspaceModel_storage", "createReference", "Lcom/intellij/workspaceModel/storage/EntityReference;", "E", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntity;)Lcom/intellij/workspaceModel/storage/EntityReference;", "getMutableExternalMapping", "Lcom/intellij/workspaceModel/storage/MutableExternalEntityMapping;", "identifier", "", "incModificationCount", "incModificationCount$intellij_platform_workspaceModel_storage", "isEmpty", "", "modifyEntity", "change", "(Ljava/lang/Class;Lcom/intellij/workspaceModel/storage/WorkspaceEntity;Lkotlin/jvm/functions/Function1;)Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "removeEntity", "", "idx", "removeExternalMapping", "replaceBySource", "sourceFilter", "replaceWith", "replaceEntityWithRefs", "newEntity", "addedChildren", "removedChildren", "modifiedParents", "resetChanges", "toStorage", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageImpl;", "updateChangeLog", "updater", "updateComposedIds", "beforePersistentId", "Lcom/intellij/workspaceModel/storage/PersistentEntityId;", "newPersistentId", "updateEntityRefs", "entityId", "updatedChildren", "", "updatedParents", "updatePersistentIdIndexes", "updatedEntity", "find", "Lcom/google/common/collect/ArrayListMultimap;", "", "storage", "hasPersistentId", "identificator", "ChangeEntry", "Companion", "EntityDataChange", "intellij.platform.workspaceModel.storage"})
public final class WorkspaceEntityStorageBuilderImpl
extends AbstractEntityStorage
implements WorkspaceEntityStorageBuilder {
    private final List<ChangeEntry> changeLogImpl;
    private long modificationCount;
    @NotNull
    private final MutableEntitiesBarrel entitiesByType;
    @NotNull
    private final MutableRefsTable refs;
    @NotNull
    private final MutableStorageIndexes indexes;
    private static final Logger LOG;
    public static final Companion Companion;

    private final List<ChangeEntry> getChangeLog() {
        return this.changeLogImpl;
    }

    private final void updateChangeLog(Function1<? super List<ChangeEntry>, Unit> updater2) {
        int $i$f$updateChangeLog = 0;
        updater2.invoke((Object)this.changeLogImpl);
        this.incModificationCount$intellij_platform_workspaceModel_storage();
    }

    public final void incModificationCount$intellij_platform_workspaceModel_storage() {
        long l = this.getModificationCount();
        this.modificationCount = l + 1L;
    }

    @Override
    public long getModificationCount() {
        return this.modificationCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <M extends ModifiableWorkspaceEntity<T>, T extends WorkspaceEntity> T addEntity(@NotNull Class<M> clazz, @NotNull EntitySource source, @NotNull Function1<? super M, Unit> initializer) {
        ModifiableWorkspaceEntity modifiableEntity;
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(initializer, (String)"initializer");
        Class unmodifiableEntityClass = JvmClassMappingKt.getJavaClass(ClassConversion.INSTANCE.modifiableEntityToEntity(JvmClassMappingKt.getKotlinClass(clazz)));
        KClass entityDataClass = ClassConversion.INSTANCE.entityToEntityData(JvmClassMappingKt.getKotlinClass((Class)unmodifiableEntityClass));
        int unmodifiableEntityClassId = ClassToIntConverterKt.toClassId(unmodifiableEntityClass);
        WorkspaceEntityData pEntityData = (WorkspaceEntityData)JvmClassMappingKt.getJavaClass(entityDataClass).newInstance();
        pEntityData.setEntitySource(source);
        MutableEntitiesBarrel mutableEntitiesBarrel = this.getEntitiesByType$intellij_platform_workspaceModel_storage();
        WorkspaceEntityData workspaceEntityData = pEntityData;
        Intrinsics.checkExpressionValueIsNotNull((Object)workspaceEntityData, (String)"pEntityData");
        mutableEntitiesBarrel.add(workspaceEntityData, unmodifiableEntityClassId);
        ModifiableWorkspaceEntity modifiableWorkspaceEntity = pEntityData.wrapAsModifiable$intellij_platform_workspaceModel_storage(this);
        if (modifiableWorkspaceEntity == null) {
            throw new TypeCastException("null cannot be cast to non-null type M");
        }
        ModifiableWorkspaceEntity modifiableWorkspaceEntity2 = modifiableEntity = modifiableWorkspaceEntity;
        if (modifiableWorkspaceEntity2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.ModifiableWorkspaceEntityBase<*>");
        }
        ModifiableWorkspaceEntityBase this_$iv = (ModifiableWorkspaceEntityBase)modifiableWorkspaceEntity2;
        boolean $i$f$allowModifications$intellij_platform_workspaceModel_storage = false;
        this_$iv.getModifiable$intellij_platform_workspaceModel_storage().set(true);
        try {
            boolean bl = false;
            initializer.invoke(modifiableEntity);
        }
        finally {
            this_$iv.getModifiable$intellij_platform_workspaceModel_storage().remove();
        }
        PersistentEntityId<?> persistentEntityId = EntitiesKt.persistentId(pEntityData, this);
        if (persistentEntityId != null) {
            PersistentEntityId<?> persistentEntityId2 = persistentEntityId;
            boolean bl = false;
            boolean bl2 = false;
            PersistentEntityId<?> persistentId = persistentEntityId2;
            boolean bl3 = false;
            if (this.getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(persistentId) != null) {
                this.getEntitiesByType$intellij_platform_workspaceModel_storage().remove(pEntityData.getId(), unmodifiableEntityClassId);
                throw (Throwable)new PersistentIdAlreadyExistsException(persistentId);
            }
        }
        this.createAddEvent$intellij_platform_workspaceModel_storage(pEntityData);
        this.getIndexes$intellij_platform_workspaceModel_storage().entityAdded(pEntityData, this);
        this.assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage();
        return (T)pEntityData.createEntity(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <M extends ModifiableWorkspaceEntity<T>, T extends WorkspaceEntity> T modifyEntity(@NotNull Class<M> clazz, @NotNull T e, @NotNull Function1<? super M, Unit> change) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull(e, (String)"e");
        Intrinsics.checkParameterIsNotNull(change, (String)"change");
        WorkspaceEntityData<?> workspaceEntityData = this.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityDataForModification(((WorkspaceEntityBase)e).getId$intellij_platform_workspaceModel_storage());
        if (workspaceEntityData == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<T>");
        }
        WorkspaceEntityData<?> copiedData = workspaceEntityData;
        Object backup = copiedData.clone();
        ModifiableWorkspaceEntity<?> modifiableWorkspaceEntity = copiedData.wrapAsModifiable$intellij_platform_workspaceModel_storage(this);
        if (modifiableWorkspaceEntity == null) {
            throw new TypeCastException("null cannot be cast to non-null type M");
        }
        ModifiableWorkspaceEntity<?> modifiableEntity = modifiableWorkspaceEntity;
        PersistentEntityId<?> beforePersistentId = e instanceof WorkspaceEntityWithPersistentId ? ((WorkspaceEntityWithPersistentId)e).persistentId() : null;
        EntityId pid = ((WorkspaceEntityBase)e).getId$intellij_platform_workspaceModel_storage();
        Map<ConnectionId, EntityId> beforeParents = this.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(pid);
        Map<ConnectionId, Set<EntityId>> $this$flatMap$iv = this.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(pid);
        boolean $i$f$flatMap = false;
        Map<ConnectionId, Set<EntityId>> map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var16_18 = $this$flatMapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var16_18.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry $dstr$key$value = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$key$value;
            boolean bl3 = false;
            ConnectionId connectionId = (ConnectionId)entry.getKey();
            entry = $dstr$key$value;
            bl3 = false;
            Set value2 = (Set)entry.getValue();
            Iterable $this$map$iv = value2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                void key;
                EntityId entityId = (EntityId)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                Pair pair = TuplesKt.to((Object)key, (Object)it);
                collection.add(pair);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List beforeChildren = (List)destination$iv$iv;
        ModifiableWorkspaceEntity<?> modifiableWorkspaceEntity2 = modifiableEntity;
        if (modifiableWorkspaceEntity2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.ModifiableWorkspaceEntityBase<*>");
        }
        ModifiableWorkspaceEntityBase this_$iv = (ModifiableWorkspaceEntityBase)modifiableWorkspaceEntity2;
        boolean $i$f$allowModifications$intellij_platform_workspaceModel_storage = false;
        this_$iv.getModifiable$intellij_platform_workspaceModel_storage().set(true);
        try {
            boolean bl5 = false;
            change.invoke(modifiableEntity);
        }
        finally {
            this_$iv.getModifiable$intellij_platform_workspaceModel_storage().remove();
        }
        if (beforePersistentId != null) {
            PersistentEntityId<?> persistentEntityId = EntitiesKt.persistentId(copiedData, this);
            if (persistentEntityId == null) {
                String string = "Persistent id expected";
                boolean bl6 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            PersistentEntityId<?> newPersistentId = persistentEntityId;
            if (Intrinsics.areEqual(beforePersistentId, newPersistentId) ^ true && this.getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(newPersistentId) != null) {
                EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage().get(((WorkspaceEntityBase)e).getId$intellij_platform_workspaceModel_storage().getClazz());
                if (entityFamily == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.MutableEntityFamily<T>");
                }
                ((MutableEntityFamily)entityFamily).set(((WorkspaceEntityBase)e).getId$intellij_platform_workspaceModel_storage().getArrayId(), backup);
                throw (Throwable)new PersistentIdAlreadyExistsException(newPersistentId);
            }
        }
        this.addReplaceEvent(pid, beforeChildren, beforeParents, copiedData);
        Object updatedEntity = copiedData.createEntity(this);
        this.updatePersistentIdIndexes((WorkspaceEntity)updatedEntity, beforePersistentId, (WorkspaceEntityData<T>)copiedData);
        this.assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage();
        return (T)updatedEntity;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends WorkspaceEntity> void addReplaceEvent(EntityId pid, List<Pair<ConnectionId, EntityId>> beforeChildren, Map<ConnectionId, EntityId> beforeParents, WorkspaceEntityData<T> copiedData) {
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Map<ConnectionId, EntityId> parents2 = this.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(pid);
        Map<ConnectionId, Set<EntityId>> $this$flatMap$iv = this.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(pid);
        boolean $i$f$flatMap = false;
        Map<ConnectionId, Set<EntityId>> map2 = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        void var12_13 = $this$flatMapTo$iv$iv;
        boolean bl = false;
        Object object = var12_13.entrySet().iterator();
        while (object.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry $dstr$key$value = element$iv$iv = object.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$key$value;
            boolean bl3 = false;
            ConnectionId connectionId = (ConnectionId)entry.getKey();
            entry = $dstr$key$value;
            bl3 = false;
            Set value2 = (Set)entry.getValue();
            Iterable $this$map$iv = value2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                void key;
                EntityId entityId = (EntityId)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                Pair pair = TuplesKt.to((Object)key, (Object)it);
                collection.add(pair);
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List children2 = (List)destination$iv$iv;
        List addedChildren = CollectionsKt.toList((Iterable)SetsKt.minus((Set)CollectionsKt.toSet((Iterable)children2), (Iterable)CollectionsKt.toSet((Iterable)beforeChildren)));
        List removedChildren = CollectionsKt.toList((Iterable)SetsKt.minus((Set)CollectionsKt.toSet((Iterable)beforeChildren), (Iterable)CollectionsKt.toSet((Iterable)children2)));
        Map parentsMapRes = MapsKt.toMutableMap(beforeParents);
        list$iv$iv = parents2;
        bl = false;
        Iterator<Map.Entry<ConnectionId, EntityId>> $i$f$flatMapTo22 = list$iv$iv.entrySet().iterator();
        while ($i$f$flatMapTo22.hasNext()) {
            void connectionId;
            object = destination$iv$iv = $i$f$flatMapTo22.next();
            boolean element$iv$iv = false;
            list$iv$iv = (ConnectionId)object.getKey();
            object = destination$iv$iv;
            element$iv$iv = false;
            EntityId parentId = (EntityId)object.getValue();
            EntityId existingParent = (EntityId)parentsMapRes.get(connectionId);
            if (existingParent != null) {
                if (Intrinsics.areEqual((Object)existingParent, (Object)parentId)) {
                    parentsMapRes.remove(connectionId, parentId);
                    continue;
                }
                parentsMapRes.put(connectionId, parentId);
                continue;
            }
            parentsMapRes.put(connectionId, parentId);
        }
        Set removedKeys = SetsKt.minus(beforeParents.keySet(), (Iterable)parents2.keySet());
        Iterable $this$forEach$iv = removedKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConnectionId it = (ConnectionId)element$iv;
            boolean bl5 = false;
            parentsMapRes.put(it, null);
        }
        WorkspaceEntityStorageBuilderImpl this_$iv = this;
        boolean $i$f$updateChangeLog = false;
        List it = this_$iv.changeLogImpl;
        boolean bl6 = false;
        it.add(new ChangeEntry.ReplaceEntity<T>(copiedData, addedChildren, removedChildren, parentsMapRes));
        this_$iv.incModificationCount$intellij_platform_workspaceModel_storage();
    }

    private final <T extends WorkspaceEntity> void updatePersistentIdIndexes(WorkspaceEntity updatedEntity, PersistentEntityId<?> beforePersistentId, WorkspaceEntityData<T> copiedData) {
        WorkspaceEntity workspaceEntity = updatedEntity;
        if (workspaceEntity == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
        }
        EntityId pid = ((WorkspaceEntityBase)workspaceEntity).getId$intellij_platform_workspaceModel_storage();
        if (updatedEntity instanceof WorkspaceEntityWithPersistentId) {
            PersistentEntityId<?> newPersistentId = ((WorkspaceEntityWithPersistentId)updatedEntity).persistentId();
            if (beforePersistentId != null && Intrinsics.areEqual(beforePersistentId, newPersistentId) ^ true) {
                ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(pid, newPersistentId);
                this.updateComposedIds(beforePersistentId, newPersistentId);
            }
        }
        this.getIndexes$intellij_platform_workspaceModel_storage().simpleUpdateSoftReferences(copiedData);
    }

    private final void updateComposedIds(PersistentEntityId<?> beforePersistentId, PersistentEntityId<?> newPersistentId) {
        HashSet idsWithSoftRef = new HashSet(this.getIndexes$intellij_platform_workspaceModel_storage().getSoftLinks$intellij_platform_workspaceModel_storage().getValues(beforePersistentId));
        for (EntityId entityId : idsWithSoftRef) {
            MutableEntitiesBarrel mutableEntitiesBarrel = this.getEntitiesByType$intellij_platform_workspaceModel_storage();
            EntityId entityId2 = entityId;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityId2, (String)"entityId");
            WorkspaceEntityData<?> entity = mutableEntitiesBarrel.getEntityDataForModification(entityId2);
            PersistentEntityId<?> editingBeforePersistentId = EntitiesKt.persistentId(entity, this);
            WorkspaceEntityData<?> workspaceEntityData = entity;
            if (workspaceEntityData == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.SoftLinkable");
            }
            ((SoftLinkable)((Object)workspaceEntityData)).updateLink(beforePersistentId, newPersistentId);
            WorkspaceEntityStorageBuilderImpl this_$iv = this;
            boolean $i$f$updateChangeLog = false;
            List it = this_$iv.changeLogImpl;
            boolean bl = false;
            it.add(new ChangeEntry.ReplaceEntity(entity, CollectionsKt.emptyList(), CollectionsKt.emptyList(), MapsKt.emptyMap()));
            this_$iv.incModificationCount$intellij_platform_workspaceModel_storage();
            this.updatePersistentIdIndexes((WorkspaceEntity)entity.createEntity(this), editingBeforePersistentId, (WorkspaceEntityData)entity);
        }
    }

    @Override
    @NotNull
    public <T extends WorkspaceEntity> T changeSource(@NotNull T e, @NotNull EntitySource newSource) {
        Intrinsics.checkParameterIsNotNull(e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)newSource, (String)"newSource");
        WorkspaceEntityData<?> workspaceEntityData = this.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityDataForModification(((WorkspaceEntityBase)e).getId$intellij_platform_workspaceModel_storage());
        if (workspaceEntityData == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<T>");
        }
        WorkspaceEntityData<?> copiedData = workspaceEntityData;
        copiedData.setEntitySource(newSource);
        WorkspaceEntityStorageBuilderImpl this_$iv = this;
        boolean $i$f$updateChangeLog = false;
        List it = this_$iv.changeLogImpl;
        boolean bl = false;
        it.add(new ChangeEntry.ReplaceEntity(copiedData, CollectionsKt.emptyList(), CollectionsKt.emptyList(), MapsKt.emptyMap()));
        this_$iv.incModificationCount$intellij_platform_workspaceModel_storage();
        ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(copiedData.createPid$intellij_platform_workspaceModel_storage(), newSource);
        this.assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage();
        return (T)copiedData.createEntity(this);
    }

    @Override
    public void removeEntity(@NotNull WorkspaceEntity e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        WorkspaceEntityBase cfr_ignored_0 = (WorkspaceEntityBase)e;
        Collection<EntityId> removedEntities = this.removeEntity(((WorkspaceEntityBase)e).getId$intellij_platform_workspaceModel_storage());
        WorkspaceEntityStorageBuilderImpl this_$iv = this;
        boolean $i$f$updateChangeLog = false;
        List it = this_$iv.changeLogImpl;
        boolean bl = false;
        Iterable $this$forEach$iv = removedEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityId removedEntityId = (EntityId)element$iv;
            boolean bl2 = false;
            it.add(new ChangeEntry.RemoveEntity(removedEntityId));
        }
        this_$iv.incModificationCount$intellij_platform_workspaceModel_storage();
        this.assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage();
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntity> EntityReference<E> createReference(@NotNull E e) {
        Intrinsics.checkParameterIsNotNull(e, (String)"e");
        return new EntityReferenceImpl(((WorkspaceEntityBase)e).getId$intellij_platform_workspaceModel_storage());
    }

    private final WorkspaceEntityData<? extends WorkspaceEntity> find(@NotNull ArrayListMultimap<Object, WorkspaceEntityData<? extends WorkspaceEntity>> $this$find, WorkspaceEntityData<? extends WorkspaceEntity> entity, AbstractEntityStorage storage) {
        WorkspaceEntityData workspaceEntityData;
        List possibleValues = $this$find.get(this.identificator(entity, storage));
        PersistentEntityId<?> persistentId = EntitiesKt.persistentId(entity, storage);
        if (persistentId != null) {
            List list2 = possibleValues;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"possibleValues");
            workspaceEntityData = (WorkspaceEntityData)CollectionsKt.singleOrNull((List)list2);
        } else {
            Object v3;
            block3: {
                List list3 = possibleValues;
                Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"possibleValues");
                Iterable iterable = list3;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    WorkspaceEntityData it = (WorkspaceEntityData)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it, entity)) continue;
                    v3 = t;
                    break block3;
                }
                v3 = null;
            }
            workspaceEntityData = v3;
        }
        return workspaceEntityData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void replaceBySource(@NotNull Function1<? super EntitySource, Boolean> sourceFilter, @NotNull WorkspaceEntityStorage replaceWith) {
        Map.Entry<ConnectionId, Set<EntityId>> this_$iv;
        void $this$filterTo$iv$iv;
        Iterator $this$filterTo$iv$iv2;
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull(sourceFilter, (String)"sourceFilter");
        Intrinsics.checkParameterIsNotNull((Object)replaceWith, (String)"replaceWith");
        AbstractEntityStorage cfr_ignored_0 = (AbstractEntityStorage)replaceWith;
        this.assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage();
        ((AbstractEntityStorage)replaceWith).assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage();
        Logger $this$debug$iv = LOG;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            object2 = $this$debug$iv;
            boolean bl = false;
            object = "Performing replace by source";
            object2.debug((String)object, (Throwable)e$iv);
        }
        ArrayListMultimap localMatchedEntities = ArrayListMultimap.create();
        ArrayListMultimap replaceWithMatchedEntities = ArrayListMultimap.create();
        ArrayListMultimap localUnmatchedReferencedNodes = ArrayListMultimap.create();
        HashBiMap replaceMap = HashBiMap.create();
        Logger $this$debug$iv2 = LOG;
        Exception e$iv2 = null;
        boolean $i$f$debug232 = false;
        if ($this$debug$iv2.isDebugEnabled()) {
            object2 = $this$debug$iv2;
            boolean bl = false;
            object = "1) Traverse all entities and store matched only";
            object2.debug((String)object, (Throwable)e$iv2);
        }
        Iterable $this$filter$iv = this.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().entries$intellij_platform_workspaceModel_storage();
        boolean $i$f$filter = false;
        Iterable $i$f$debug232 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            EntitySource it = (EntitySource)element$iv$iv;
            boolean bl4 = false;
            if (!((Boolean)sourceFilter.invoke((Object)it)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Unit unit;
            EntitySource entitySource = (EntitySource)element$iv;
            boolean bl = false;
            List<EntityId> list2 = this.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(entitySource);
            if (list2 != null) {
                Iterable $this$forEach$iv2 = list2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    EntityId it = (EntityId)element$iv2;
                    boolean bl2 = false;
                    WorkspaceEntityData<? extends WorkspaceEntity> entityData = this.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(it);
                    localMatchedEntities.put(this.identificator(entityData, this), entityData);
                }
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        Logger $this$debug$iv3 = LOG;
        Exception e$iv22 = null;
        boolean $i$f$debug3 = false;
        if ($this$debug$iv3.isDebugEnabled()) {
            object2 = $this$debug$iv3;
            boolean bl3 = false;
            object = "1.1) Cleanup references";
            object2.debug((String)object, (Throwable)e$iv22);
        }
        for (WorkspaceEntityData matchedEntityData : localMatchedEntities.values()) {
            Object parentEntity;
            EntityId entityId = matchedEntityData.createPid$intellij_platform_workspaceModel_storage();
            Map<ConnectionId, EntityId> map2 = this.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(entityId);
            boolean $this$forEach$iv2 = false;
            Iterator<Map.Entry<ConnectionId, Object>> entitySource = map2.entrySet().iterator();
            while (entitySource.hasNext()) {
                Map.Entry<ConnectionId, EntityId> bl3;
                Map.Entry<ConnectionId, EntityId> $i$f$forEach2 = bl3 = entitySource.next();
                boolean bl4 = false;
                ConnectionId connectionId = $i$f$forEach2.getKey();
                $i$f$forEach2 = bl3;
                bl4 = false;
                EntityId parentId = $i$f$forEach2.getValue();
                parentEntity = this.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(parentId);
                if (((Boolean)sourceFilter.invoke((Object)((WorkspaceEntityData)parentEntity).getEntitySource())).booleanValue()) {
                    this.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef(connectionId, parentId, entityId);
                    continue;
                }
                localUnmatchedReferencedNodes.put(this.identificator((WorkspaceEntityData<?>)parentEntity, this), parentEntity);
            }
            Map<ConnectionId, Set<EntityId>> map3 = this.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(entityId);
            boolean parentId = false;
            entitySource = map3.entrySet().iterator();
            while (entitySource.hasNext()) {
                Map.Entry<ConnectionId, Object> bl3;
                parentEntity = bl3 = entitySource.next();
                boolean bl4 = false;
                ConnectionId connectionId = parentEntity.getKey();
                parentEntity = bl3;
                bl4 = false;
                Set childrenIds = (Set)parentEntity.getValue();
                for (EntityId childId : childrenIds) {
                    WorkspaceEntityData<? extends WorkspaceEntity> childEntity = this.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(childId);
                    if (((Boolean)sourceFilter.invoke((Object)childEntity.getEntitySource())).booleanValue()) {
                        this.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef(connectionId, entityId, childId);
                        continue;
                    }
                    localUnmatchedReferencedNodes.put(this.identificator(childEntity, this), childEntity);
                }
            }
        }
        $this$debug$iv3 = LOG;
        Object e$iv3 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug$iv3.isDebugEnabled()) {
            object2 = $this$debug$iv3;
            boolean bl = false;
            object = "2) Traverse entities of replaceWith store";
            object2.debug((String)object, (Throwable)e$iv3);
        }
        Iterable $this$filter$iv2 = ((AbstractEntityStorage)replaceWith).getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().entries$intellij_platform_workspaceModel_storage();
        boolean $i$f$filter2 = false;
        Iterable entitySource = $this$filter$iv2;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EntitySource it = (EntitySource)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)sourceFilter.invoke((Object)it)).booleanValue()) continue;
            collection.add(element$iv$iv);
        }
        for (EntitySource replaceWithEntitySource : (List)collection) {
            List<EntityId> list3 = ((AbstractEntityStorage)replaceWith).getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(replaceWithEntitySource);
            if (list3 == null) continue;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : iterable) {
                void it;
                EntityId bl = (EntityId)item$iv$iv;
                object2 = destination$iv$iv3;
                boolean bl5 = false;
                object = ((AbstractEntityStorage)replaceWith).entityDataByIdOrDie$intellij_platform_workspaceModel_storage((EntityId)it);
                object2.add(object);
            }
            List entityDataList = (List)destination$iv$iv3;
            for (WorkspaceEntityData matchedEntityData : entityDataList) {
                PersistentEntityId<?> persistentEntityId;
                PersistentEntityId<?> persistentEntityId2;
                Unit unit;
                PersistentEntityId<?> $this$forEach$iv3;
                boolean bl;
                replaceWithMatchedEntities.put(this.identificator(matchedEntityData, (AbstractEntityStorage)replaceWith), (Object)matchedEntityData);
                ArrayListMultimap arrayListMultimap = localMatchedEntities;
                Intrinsics.checkExpressionValueIsNotNull((Object)arrayListMultimap, (String)"localMatchedEntities");
                WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = this.find((ArrayListMultimap<Object, WorkspaceEntityData<? extends WorkspaceEntity>>)arrayListMultimap, matchedEntityData, (AbstractEntityStorage)replaceWith);
                EntityId oldPid = matchedEntityData.createPid$intellij_platform_workspaceModel_storage();
                if (workspaceEntityData != null) {
                    HashBiMap hashBiMap = replaceMap;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hashBiMap, (String)"replaceMap");
                    ((Map)hashBiMap).put(workspaceEntityData.createPid$intellij_platform_workspaceModel_storage(), oldPid);
                    if (this.hasPersistentId(workspaceEntityData) && Intrinsics.areEqual(workspaceEntityData, (Object)matchedEntityData) ^ true) {
                        EntitySource entitySource2;
                        Unit unit2;
                        boolean $i$f$forEach3;
                        PersistentEntityId<?> persistentIdBefore;
                        Object clonedEntity = matchedEntityData.clone();
                        if (EntitiesKt.persistentId(matchedEntityData, replaceWith) == null) {
                            Void void_ = ReplaceBySourceExceptionKt.rbsFailed("PersistentId expected");
                            throw null;
                        }
                        ((WorkspaceEntityData)clonedEntity).setId(workspaceEntityData.getId());
                        Object object3 = clonedEntity;
                        if (object3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<com.intellij.workspaceModel.storage.WorkspaceEntity>");
                        }
                        this.getEntitiesByType$intellij_platform_workspaceModel_storage().replaceById(object3, ((WorkspaceEntityData)clonedEntity).createPid$intellij_platform_workspaceModel_storage().getClazz());
                        EntityId pid = ((WorkspaceEntityData)clonedEntity).createPid$intellij_platform_workspaceModel_storage();
                        Map<ConnectionId, EntityId> parents2 = this.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(pid);
                        Map<ConnectionId, Set<EntityId>> children2 = this.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(pid);
                        this.updatePersistentIdIndexes((WorkspaceEntity)((WorkspaceEntityData)clonedEntity).createEntity(this), persistentIdBefore, (WorkspaceEntityData)clonedEntity);
                        Set<VirtualFileUrl> set = ((AbstractEntityStorage)replaceWith).getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage().getVirtualFiles$intellij_platform_workspaceModel_storage(oldPid);
                        if (set != null) {
                            Iterable $this$forEach$iv4 = set;
                            $i$f$forEach3 = false;
                            for (Object element$iv : $this$forEach$iv4) {
                                VirtualFileUrl it = (VirtualFileUrl)element$iv;
                                boolean bl2 = false;
                                this.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage().index$intellij_platform_workspaceModel_storage(pid, CollectionsKt.listOf((Object)it));
                            }
                            unit2 = Unit.INSTANCE;
                        } else {
                            unit2 = null;
                        }
                        if (((AbstractEntityStorage)replaceWith).getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(oldPid) != null) {
                            EntitySource $this$forEach$iv4;
                            $i$f$forEach3 = false;
                            boolean bl3 = false;
                            EntitySource it = $this$forEach$iv4;
                            boolean bl6 = false;
                            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(pid, it);
                            entitySource2 = $this$forEach$iv4;
                        } else {
                            entitySource2 = null;
                        }
                        WorkspaceEntityStorageBuilderImpl this_$iv2 = this;
                        boolean $i$f$updateChangeLog2 = false;
                        List it = this_$iv2.changeLogImpl;
                        bl = false;
                        it.add(new ChangeEntry.ReplaceEntity(clonedEntity, CollectionsKt.emptyList(), CollectionsKt.emptyList(), MapsKt.emptyMap()));
                        this_$iv2.incModificationCount$intellij_platform_workspaceModel_storage();
                    }
                    localMatchedEntities.remove(this.identificator(workspaceEntityData, this), workspaceEntityData);
                    continue;
                }
                int entityClass = ClassToIntConverterKt.toClassId(ClassConversion.INSTANCE.entityDataToEntity(matchedEntityData.getClass()));
                WorkspaceEntityData workspaceEntityData2 = matchedEntityData;
                if (workspaceEntityData2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<com.intellij.workspaceModel.storage.WorkspaceEntity>");
                }
                WorkspaceEntityData newEntity2 = this.getEntitiesByType$intellij_platform_workspaceModel_storage().cloneAndAdd(workspaceEntityData2, entityClass);
                EntityId newPid = newEntity2.createPid$intellij_platform_workspaceModel_storage();
                HashBiMap hashBiMap = replaceMap;
                Intrinsics.checkExpressionValueIsNotNull((Object)hashBiMap, (String)"replaceMap");
                ((Map)hashBiMap).put(newPid, oldPid);
                Set<VirtualFileUrl> set = ((AbstractEntityStorage)replaceWith).getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage().getVirtualFiles$intellij_platform_workspaceModel_storage(oldPid);
                if (set != null) {
                    $this$forEach$iv3 = set;
                    boolean $i$f$forEach4 = false;
                    Iterator iterator3 = $this$forEach$iv3.iterator();
                    while (iterator3.hasNext()) {
                        Object element$iv = iterator3.next();
                        VirtualFileUrl it = (VirtualFileUrl)element$iv;
                        bl = false;
                        this.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage().index$intellij_platform_workspaceModel_storage(newPid, CollectionsKt.listOf((Object)it));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (((AbstractEntityStorage)replaceWith).getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(oldPid) != null) {
                    boolean $i$f$forEach4 = false;
                    boolean bl4 = false;
                    PersistentEntityId<?> it = $this$forEach$iv3;
                    boolean bl7 = false;
                    ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(newPid, it);
                    persistentEntityId2 = $this$forEach$iv3;
                } else {
                    persistentEntityId2 = null;
                }
                if (((AbstractEntityStorage)replaceWith).getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(oldPid) != null) {
                    boolean $i$f$forEach4 = false;
                    boolean bl5 = false;
                    PersistentEntityId<?> it = $this$forEach$iv3;
                    boolean bl8 = false;
                    ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(newPid, it);
                    persistentEntityId = $this$forEach$iv3;
                } else {
                    persistentEntityId = null;
                }
                if (newEntity2 instanceof SoftLinkable) {
                    this.getIndexes$intellij_platform_workspaceModel_storage().updateSoftLinksIndex((SoftLinkable)((Object)newEntity2));
                }
                this.createAddEvent$intellij_platform_workspaceModel_storage(newEntity2);
            }
        }
        $this$debug$iv3 = LOG;
        e$iv3 = null;
        $i$f$debug = false;
        if ($this$debug$iv3.isDebugEnabled()) {
            object2 = $this$debug$iv3;
            boolean bl = false;
            object = "3) Remove old entities";
            object2.debug((String)object, (Throwable)e$iv3);
        }
        for (WorkspaceEntityData localEntity : localMatchedEntities.values()) {
            int entityClass = ClassToIntConverterKt.toClassId(ClassConversion.INSTANCE.entityDataToEntity(localEntity.getClass()));
            this.getEntitiesByType$intellij_platform_workspaceModel_storage().remove(localEntity.getId(), entityClass);
            EntityId entityId = localEntity.createPid$intellij_platform_workspaceModel_storage();
            this.getIndexes$intellij_platform_workspaceModel_storage().removeFromIndices(entityId);
            if (localEntity instanceof SoftLinkable) {
                this.getIndexes$intellij_platform_workspaceModel_storage().removeFromSoftLinksIndex((SoftLinkable)((Object)localEntity));
            }
            this_$iv = this;
            boolean bl = false;
            List it = ((WorkspaceEntityStorageBuilderImpl)((Object)this_$iv)).changeLogImpl;
            boolean bl6 = false;
            it.add(new ChangeEntry.RemoveEntity(entityId));
            ((WorkspaceEntityStorageBuilderImpl)((Object)this_$iv)).incModificationCount$intellij_platform_workspaceModel_storage();
        }
        $this$debug$iv3 = LOG;
        e$iv3 = null;
        $i$f$debug = false;
        if ($this$debug$iv3.isDebugEnabled()) {
            object2 = $this$debug$iv3;
            boolean bl = false;
            object = "4) Restore references between matched and unmatched entities";
            object2.debug((String)object, (Throwable)e$iv3);
        }
        for (WorkspaceEntityData localUnmatchedEntity : localUnmatchedReferencedNodes.values()) {
            Object connectionId;
            Object connectionId2;
            Iterator<Map.Entry<ConnectionId, Object>> connectionId3;
            EntityId unmatchedId = localUnmatchedEntity.createPid$intellij_platform_workspaceModel_storage();
            WorkspaceEntityData<? extends WorkspaceEntity> replaceWithUnmatchedEntity = ((AbstractEntityStorage)replaceWith).entityDataById$intellij_platform_workspaceModel_storage(unmatchedId);
            if (replaceWithUnmatchedEntity == null) {
                Object connectionId4;
                Object it = this.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(unmatchedId);
                boolean bl6 = false;
                Iterator<Map.Entry<ConnectionId, EntityId>> iterator4 = it.entrySet().iterator();
                while (iterator4.hasNext()) {
                    Map.Entry<ConnectionId, Set<EntityId>> newEntity2 = this_$iv = iterator4.next();
                    boolean newPid = false;
                    it = (ConnectionId)newEntity2.getKey();
                    newEntity2 = this_$iv;
                    newPid = false;
                    EntityId parentId = (EntityId)newEntity2.getValue();
                    WorkspaceEntityData<? extends WorkspaceEntity> parent = this.entityDataById$intellij_platform_workspaceModel_storage(parentId);
                    if (parent != null) continue;
                    if (((ConnectionId)connectionId4).canRemoveParent()) {
                        this.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)connectionId4, parentId, unmatchedId);
                        continue;
                    }
                    Void void_ = ReplaceBySourceExceptionKt.rbsFailed("Cannot link old entity to the new one");
                    throw null;
                }
                connectionId4 = this.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(unmatchedId);
                boolean parentId = false;
                Iterator<Map.Entry<ConnectionId, Set<EntityId>>> iterator5 = connectionId4.entrySet().iterator();
                while (iterator5.hasNext()) {
                    Map.Entry<ConnectionId, Set<EntityId>> parent = this_$iv = iterator5.next();
                    boolean newPid = false;
                    connectionId4 = parent.getKey();
                    parent = this_$iv;
                    newPid = false;
                    Set<EntityId> childIds = parent.getValue();
                    for (EntityId childId : childIds) {
                        WorkspaceEntityData<? extends WorkspaceEntity> child2 = this.entityDataById$intellij_platform_workspaceModel_storage(childId);
                        if (child2 != null) continue;
                        if (((ConnectionId)((Object)connectionId3)).canRemoveChild()) {
                            this.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)((Object)connectionId3), unmatchedId, childId);
                            continue;
                        }
                        Void void_ = ReplaceBySourceExceptionKt.rbsFailed("Cannot link old entity to the new one");
                        throw null;
                    }
                }
                continue;
            }
            ArrayList<Pair> removedConnections = new ArrayList<Pair>();
            Object childIds = this.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(unmatchedId);
            boolean childId = false;
            connectionId3 = childIds.entrySet().iterator();
            while (connectionId3.hasNext()) {
                Map.Entry<ConnectionId, EntityId> entry;
                Map.Entry<ConnectionId, EntityId> newPid = entry = connectionId3.next();
                boolean bl = false;
                childIds = newPid.getKey();
                newPid = entry;
                bl = false;
                EntityId parentId = newPid.getValue();
                WorkspaceEntityData<? extends WorkspaceEntity> parentData = this.entityDataById$intellij_platform_workspaceModel_storage(parentId);
                if (parentData != null && !((Boolean)sourceFilter.invoke((Object)parentData.getEntitySource())).booleanValue()) continue;
                this.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)connectionId2, parentId, unmatchedId);
                removedConnections.add(TuplesKt.to((Object)connectionId2, (Object)parentId));
            }
            connectionId2 = ((AbstractEntityStorage)replaceWith).getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(unmatchedId);
            boolean parentId = false;
            connectionId3 = connectionId2.entrySet().iterator();
            while (connectionId3.hasNext()) {
                Map.Entry<ConnectionId, EntityId> entry;
                Map.Entry<ConnectionId, EntityId> parentData = entry = connectionId3.next();
                boolean bl = false;
                connectionId2 = parentData.getKey();
                parentData = entry;
                bl = false;
                EntityId parentId2 = parentData.getValue();
                if (!((Boolean)sourceFilter.invoke((Object)((AbstractEntityStorage)replaceWith).entityDataByIdOrDie$intellij_platform_workspaceModel_storage(parentId2).getEntitySource())).booleanValue()) continue;
                BiMap biMap = replaceMap.inverse();
                Intrinsics.checkExpressionValueIsNotNull((Object)biMap, (String)"replaceMap.inverse()");
                EntityId localParentId = (EntityId)MapsKt.getValue((Map)((Map)biMap), (Object)parentId2);
                MutableRefsTable mutableRefsTable = this.getRefs$intellij_platform_workspaceModel_storage();
                EntityId entityId = localParentId;
                Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"localParentId");
                mutableRefsTable.updateParentOfChild$intellij_platform_workspaceModel_storage((ConnectionId)connectionId, unmatchedId, entityId);
                removedConnections.remove(TuplesKt.to((Object)connectionId, (Object)parentId2));
            }
            for (Pair pair : removedConnections) {
                connectionId = (ConnectionId)pair.component1();
                EntityId parentId3 = (EntityId)pair.component2();
                if (((ConnectionId)connectionId).canRemoveParent()) continue;
                Void void_ = ReplaceBySourceExceptionKt.rbsFailed("Cannot restore connection to " + parentId3);
                throw null;
            }
            connectionId = this.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(unmatchedId);
            boolean parentId3 = false;
            connectionId3 = connectionId.entrySet().iterator();
            while (connectionId3.hasNext()) {
                Map.Entry<ConnectionId, EntityId> entry;
                Map.Entry<ConnectionId, EntityId> localParentId = entry = connectionId3.next();
                boolean bl = false;
                connectionId = localParentId.getKey();
                localParentId = entry;
                bl = false;
                Set childrenId = (Set)((Object)localParentId.getValue());
                for (Object childId22 : childrenId) {
                    WorkspaceEntityData<? extends WorkspaceEntity> childData = this.entityDataById$intellij_platform_workspaceModel_storage((EntityId)childId22);
                    if (childData != null && !((Boolean)sourceFilter.invoke((Object)childData.getEntitySource())).booleanValue()) continue;
                    this.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)connectionId, unmatchedId, (EntityId)childId22);
                }
            }
            connectionId = ((AbstractEntityStorage)replaceWith).getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(unmatchedId);
            boolean childrenId = false;
            connectionId3 = connectionId.entrySet().iterator();
            while (connectionId3.hasNext()) {
                Object childId22;
                Map.Entry<ConnectionId, Object> entry = connectionId3.next();
                childId22 = entry;
                boolean bl = false;
                connectionId = childId22.getKey();
                childId22 = entry;
                bl = false;
                Set childrenId2 = (Set)childId22.getValue();
                for (EntityId childId2 : childrenId2) {
                    void connectionId4;
                    if (!((Boolean)sourceFilter.invoke((Object)((AbstractEntityStorage)replaceWith).entityDataByIdOrDie$intellij_platform_workspaceModel_storage(childId2).getEntitySource())).booleanValue()) continue;
                    BiMap biMap = replaceMap.inverse();
                    Intrinsics.checkExpressionValueIsNotNull((Object)biMap, (String)"replaceMap.inverse()");
                    EntityId localChildId = (EntityId)MapsKt.getValue((Map)((Map)biMap), (Object)childId2);
                    MutableRefsTable mutableRefsTable = this.getRefs$intellij_platform_workspaceModel_storage();
                    EntityId entityId = localChildId;
                    Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"localChildId");
                    mutableRefsTable.updateParentOfChild$intellij_platform_workspaceModel_storage((ConnectionId)connectionId4, entityId, unmatchedId);
                }
            }
        }
        $this$debug$iv3 = LOG;
        e$iv3 = null;
        $i$f$debug = false;
        if ($this$debug$iv3.isDebugEnabled()) {
            object2 = $this$debug$iv3;
            boolean bl = false;
            object = "5) Restore references in matching ids";
            object2.debug((String)object, (Throwable)e$iv3);
        }
        for (WorkspaceEntityData rightMatchedNode : replaceWithMatchedEntities.values()) {
            EntityId nodeId = rightMatchedNode.createPid$intellij_platform_workspaceModel_storage();
            Map<ConnectionId, EntityId> map4 = ((AbstractEntityStorage)replaceWith).getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(nodeId);
            boolean connectionId3 = false;
            Iterator<Map.Entry<ConnectionId, EntityId>> iterator4 = map4.entrySet().iterator();
            while (iterator4.hasNext()) {
                Map.Entry<ConnectionId, EntityId> bl;
                Map.Entry<ConnectionId, EntityId> connectionId4 = bl = iterator4.next();
                boolean childrenId2 = false;
                ConnectionId connectionId = connectionId4.getKey();
                connectionId4 = bl;
                childrenId2 = false;
                EntityId parentId = connectionId4.getValue();
                if (!((Boolean)sourceFilter.invoke((Object)((AbstractEntityStorage)replaceWith).entityDataByIdOrDie$intellij_platform_workspaceModel_storage(parentId).getEntitySource())).booleanValue()) {
                    if (connectionId.isParentNullable()) continue;
                    WorkspaceEntityData<? extends WorkspaceEntity> localParent = this.entityDataById$intellij_platform_workspaceModel_storage(parentId);
                    if (localParent == null) {
                        Void void_ = ReplaceBySourceExceptionKt.rbsFailed("Cannot link entities. Child entity doesn't have a parent after operation");
                        throw null;
                    }
                    BiMap biMap = replaceMap.inverse();
                    Intrinsics.checkExpressionValueIsNotNull((Object)biMap, (String)"replaceMap.inverse()");
                    EntityId localChildId = (EntityId)MapsKt.getValue((Map)((Map)biMap), (Object)nodeId);
                    MutableRefsTable mutableRefsTable = this.getRefs$intellij_platform_workspaceModel_storage();
                    EntityId entityId = localChildId;
                    Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"localChildId");
                    mutableRefsTable.updateParentOfChild$intellij_platform_workspaceModel_storage(connectionId, entityId, parentId);
                    continue;
                }
                BiMap biMap = replaceMap.inverse();
                Intrinsics.checkExpressionValueIsNotNull((Object)biMap, (String)"replaceMap.inverse()");
                EntityId localChildId = (EntityId)MapsKt.getValue((Map)((Map)biMap), (Object)nodeId);
                BiMap biMap2 = replaceMap.inverse();
                Intrinsics.checkExpressionValueIsNotNull((Object)biMap2, (String)"replaceMap.inverse()");
                EntityId localParentId = (EntityId)MapsKt.getValue((Map)((Map)biMap2), (Object)parentId);
                MutableRefsTable mutableRefsTable = this.getRefs$intellij_platform_workspaceModel_storage();
                EntityId entityId = localChildId;
                Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"localChildId");
                EntityId entityId2 = localParentId;
                Intrinsics.checkExpressionValueIsNotNull((Object)entityId2, (String)"localParentId");
                mutableRefsTable.updateParentOfChild$intellij_platform_workspaceModel_storage(connectionId, entityId, entityId2);
            }
        }
        this.assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage();
        $this$debug$iv3 = LOG;
        e$iv3 = null;
        $i$f$debug = false;
        if ($this$debug$iv3.isDebugEnabled()) {
            object2 = $this$debug$iv3;
            boolean bl = false;
            object = "Replace by source finished";
            object2.debug((String)object, (Throwable)e$iv3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Class<?>, List<EntityChange<?>>> collectChanges(@NotNull WorkspaceEntityStorage original) {
        void $this$mapValuesTo$iv$iv;
        Object answer$iv$iv$iv;
        Map $this$groupByTo$iv$iv;
        List list2;
        Map map2;
        EntityId entityId;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)original, (String)"original");
        AbstractEntityStorage originalImpl = (AbstractEntityStorage)original;
        LinkedHashMap changes = new LinkedHashMap();
        for (ChangeEntry change : this.getChangeLog()) {
            void $this$findEntityClass$iv;
            Pair oldChange;
            object = change;
            if (object instanceof ChangeEntry.AddEntity) {
                void $this$findEntityClass$iv2;
                Object e = ((ChangeEntry.AddEntity)change).getEntityData().createEntity(this);
                if (e == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                }
                WorkspaceEntityBase addedEntity = (WorkspaceEntityBase)e;
                int n = addedEntity.getId$intellij_platform_workspaceModel_storage().getClazz();
                entityId = addedEntity.getId$intellij_platform_workspaceModel_storage();
                map2 = changes;
                boolean $i$f$findEntityClass = false;
                if (ClassToIntConverter.INSTANCE.getClassOrDie((int)$this$findEntityClass$iv2) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<E>");
                }
                map2.put(entityId, TuplesKt.to(list2, new EntityChange.Added<WorkspaceEntity>(addedEntity)));
                continue;
            }
            if (object instanceof ChangeEntry.RemoveEntity) {
                void $this$findEntityClass$iv3;
                Pair oldChange2;
                WorkspaceEntityData<? extends WorkspaceEntity> removedData = originalImpl.entityDataById$intellij_platform_workspaceModel_storage(((ChangeEntry.RemoveEntity)change).getId());
                Pair pair = oldChange2 = (Pair)changes.remove(((ChangeEntry.RemoveEntity)change).getId());
                if ((pair != null ? (EntityChange)pair.getSecond() : null) instanceof EntityChange.Added || removedData == null) continue;
                WorkspaceEntity workspaceEntity = removedData.createEntity(originalImpl);
                if (workspaceEntity == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                }
                WorkspaceEntityBase removedEntity = (WorkspaceEntityBase)workspaceEntity;
                int n = ((ChangeEntry.RemoveEntity)change).getId().getClazz();
                entityId = removedEntity.getId$intellij_platform_workspaceModel_storage();
                map2 = changes;
                boolean $i$f$findEntityClass = false;
                if (ClassToIntConverter.INSTANCE.getClassOrDie((int)$this$findEntityClass$iv3) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<E>");
                }
                map2.put(entityId, TuplesKt.to(list2, new EntityChange.Removed<WorkspaceEntity>(removedEntity)));
                continue;
            }
            if (!(object instanceof ChangeEntry.ReplaceEntity)) continue;
            EntityId id2 = ((ChangeEntry.ReplaceEntity)change).getNewData().createPid$intellij_platform_workspaceModel_storage();
            Pair pair = oldChange = (Pair)changes.remove(id2);
            if ((pair != null ? (EntityChange)pair.getSecond() : null) instanceof EntityChange.Added) {
                Object e = ((ChangeEntry.ReplaceEntity)change).getNewData().createEntity(this);
                if (e == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
                }
                WorkspaceEntityBase addedEntity = (WorkspaceEntityBase)e;
                int $this$findEntityClass$iv3 = addedEntity.getId$intellij_platform_workspaceModel_storage().getClazz();
                entityId = addedEntity.getId$intellij_platform_workspaceModel_storage();
                map2 = changes;
                boolean $i$f$findEntityClass = false;
                if (ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv3) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<E>");
                }
                map2.put(entityId, TuplesKt.to(list2, new EntityChange.Added<WorkspaceEntity>(addedEntity)));
                continue;
            }
            WorkspaceEntityData<? extends WorkspaceEntity> oldData = originalImpl.entityDataById$intellij_platform_workspaceModel_storage(id2);
            if (oldData == null) continue;
            WorkspaceEntity workspaceEntity = oldData.createEntity(originalImpl);
            if (workspaceEntity == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
            }
            WorkspaceEntityBase replacedData = (WorkspaceEntityBase)workspaceEntity;
            Object e = ((ChangeEntry.ReplaceEntity)change).getNewData().createEntity(this);
            if (e == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase");
            }
            WorkspaceEntityBase replaceToData = (WorkspaceEntityBase)e;
            int n = replacedData.getId$intellij_platform_workspaceModel_storage().getClazz();
            entityId = replacedData.getId$intellij_platform_workspaceModel_storage();
            map2 = changes;
            boolean $i$f$findEntityClass = false;
            if (ClassToIntConverter.INSTANCE.getClassOrDie((int)$this$findEntityClass$iv) == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<E>");
            }
            map2.put(entityId, TuplesKt.to(list2, new EntityChange.Replaced<WorkspaceEntity>(replacedData, replaceToData)));
        }
        Collection collection = changes.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"changes.values");
        Iterable $this$groupBy$iv = collection;
        boolean $i$f$groupBy = false;
        object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator oldData = $this$groupByTo$iv$iv.iterator();
        while (oldData.hasNext()) {
            Object object2;
            Object element$iv$iv = oldData.next();
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            Class key$iv$iv = (Class)it.getFirst();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void list3;
            void it$iv$iv;
            Map.Entry key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            entityId = k;
            map2 = map3;
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)list3.getValue();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl4 = false;
                EntityChange entityChange = (EntityChange)it.getSecond();
                collection2.add(entityChange);
            }
            list2 = (List)destination$iv$iv2;
            map2.put(entityId, list2);
        }
        return destination$iv$iv;
    }

    @Override
    public void resetChanges() {
        WorkspaceEntityStorageBuilderImpl this_$iv = this;
        boolean $i$f$updateChangeLog = false;
        List it = this_$iv.changeLogImpl;
        boolean bl = false;
        it.clear();
        this_$iv.incModificationCount$intellij_platform_workspaceModel_storage();
    }

    @Override
    @NotNull
    public WorkspaceEntityStorageImpl toStorage() {
        ImmutableEntitiesBarrel newEntities = this.getEntitiesByType$intellij_platform_workspaceModel_storage().toImmutable();
        RefsTable newRefs = this.getRefs$intellij_platform_workspaceModel_storage().toImmutable();
        StorageIndexes newIndexes = this.getIndexes$intellij_platform_workspaceModel_storage().toImmutable();
        WorkspaceEntityStorageImpl storage = new WorkspaceEntityStorageImpl(newEntities, newRefs, newIndexes);
        storage.assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage();
        return storage;
    }

    @Override
    public boolean isEmpty() {
        return this.changeLogImpl.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<WorkspaceEntity, WorkspaceEntity> addDiff(@NotNull WorkspaceEntityStorageDiffBuilder diff) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)diff, (String)"diff");
        HashBiMap replaceMap = HashBiMap.create();
        WorkspaceEntityStorageBuilderImpl builder2 = (WorkspaceEntityStorageBuilderImpl)diff;
        List<ChangeEntry> diffLog = builder2.getChangeLog();
        for (ChangeEntry change : diffLog) {
            List<EntityId> existingIds;
            void $this$mapValuesTo$iv$iv;
            Object id2;
            void $this$mapTo$iv$iv;
            Object id3;
            void $this$mapTo$iv$iv2;
            void it$iv$iv;
            Map destination$iv$iv;
            Object object2;
            Object object3;
            Object object4;
            Map.Entry entry;
            ChangeEntry changeEntry = change;
            if (changeEntry instanceof ChangeEntry.AddEntity) {
                void $this$mapValuesTo$iv$iv2;
                Object object5;
                Object element$iv$iv$iv2;
                void $this$mapValuesTo$iv$iv3;
                List<EntityId> existingIds2;
                ChangeEntry changeEntry2 = change;
                if (changeEntry2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageBuilderImpl.ChangeEntry.AddEntity<com.intellij.workspaceModel.storage.WorkspaceEntity>");
                }
                ChangeEntry.AddEntity cfr_ignored_0 = (ChangeEntry.AddEntity)changeEntry2;
                PersistentEntityId<?> newPersistentId = EntitiesKt.persistentId(((ChangeEntry.AddEntity)change).getEntityData(), this);
                if (newPersistentId != null && (existingIds2 = this.getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(newPersistentId)) != null) {
                    object = existingIds2;
                    boolean bl = false;
                    if (!object.isEmpty()) {
                        Void void_ = AddDiffExceptionKt.adFailed("PersistentId already exists: " + newPersistentId);
                        throw null;
                    }
                }
                Map<ConnectionId, Set<EntityId>> $this$mapValues$iv = ((ChangeEntry.AddEntity)change).getChildren();
                boolean $i$f$mapValues = false;
                Map<ConnectionId, Set<EntityId>> map2 = $this$mapValues$iv;
                Map<ConnectionId, EntityId> destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv3.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv2 : $this$associateByTo$iv$iv$iv) {
                    void $this$mapTo$iv$iv3;
                    void it;
                    void it$iv$iv2;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv2;
                    object5 = destination$iv$iv2;
                    boolean bl = false;
                    Object k = it$iv$iv2.getKey();
                    entry = (Map.Entry)element$iv$iv$iv2;
                    object4 = k;
                    object3 = object5;
                    boolean bl2 = false;
                    Iterable $this$map$iv = (Iterable)it.getValue();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        void v;
                        EntityId entityId = (EntityId)item$iv$iv;
                        Collection collection = destination$iv$iv3;
                        boolean bl3 = false;
                        EntityId entityId2 = (EntityId)replaceMap.getOrDefault((Object)v, (Object)v);
                        collection.add(entityId2);
                    }
                    object2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
                    object3.put(object4, object2);
                }
                Map<ConnectionId, EntityId> updatedChildren = destination$iv$iv2;
                Map<ConnectionId, EntityId> $this$mapValues$iv2 = ((ChangeEntry.AddEntity)change).getParents();
                boolean $i$f$mapValues2 = false;
                destination$iv$iv2 = $this$mapValues$iv2;
                destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
                boolean $i$f$mapValuesTo2 = false;
                Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv2.entrySet();
                boolean $i$f$associateByTo2 = false;
                element$iv$iv$iv2 = $this$associateByTo$iv$iv$iv2.iterator();
                while (element$iv$iv$iv2.hasNext()) {
                    void it;
                    Object element$iv$iv$iv3 = element$iv$iv$iv2.next();
                    object5 = (Map.Entry)element$iv$iv$iv3;
                    Map map3 = destination$iv$iv;
                    boolean bl = false;
                    entry = it$iv$iv.getKey();
                    Map.Entry bl2 = (Map.Entry)element$iv$iv$iv3;
                    object4 = entry;
                    object3 = map3;
                    boolean bl4 = false;
                    object2 = (EntityId)replaceMap.getOrDefault(it.getValue(), it.getValue());
                    object3.put(object4, object2);
                }
                Map updatedParents = destination$iv$iv;
                WorkspaceEntityData workspaceEntityData = ((ChangeEntry.AddEntity)change).getEntityData();
                int n = ((ChangeEntry.AddEntity)change).getClazz();
                HashBiMap hashBiMap = replaceMap;
                Intrinsics.checkExpressionValueIsNotNull((Object)hashBiMap, (String)"replaceMap");
                Pair entity2id = this.cloneEntity(workspaceEntityData, n, (Map)hashBiMap);
                this.updateEntityRefs((EntityId)entity2id.getSecond(), updatedChildren, updatedParents);
                this.getIndexes$intellij_platform_workspaceModel_storage().updateIndices(((ChangeEntry.AddEntity)change).getEntityData().createPid$intellij_platform_workspaceModel_storage(), (EntityId)entity2id.getSecond(), builder2);
                WorkspaceEntityStorageBuilderImpl this_$iv = this;
                boolean $i$f$updateChangeLog = false;
                List it = this_$iv.changeLogImpl;
                boolean bl = false;
                it.add(new ChangeEntry.AddEntity((WorkspaceEntityData)entity2id.getFirst(), ((ChangeEntry.AddEntity)change).getClazz(), updatedChildren, updatedParents));
                this_$iv.incModificationCount$intellij_platform_workspaceModel_storage();
                continue;
            }
            if (changeEntry instanceof ChangeEntry.RemoveEntity) {
                EntityId outdatedId = ((ChangeEntry.RemoveEntity)change).getId();
                EntityId usedPid = (EntityId)replaceMap.getOrDefault((Object)outdatedId, (Object)outdatedId);
                MutableStorageIndexes mutableStorageIndexes = this.getIndexes$intellij_platform_workspaceModel_storage();
                EntityId entityId = usedPid;
                Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"usedPid");
                mutableStorageIndexes.removeFromIndices(entityId);
                replaceMap.inverse().remove((Object)usedPid);
                if (this.entityDataById$intellij_platform_workspaceModel_storage(usedPid) != null) {
                    this.removeEntity(usedPid);
                }
                WorkspaceEntityStorageBuilderImpl this_$iv = this;
                boolean $i$f$updateChangeLog = false;
                List it = this_$iv.changeLogImpl;
                boolean bl = false;
                it.add(new ChangeEntry.RemoveEntity(usedPid));
                this_$iv.incModificationCount$intellij_platform_workspaceModel_storage();
                continue;
            }
            if (!(changeEntry instanceof ChangeEntry.ReplaceEntity)) continue;
            ChangeEntry changeEntry3 = change;
            if (changeEntry3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageBuilderImpl.ChangeEntry.ReplaceEntity<com.intellij.workspaceModel.storage.WorkspaceEntity>");
            }
            ChangeEntry.ReplaceEntity cfr_ignored_1 = (ChangeEntry.ReplaceEntity)changeEntry3;
            Iterable $this$map$iv = ((ChangeEntry.ReplaceEntity)change).getNewChildren();
            boolean $i$f$map = false;
            Iterable $i$f$updateChangeLog = $this$map$iv;
            Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void connectionId;
                void $dstr$connectionId$id;
                Pair $this$associateByTo$iv$iv$iv2 = (Pair)item$iv$iv;
                object3 = destination$iv$iv4;
                boolean bl = false;
                ConnectionId element$iv$iv$iv2 = (ConnectionId)$dstr$connectionId$id.component1();
                id3 = (EntityId)$dstr$connectionId$id.component2();
                object4 = TuplesKt.to((Object)connectionId, (Object)replaceMap.getOrDefault(id3, id3));
                object3.add(object4);
            }
            List updatedNewChildren = (List)destination$iv$iv4;
            Iterable $this$map$iv2 = ((ChangeEntry.ReplaceEntity)change).getRemovedChildren();
            boolean $i$f$map2 = false;
            destination$iv$iv4 = $this$map$iv2;
            Object destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void connectionId;
                void $dstr$connectionId$id;
                Pair bl = (Pair)item$iv$iv;
                object3 = destination$iv$iv5;
                boolean bl5 = false;
                id3 = (ConnectionId)$dstr$connectionId$id.component1();
                id2 = (EntityId)$dstr$connectionId$id.component2();
                object4 = TuplesKt.to((Object)connectionId, (Object)replaceMap.getOrDefault(id2, id2));
                object3.add(object4);
            }
            List updatedRemovedChildren = (List)destination$iv$iv5;
            Map<ConnectionId, EntityId> $this$mapValues$iv = ((ChangeEntry.ReplaceEntity)change).getModifiedParents();
            boolean $i$f$mapValues = false;
            destination$iv$iv5 = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv3 : $this$associateByTo$iv$iv$iv) {
                id2 = (Map.Entry)element$iv$iv$iv3;
                Map map4 = destination$iv$iv;
                boolean bl = false;
                entry = it$iv$iv.getKey();
                Map.Entry it = (Map.Entry)element$iv$iv$iv3;
                object4 = entry;
                object3 = map4;
                boolean bl6 = false;
                object2 = it.getValue() == null ? null : (EntityId)replaceMap.getOrDefault(it.getValue(), it.getValue());
                object3.put(object4, object2);
            }
            Map updatedModifiedParents = destination$iv$iv;
            EntityId outdatedId = ((ChangeEntry.ReplaceEntity)change).getNewData().createPid$intellij_platform_workspaceModel_storage();
            EntityId usedPid = (EntityId)replaceMap.getOrDefault((Object)outdatedId, (Object)outdatedId);
            Object newData = ((ChangeEntry.ReplaceEntity)change).getNewData().clone();
            ((WorkspaceEntityData)newData).setId(usedPid.getArrayId());
            PersistentEntityId<?> newPersistentId = EntitiesKt.persistentId(((ChangeEntry.ReplaceEntity)change).getNewData(), this);
            if (newPersistentId != null && (existingIds = this.getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(newPersistentId)) != null) {
                $this$associateByTo$iv$iv$iv = existingIds;
                $i$f$associateByTo = false;
                if (!$this$associateByTo$iv$iv$iv.isEmpty() && Intrinsics.areEqual((Object)((EntityId)CollectionsKt.single(existingIds)), (Object)((WorkspaceEntityData)newData).createPid$intellij_platform_workspaceModel_storage()) ^ true) {
                    Void void_ = AddDiffExceptionKt.adFailed("PersistentId already exists: " + newPersistentId);
                    throw null;
                }
            }
            EntityId entityId = usedPid;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"usedPid");
            if (this.entityDataById$intellij_platform_workspaceModel_storage(entityId) == null) continue;
            this.getIndexes$intellij_platform_workspaceModel_storage().updateIndices(outdatedId, ((WorkspaceEntityData)newData).createPid$intellij_platform_workspaceModel_storage(), builder2);
            WorkspaceEntityStorageBuilderImpl this_$iv = this;
            boolean $i$f$updateChangeLog2 = false;
            List it = this_$iv.changeLogImpl;
            boolean bl = false;
            it.add(new ChangeEntry.ReplaceEntity(newData, updatedNewChildren, updatedRemovedChildren, updatedModifiedParents));
            this_$iv.incModificationCount$intellij_platform_workspaceModel_storage();
            this.replaceEntityWithRefs((WorkspaceEntityData)newData, outdatedId.getClazz(), updatedNewChildren, updatedRemovedChildren, updatedModifiedParents);
        }
        MutableStorageIndexes mutableStorageIndexes = this.getIndexes$intellij_platform_workspaceModel_storage();
        WorkspaceEntityStorageBuilderImpl workspaceEntityStorageBuilderImpl = (WorkspaceEntityStorageBuilderImpl)diff;
        HashBiMap hashBiMap = replaceMap;
        Intrinsics.checkExpressionValueIsNotNull((Object)hashBiMap, (String)"replaceMap");
        mutableStorageIndexes.applyExternalMappingChanges(workspaceEntityStorageBuilderImpl, (HashBiMap<EntityId, EntityId>)hashBiMap);
        HashMap res2 = new HashMap();
        Map $this$forEach$iv = (Map)replaceMap;
        boolean $i$f$forEach = false;
        Map map5 = $this$forEach$iv;
        boolean bl = false;
        object = map5.entrySet().iterator();
        while (object.hasNext()) {
            void oldId;
            Map.Entry element$iv;
            Map.Entry $dstr$oldId$newId = element$iv = object.next();
            boolean bl7 = false;
            Map.Entry entry = $dstr$oldId$newId;
            boolean bl8 = false;
            EntityId $i$f$updateChangeLog2 = (EntityId)entry.getKey();
            entry = $dstr$oldId$newId;
            bl8 = false;
            EntityId newId = (EntityId)entry.getValue();
            if (!(Intrinsics.areEqual((Object)oldId, (Object)newId) ^ true)) continue;
            Map map6 = res2;
            WorkspaceEntityStorageBuilderImpl workspaceEntityStorageBuilderImpl2 = (WorkspaceEntityStorageBuilderImpl)diff;
            void v15 = oldId;
            Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"oldId");
            WorkspaceEntity workspaceEntity = workspaceEntityStorageBuilderImpl2.entityDataByIdOrDie$intellij_platform_workspaceModel_storage((EntityId)v15).createEntity((WorkspaceEntityStorage)((Object)diff));
            EntityId entityId = newId;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"newId");
            map6.put(workspaceEntity, this.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(entityId).createEntity(this));
        }
        this.assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage();
        return res2;
    }

    @Override
    @NotNull
    public <T> MutableExternalEntityMapping<T> getMutableExternalMapping(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        MutableExternalEntityMappingImpl<?> mutableExternalEntityMappingImpl = this.getIndexes$intellij_platform_workspaceModel_storage().getExternalMappings$intellij_platform_workspaceModel_storage().computeIfAbsent(identifier, getMutableExternalMapping.mapping.1.INSTANCE);
        if (mutableExternalEntityMappingImpl == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.external.MutableExternalEntityMappingImpl<T>");
        }
        MutableExternalEntityMappingImpl<?> mapping2 = mutableExternalEntityMappingImpl;
        mapping2.setTypedEntityStorage$intellij_platform_workspaceModel_storage(this);
        return mapping2;
    }

    public final void removeExternalMapping(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        this.getIndexes$intellij_platform_workspaceModel_storage().getExternalMappings$intellij_platform_workspaceModel_storage().remove(identifier);
    }

    private final Collection<EntityId> removeEntity(EntityId idx) {
        Set accumulator = SetsKt.mutableSetOf((Object[])new EntityId[]{idx});
        this.accumulateEntitiesToRemove(idx, accumulator);
        for (EntityId id2 : accumulator) {
            WorkspaceEntityData<? extends WorkspaceEntity> entityData = this.entityDataById$intellij_platform_workspaceModel_storage(id2);
            if (entityData instanceof SoftLinkable) {
                this.getIndexes$intellij_platform_workspaceModel_storage().removeFromSoftLinksIndex((SoftLinkable)((Object)entityData));
            }
            this.getEntitiesByType$intellij_platform_workspaceModel_storage().remove(id2.getArrayId(), id2.getClazz());
        }
        for (EntityId id2 : accumulator) {
            this.getIndexes$intellij_platform_workspaceModel_storage().removeFromIndices(id2);
        }
        return accumulator;
    }

    private final boolean hasPersistentId(@NotNull WorkspaceEntityData<?> $this$hasPersistentId) {
        Object entity = $this$hasPersistentId.createEntity(this);
        return entity instanceof WorkspaceEntityWithPersistentId;
    }

    private final Object identificator(@NotNull WorkspaceEntityData<?> $this$identificator, AbstractEntityStorage storage) {
        PersistentEntityId<?> persistentEntityId = EntitiesKt.persistentId($this$identificator, storage);
        if (persistentEntityId == null) {
            persistentEntityId = $this$identificator.hashCode();
        }
        return persistentEntityId;
    }

    public final <T extends WorkspaceEntity> void createAddEvent$intellij_platform_workspaceModel_storage(@NotNull WorkspaceEntityData<T> pEntityData) {
        Intrinsics.checkParameterIsNotNull(pEntityData, (String)"pEntityData");
        EntityId pid = pEntityData.createPid$intellij_platform_workspaceModel_storage();
        Map<ConnectionId, EntityId> parents2 = this.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(pid);
        Map<ConnectionId, Set<EntityId>> children2 = this.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(pid);
        WorkspaceEntityStorageBuilderImpl this_$iv = this;
        boolean $i$f$updateChangeLog = false;
        List it = this_$iv.changeLogImpl;
        boolean bl = false;
        it.add(new ChangeEntry.AddEntity<T>(pEntityData, pid.getClazz(), children2, parents2));
        this_$iv.incModificationCount$intellij_platform_workspaceModel_storage();
    }

    private final <T extends WorkspaceEntity> Pair<WorkspaceEntityData<T>, EntityId> cloneEntity(WorkspaceEntityData<T> entity, int clazz, Map<EntityId, EntityId> replaceMap) {
        WorkspaceEntityData<T> cloned = this.getEntitiesByType$intellij_platform_workspaceModel_storage().cloneAndAdd(entity, clazz);
        EntityId clonedPid = cloned.createPid$intellij_platform_workspaceModel_storage();
        if (Intrinsics.areEqual((Object)clonedPid, (Object)entity.createPid$intellij_platform_workspaceModel_storage()) ^ true) {
            replaceMap.put(entity.createPid$intellij_platform_workspaceModel_storage(), clonedPid);
        }
        if (cloned instanceof SoftLinkable) {
            this.getIndexes$intellij_platform_workspaceModel_storage().updateSoftLinksIndex((SoftLinkable)((Object)cloned));
        }
        return TuplesKt.to(cloned, (Object)clonedPid);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateEntityRefs(EntityId entityId, Map<ConnectionId, ? extends Set<EntityId>> updatedChildren, Map<ConnectionId, EntityId> updatedParents) {
        Object connectionId;
        Object object;
        Object object2 = updatedChildren;
        boolean bl = false;
        for (Map.Entry<ConnectionId, ? extends Set<EntityId>> entry : object2.entrySet()) {
            void missingChildren;
            object = entry;
            boolean bl2 = false;
            object2 = object.getKey();
            object = entry;
            bl2 = false;
            Set<EntityId> children2 = object.getValue();
            Iterable $this$partition$iv = children2;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                EntityId it = (EntityId)element$iv;
                boolean bl3 = false;
                if (this.entityDataById$intellij_platform_workspaceModel_storage(it) == null) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Object object3 = new Pair(first$iv, second$iv);
            object = (List)object3.component1();
            List existingChildren = (List)object3.component2();
            object3 = (Collection)missingChildren;
            boolean bl3 = false;
            if (!object3.isEmpty() && !((ConnectionId)connectionId).canRemoveChild()) {
                Void void_ = AddDiffExceptionKt.adFailed("Cannot restore some dependencies");
                throw null;
            }
            this.getRefs$intellij_platform_workspaceModel_storage().updateChildrenOfParent$intellij_platform_workspaceModel_storage((ConnectionId)connectionId, entityId, existingChildren);
        }
        connectionId = updatedParents;
        boolean children2 = false;
        for (Map.Entry<ConnectionId, Object> entry : connectionId.entrySet()) {
            void connection;
            object = entry;
            boolean bl4 = false;
            connectionId = object.getKey();
            object = entry;
            bl4 = false;
            EntityId parent = (EntityId)object.getValue();
            if (this.entityDataById$intellij_platform_workspaceModel_storage(parent) != null) {
                this.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage((ConnectionId)connection, entityId, parent);
                continue;
            }
            if (connection.canRemoveParent()) continue;
            Void void_ = AddDiffExceptionKt.adFailed("Cannot restore some dependencies");
            throw null;
        }
    }

    private final <T extends WorkspaceEntity> void replaceEntityWithRefs(WorkspaceEntityData<T> newEntity2, int clazz, List<Pair<ConnectionId, EntityId>> addedChildren, List<Pair<ConnectionId, EntityId>> removedChildren, Map<ConnectionId, EntityId> modifiedParents) {
        Object connectionId;
        Object object;
        Object removedChildrenSet;
        Object connectionId2;
        Object element$iv3;
        Object element$iv22;
        WorkspaceEntityData<? extends WorkspaceEntity> existingEntityData;
        EntityId id2 = newEntity2.createPid$intellij_platform_workspaceModel_storage();
        WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = existingEntityData = this.entityDataById$intellij_platform_workspaceModel_storage(id2);
        PersistentEntityId<?> beforePersistentId = workspaceEntityData != null ? EntitiesKt.persistentId(workspaceEntityData, this) : null;
        this.getEntitiesByType$intellij_platform_workspaceModel_storage().replaceById(newEntity2, clazz);
        this.updatePersistentIdIndexes((WorkspaceEntity)newEntity2.createEntity(this), beforePersistentId, newEntity2);
        HashMultimap addedChildrenMap = HashMultimap.create();
        Iterable $this$forEach$iv = addedChildren;
        boolean $i$f$forEach = false;
        for (Object element$iv22 : $this$forEach$iv) {
            Pair it = (Pair)element$iv22;
            boolean bl = false;
            addedChildrenMap.put(it.getFirst(), it.getSecond());
        }
        HashMultimap removedChildrenMap = HashMultimap.create();
        Iterable $this$forEach$iv2 = removedChildren;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            Pair it = (Pair)element$iv3;
            boolean bl = false;
            removedChildrenMap.put(it.getFirst(), it.getSecond());
        }
        Map<ConnectionId, Set<EntityId>> existingChildren = this.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(id2);
        element$iv3 = existingChildren;
        boolean it = false;
        element$iv22 = element$iv3.entrySet().iterator();
        while (element$iv22.hasNext()) {
            Map.Entry bl = $i$f$forEach2 = (Map.Entry)element$iv22.next();
            boolean bl2 = false;
            element$iv3 = (ConnectionId)bl.getKey();
            bl = $i$f$forEach2;
            bl2 = false;
            Set children2 = (Set)bl.getValue();
            Set mutableChildren = CollectionsKt.toMutableSet((Iterable)children2);
            Set set = addedChildrenMap.get(connectionId2);
            if (set == null) {
                boolean bl3 = false;
                set = new LinkedHashSet();
            }
            Set addedChildrenSet = set;
            for (EntityId addedChild : addedChildrenSet) {
                if (mutableChildren.contains(addedChild)) continue;
                EntityId entityId = addedChild;
                Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"addedChild");
                WorkspaceEntityData<? extends WorkspaceEntity> addedEntityData = this.entityDataById$intellij_platform_workspaceModel_storage(entityId);
                if (addedEntityData == null && !((ConnectionId)connectionId2).canRemoveParent()) {
                    Void void_ = AddDiffExceptionKt.adFailed("Cannot restore some dependencies");
                    throw null;
                }
                mutableChildren.add(addedChild);
            }
            Set set2 = removedChildrenMap.get(connectionId2);
            if (set2 == null) {
                boolean bl4 = false;
                set2 = new LinkedHashSet();
            }
            removedChildrenSet = set2;
            object = removedChildrenSet.iterator();
            while (object.hasNext()) {
                EntityId removedChild = (EntityId)object.next();
                if (!mutableChildren.contains(removedChild) && StrictMode.INSTANCE.getEnabled()) {
                    Void void_ = AddDiffExceptionKt.adFailed("Trying to remove child that isn't present");
                    throw null;
                }
                mutableChildren.remove(removedChild);
            }
            if (Intrinsics.areEqual((Object)children2, (Object)mutableChildren) ^ true) {
                this.getRefs$intellij_platform_workspaceModel_storage().updateChildrenOfParent$intellij_platform_workspaceModel_storage((ConnectionId)connectionId2, id2, mutableChildren);
            }
            addedChildrenMap.removeAll(connectionId2);
            removedChildrenMap.removeAll(connectionId2);
        }
        HashMultimap hashMultimap = removedChildrenMap;
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMultimap, (String)"removedChildrenMap");
        if (!hashMultimap.isEmpty() && StrictMode.INSTANCE.getEnabled()) {
            Void void_ = AddDiffExceptionKt.adFailed("Trying to remove children that aren't present");
            throw null;
        }
        Map map2 = addedChildrenMap.asMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"addedChildrenMap.asMap()");
        connectionId2 = map2;
        boolean children2 = false;
        element$iv22 = connectionId2.entrySet().iterator();
        while (element$iv22.hasNext()) {
            Map.Entry mutableChildren = $i$f$forEach2 = (Map.Entry)element$iv22.next();
            boolean addedChildrenSet = false;
            connectionId2 = (ConnectionId)mutableChildren.getKey();
            mutableChildren = $i$f$forEach2;
            addedChildrenSet = false;
            Collection children3 = (Collection)mutableChildren.getValue();
            MutableRefsTable mutableRefsTable = this.getRefs$intellij_platform_workspaceModel_storage();
            Object object2 = connectionId2;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"connectionId");
            Collection collection = children3;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"children");
            mutableRefsTable.updateChildrenOfParent$intellij_platform_workspaceModel_storage((ConnectionId)object2, id2, collection);
        }
        Map modifiedParentsMap = MapsKt.toMutableMap(modifiedParents);
        Map<ConnectionId, EntityId> existingParents = this.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(id2);
        Object mutableChildren = existingParents;
        boolean addedChildrenSet = false;
        for (Map.Entry<ConnectionId, EntityId> entry : mutableChildren.entrySet()) {
            removedChildrenSet = entry;
            boolean bl = false;
            mutableChildren = (ConnectionId)removedChildrenSet.getKey();
            removedChildrenSet = entry;
            bl = false;
            EntityId existingParent = removedChildrenSet.getValue();
            removedChildrenSet = modifiedParentsMap;
            bl = false;
            object = removedChildrenSet;
            boolean bl5 = false;
            if (!object.containsKey(connectionId)) continue;
            EntityId parent = (EntityId)MapsKt.getValue((Map)modifiedParentsMap, (Object)connectionId);
            if (parent != null && this.entityDataById$intellij_platform_workspaceModel_storage(parent) != null && Intrinsics.areEqual((Object)parent, (Object)existingParent) ^ true) {
                this.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage((ConnectionId)connectionId, id2, parent);
            } else if (parent == null || this.entityDataById$intellij_platform_workspaceModel_storage(parent) != null) {
                if (!((ConnectionId)connectionId).canRemoveParent()) {
                    Void void_ = AddDiffExceptionKt.adFailed("Cannot restore some dependencies");
                    throw null;
                }
                this.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)connectionId, existingParent, id2);
            }
            modifiedParentsMap.remove(connectionId);
        }
        connectionId = modifiedParentsMap;
        boolean existingParent = false;
        Iterator<Map.Entry<ConnectionId, EntityId>> iterator2 = connectionId.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ConnectionId, EntityId> entry;
            Map.Entry<ConnectionId, EntityId> entry2 = entry = iterator2.next();
            boolean bl = false;
            connectionId = entry2.getKey();
            entry2 = entry;
            bl = false;
            EntityId parentId = entry2.getValue();
            if (parentId == null) continue;
            if (this.entityDataById$intellij_platform_workspaceModel_storage(parentId) != null) {
                this.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage((ConnectionId)connectionId, id2, parentId);
                continue;
            }
            if (((ConnectionId)connectionId).canRemoveParent()) continue;
            Void void_ = AddDiffExceptionKt.adFailed("Cannot restore some dependencies");
            throw null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void accumulateEntitiesToRemove(EntityId id2, Set<EntityId> accumulator) {
        Map<ConnectionId, Set<EntityId>> children2 = this.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(id2);
        Iterator<Map.Entry<ConnectionId, EntityId>> iterator2 = children2;
        boolean bl = false;
        Iterator<EntityId> iterator3 = iterator2.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry<ConnectionId, Set<EntityId>> entry;
            Map.Entry<ConnectionId, Set<EntityId>> entry2 = entry = iterator3.next();
            boolean bl2 = false;
            iterator2 = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Set<EntityId> children3 = entry2.getValue();
            for (EntityId child2 : children3) {
                void connectionId;
                if (accumulator.contains(child2)) continue;
                accumulator.add(child2);
                this.accumulateEntitiesToRemove(child2, accumulator);
                this.getRefs$intellij_platform_workspaceModel_storage().removeRefsByParent((ConnectionId)connectionId, id2);
            }
        }
        Map<ConnectionId, EntityId> parents2 = this.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(id2);
        Object children3 = parents2;
        boolean child2 = false;
        iterator2 = children3.entrySet().iterator();
        while (iterator2.hasNext()) {
            void connectionId;
            Iterator<EntityId> iterator4 = iterator3 = iterator2.next();
            boolean bl3 = false;
            children3 = (ConnectionId)iterator4.getKey();
            iterator4 = iterator3;
            bl3 = false;
            EntityId parent = (EntityId)iterator4.getValue();
            this.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)connectionId, parent, id2);
        }
    }

    @Override
    @NotNull
    public MutableEntitiesBarrel getEntitiesByType$intellij_platform_workspaceModel_storage() {
        return this.entitiesByType;
    }

    @Override
    @NotNull
    public MutableRefsTable getRefs$intellij_platform_workspaceModel_storage() {
        return this.refs;
    }

    @Override
    @NotNull
    public MutableStorageIndexes getIndexes$intellij_platform_workspaceModel_storage() {
        return this.indexes;
    }

    public WorkspaceEntityStorageBuilderImpl(@NotNull MutableEntitiesBarrel entitiesByType, @NotNull MutableRefsTable refs, @NotNull MutableStorageIndexes indexes) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)entitiesByType, (String)"entitiesByType");
        Intrinsics.checkParameterIsNotNull((Object)refs, (String)"refs");
        Intrinsics.checkParameterIsNotNull((Object)indexes, (String)"indexes");
        super(null);
        this.entitiesByType = entitiesByType;
        this.refs = refs;
        this.indexes = indexes;
        WorkspaceEntityStorageBuilderImpl workspaceEntityStorageBuilderImpl = this;
        boolean bl = false;
        workspaceEntityStorageBuilderImpl.changeLogImpl = list2 = (List)new ArrayList();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceEntityStorageBuilderImpl.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$ChangeEntry;", "", "()V", "AddEntity", "RemoveEntity", "ReplaceEntity", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$ChangeEntry$AddEntity;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$ChangeEntry$RemoveEntity;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$ChangeEntry$ReplaceEntity;", "intellij.platform.workspaceModel.storage"})
    public static abstract class ChangeEntry {
        private ChangeEntry() {
        }

        public /* synthetic */ ChangeEntry(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003BI\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\u000eJ\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u001b\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tH\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0003J[\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006\""}, d2={"Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$ChangeEntry$AddEntity;", "E", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$ChangeEntry;", "entityData", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "clazz", "", "children", "", "Lcom/intellij/workspaceModel/storage/impl/ConnectionId;", "", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "parents", "(Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;ILjava/util/Map;Ljava/util/Map;)V", "getChildren", "()Ljava/util/Map;", "getClazz", "()I", "getEntityData", "()Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "getParents", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.platform.workspaceModel.storage"})
        public static final class AddEntity<E extends WorkspaceEntity>
        extends ChangeEntry {
            @NotNull
            private final WorkspaceEntityData<E> entityData;
            private final int clazz;
            @NotNull
            private final Map<ConnectionId, Set<EntityId>> children;
            @NotNull
            private final Map<ConnectionId, EntityId> parents;

            @NotNull
            public final WorkspaceEntityData<E> getEntityData() {
                return this.entityData;
            }

            public final int getClazz() {
                return this.clazz;
            }

            @NotNull
            public final Map<ConnectionId, Set<EntityId>> getChildren() {
                return this.children;
            }

            @NotNull
            public final Map<ConnectionId, EntityId> getParents() {
                return this.parents;
            }

            public AddEntity(@NotNull WorkspaceEntityData<E> entityData, int clazz, @NotNull Map<ConnectionId, ? extends Set<EntityId>> children2, @NotNull Map<ConnectionId, EntityId> parents2) {
                Intrinsics.checkParameterIsNotNull(entityData, (String)"entityData");
                Intrinsics.checkParameterIsNotNull(children2, (String)"children");
                Intrinsics.checkParameterIsNotNull(parents2, (String)"parents");
                super(null);
                this.entityData = entityData;
                this.clazz = clazz;
                this.children = children2;
                this.parents = parents2;
            }

            @NotNull
            public final WorkspaceEntityData<E> component1() {
                return this.entityData;
            }

            public final int component2() {
                return this.clazz;
            }

            @NotNull
            public final Map<ConnectionId, Set<EntityId>> component3() {
                return this.children;
            }

            @NotNull
            public final Map<ConnectionId, EntityId> component4() {
                return this.parents;
            }

            @NotNull
            public final AddEntity<E> copy(@NotNull WorkspaceEntityData<E> entityData, int clazz, @NotNull Map<ConnectionId, ? extends Set<EntityId>> children2, @NotNull Map<ConnectionId, EntityId> parents2) {
                Intrinsics.checkParameterIsNotNull(entityData, (String)"entityData");
                Intrinsics.checkParameterIsNotNull(children2, (String)"children");
                Intrinsics.checkParameterIsNotNull(parents2, (String)"parents");
                return new AddEntity<E>(entityData, clazz, children2, parents2);
            }

            public static /* synthetic */ AddEntity copy$default(AddEntity addEntity, WorkspaceEntityData workspaceEntityData, int n, Map map2, Map map3, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    workspaceEntityData = addEntity.entityData;
                }
                if ((n2 & 2) != 0) {
                    n = addEntity.clazz;
                }
                if ((n2 & 4) != 0) {
                    map2 = addEntity.children;
                }
                if ((n2 & 8) != 0) {
                    map3 = addEntity.parents;
                }
                return addEntity.copy(workspaceEntityData, n, map2, map3);
            }

            @NotNull
            public String toString() {
                return "AddEntity(entityData=" + this.entityData + ", clazz=" + this.clazz + ", children=" + this.children + ", parents=" + this.parents + ")";
            }

            public int hashCode() {
                WorkspaceEntityData<E> workspaceEntityData = this.entityData;
                Map<ConnectionId, Set<EntityId>> map2 = this.children;
                Map<ConnectionId, EntityId> map3 = this.parents;
                return (((workspaceEntityData != null ? ((Object)workspaceEntityData).hashCode() : 0) * 31 + Integer.hashCode(this.clazz)) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0)) * 31 + (map3 != null ? ((Object)map3).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof AddEntity)) break block3;
                        AddEntity addEntity = (AddEntity)object;
                        if (!Intrinsics.areEqual(this.entityData, addEntity.entityData) || this.clazz != addEntity.clazz || !Intrinsics.areEqual(this.children, addEntity.children) || !Intrinsics.areEqual(this.parents, addEntity.parents)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$ChangeEntry$RemoveEntity;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$ChangeEntry;", "id", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "(Lcom/intellij/workspaceModel/storage/impl/EntityId;)V", "getId", "()Lcom/intellij/workspaceModel/storage/impl/EntityId;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.workspaceModel.storage"})
        public static final class RemoveEntity
        extends ChangeEntry {
            @NotNull
            private final EntityId id;

            @NotNull
            public final EntityId getId() {
                return this.id;
            }

            public RemoveEntity(@NotNull EntityId id2) {
                Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
                super(null);
                this.id = id2;
            }

            @NotNull
            public final EntityId component1() {
                return this.id;
            }

            @NotNull
            public final RemoveEntity copy(@NotNull EntityId id2) {
                Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
                return new RemoveEntity(id2);
            }

            public static /* synthetic */ RemoveEntity copy$default(RemoveEntity removeEntity, EntityId entityId, int n, Object object) {
                if ((n & 1) != 0) {
                    entityId = removeEntity.id;
                }
                return removeEntity.copy(entityId);
            }

            @NotNull
            public String toString() {
                return "RemoveEntity(id=" + this.id + ")";
            }

            public int hashCode() {
                EntityId entityId = this.id;
                return entityId != null ? ((Object)entityId).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof RemoveEntity)) break block3;
                        RemoveEntity removeEntity = (RemoveEntity)object;
                        if (!Intrinsics.areEqual((Object)this.id, (Object)removeEntity.id)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B]\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\r\u00a2\u0006\u0002\u0010\u000eJ\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u001b\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007H\u00c6\u0003J\u001b\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007H\u00c6\u0003J\u0017\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\rH\u00c6\u0003Jo\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u00072\u001a\b\u0002\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u00072\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\rH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u001f\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$ChangeEntry$ReplaceEntity;", "E", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$ChangeEntry;", "newData", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "newChildren", "", "Lkotlin/Pair;", "Lcom/intellij/workspaceModel/storage/impl/ConnectionId;", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "removedChildren", "modifiedParents", "", "(Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;Ljava/util/List;Ljava/util/List;Ljava/util/Map;)V", "getModifiedParents", "()Ljava/util/Map;", "getNewChildren", "()Ljava/util/List;", "getNewData", "()Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "getRemovedChildren", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.workspaceModel.storage"})
        public static final class ReplaceEntity<E extends WorkspaceEntity>
        extends ChangeEntry {
            @NotNull
            private final WorkspaceEntityData<E> newData;
            @NotNull
            private final List<Pair<ConnectionId, EntityId>> newChildren;
            @NotNull
            private final List<Pair<ConnectionId, EntityId>> removedChildren;
            @NotNull
            private final Map<ConnectionId, EntityId> modifiedParents;

            @NotNull
            public final WorkspaceEntityData<E> getNewData() {
                return this.newData;
            }

            @NotNull
            public final List<Pair<ConnectionId, EntityId>> getNewChildren() {
                return this.newChildren;
            }

            @NotNull
            public final List<Pair<ConnectionId, EntityId>> getRemovedChildren() {
                return this.removedChildren;
            }

            @NotNull
            public final Map<ConnectionId, EntityId> getModifiedParents() {
                return this.modifiedParents;
            }

            public ReplaceEntity(@NotNull WorkspaceEntityData<E> newData, @NotNull List<Pair<ConnectionId, EntityId>> newChildren, @NotNull List<Pair<ConnectionId, EntityId>> removedChildren, @NotNull Map<ConnectionId, EntityId> modifiedParents) {
                Intrinsics.checkParameterIsNotNull(newData, (String)"newData");
                Intrinsics.checkParameterIsNotNull(newChildren, (String)"newChildren");
                Intrinsics.checkParameterIsNotNull(removedChildren, (String)"removedChildren");
                Intrinsics.checkParameterIsNotNull(modifiedParents, (String)"modifiedParents");
                super(null);
                this.newData = newData;
                this.newChildren = newChildren;
                this.removedChildren = removedChildren;
                this.modifiedParents = modifiedParents;
            }

            @NotNull
            public final WorkspaceEntityData<E> component1() {
                return this.newData;
            }

            @NotNull
            public final List<Pair<ConnectionId, EntityId>> component2() {
                return this.newChildren;
            }

            @NotNull
            public final List<Pair<ConnectionId, EntityId>> component3() {
                return this.removedChildren;
            }

            @NotNull
            public final Map<ConnectionId, EntityId> component4() {
                return this.modifiedParents;
            }

            @NotNull
            public final ReplaceEntity<E> copy(@NotNull WorkspaceEntityData<E> newData, @NotNull List<Pair<ConnectionId, EntityId>> newChildren, @NotNull List<Pair<ConnectionId, EntityId>> removedChildren, @NotNull Map<ConnectionId, EntityId> modifiedParents) {
                Intrinsics.checkParameterIsNotNull(newData, (String)"newData");
                Intrinsics.checkParameterIsNotNull(newChildren, (String)"newChildren");
                Intrinsics.checkParameterIsNotNull(removedChildren, (String)"removedChildren");
                Intrinsics.checkParameterIsNotNull(modifiedParents, (String)"modifiedParents");
                return new ReplaceEntity<E>(newData, newChildren, removedChildren, modifiedParents);
            }

            public static /* synthetic */ ReplaceEntity copy$default(ReplaceEntity replaceEntity, WorkspaceEntityData workspaceEntityData, List list2, List list3, Map map2, int n, Object object) {
                if ((n & 1) != 0) {
                    workspaceEntityData = replaceEntity.newData;
                }
                if ((n & 2) != 0) {
                    list2 = replaceEntity.newChildren;
                }
                if ((n & 4) != 0) {
                    list3 = replaceEntity.removedChildren;
                }
                if ((n & 8) != 0) {
                    map2 = replaceEntity.modifiedParents;
                }
                return replaceEntity.copy(workspaceEntityData, list2, list3, map2);
            }

            @NotNull
            public String toString() {
                return "ReplaceEntity(newData=" + this.newData + ", newChildren=" + this.newChildren + ", removedChildren=" + this.removedChildren + ", modifiedParents=" + this.modifiedParents + ")";
            }

            public int hashCode() {
                WorkspaceEntityData<E> workspaceEntityData = this.newData;
                List<Pair<ConnectionId, EntityId>> list2 = this.newChildren;
                List<Pair<ConnectionId, EntityId>> list3 = this.removedChildren;
                Map<ConnectionId, EntityId> map2 = this.modifiedParents;
                return (((workspaceEntityData != null ? ((Object)workspaceEntityData).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0)) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ReplaceEntity)) break block3;
                        ReplaceEntity replaceEntity = (ReplaceEntity)object;
                        if (!Intrinsics.areEqual(this.newData, replaceEntity.newData) || !Intrinsics.areEqual(this.newChildren, replaceEntity.newChildren) || !Intrinsics.areEqual(this.removedChildren, replaceEntity.removedChildren) || !Intrinsics.areEqual(this.modifiedParents, replaceEntity.modifiedParents)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0010\b\u0000\u0010\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\u00020\u0004:\u0003\u0006\u0007\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005\u0082\u0001\u0003\t\n\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$EntityDataChange;", "T", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "", "()V", "Added", "Removed", "Replaced", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$EntityDataChange$Added;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$EntityDataChange$Removed;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$EntityDataChange$Replaced;", "intellij.platform.workspaceModel.storage"})
    public static abstract class EntityDataChange<T extends WorkspaceEntityData<? extends WorkspaceEntity>> {
        private EntityDataChange() {
        }

        public /* synthetic */ EntityDataChange(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0010\b\u0001\u0010\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0005\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$EntityDataChange$Added;", "T", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$EntityDataChange;", "entity", "(Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;)V", "getEntity", "()Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "component1", "copy", "(Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;)Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$EntityDataChange$Added;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.workspaceModel.storage"})
        public static final class Added<T extends WorkspaceEntityData<? extends WorkspaceEntity>>
        extends EntityDataChange<T> {
            @NotNull
            private final T entity;

            @NotNull
            public final T getEntity() {
                return this.entity;
            }

            public Added(@NotNull T entity) {
                Intrinsics.checkParameterIsNotNull(entity, (String)"entity");
                super(null);
                this.entity = entity;
            }

            @NotNull
            public final T component1() {
                return this.entity;
            }

            @NotNull
            public final Added<T> copy(@NotNull T entity) {
                Intrinsics.checkParameterIsNotNull(entity, (String)"entity");
                return new Added<T>(entity);
            }

            public static /* synthetic */ Added copy$default(Added added, WorkspaceEntityData workspaceEntityData, int n, Object object) {
                if ((n & 1) != 0) {
                    workspaceEntityData = added.entity;
                }
                return added.copy(workspaceEntityData);
            }

            @NotNull
            public String toString() {
                return "Added(entity=" + this.entity + ")";
            }

            public int hashCode() {
                T t = this.entity;
                return t != null ? t.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Added)) break block3;
                        Added added = (Added)object;
                        if (!Intrinsics.areEqual(this.entity, added.entity)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0010\b\u0001\u0010\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0005\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$EntityDataChange$Removed;", "T", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$EntityDataChange;", "entity", "(Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;)V", "getEntity", "()Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "component1", "copy", "(Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;)Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$EntityDataChange$Removed;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.workspaceModel.storage"})
        public static final class Removed<T extends WorkspaceEntityData<? extends WorkspaceEntity>>
        extends EntityDataChange<T> {
            @NotNull
            private final T entity;

            @NotNull
            public final T getEntity() {
                return this.entity;
            }

            public Removed(@NotNull T entity) {
                Intrinsics.checkParameterIsNotNull(entity, (String)"entity");
                super(null);
                this.entity = entity;
            }

            @NotNull
            public final T component1() {
                return this.entity;
            }

            @NotNull
            public final Removed<T> copy(@NotNull T entity) {
                Intrinsics.checkParameterIsNotNull(entity, (String)"entity");
                return new Removed<T>(entity);
            }

            public static /* synthetic */ Removed copy$default(Removed removed, WorkspaceEntityData workspaceEntityData, int n, Object object) {
                if ((n & 1) != 0) {
                    workspaceEntityData = removed.entity;
                }
                return removed.copy(workspaceEntityData);
            }

            @NotNull
            public String toString() {
                return "Removed(entity=" + this.entity + ")";
            }

            public int hashCode() {
                T t = this.entity;
                return t != null ? t.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Removed)) break block3;
                        Removed removed = (Removed)object;
                        if (!Intrinsics.areEqual(this.entity, removed.entity)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0010\b\u0001\u0010\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\r\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0005\u001a\u00028\u00012\b\b\u0002\u0010\u0006\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0013\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$EntityDataChange$Replaced;", "T", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$EntityDataChange;", "oldEntity", "newEntity", "(Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;)V", "getNewEntity", "()Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "getOldEntity", "component1", "component2", "copy", "(Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;)Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$EntityDataChange$Replaced;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.workspaceModel.storage"})
        public static final class Replaced<T extends WorkspaceEntityData<? extends WorkspaceEntity>>
        extends EntityDataChange<T> {
            @NotNull
            private final T oldEntity;
            @NotNull
            private final T newEntity;

            @NotNull
            public final T getOldEntity() {
                return this.oldEntity;
            }

            @NotNull
            public final T getNewEntity() {
                return this.newEntity;
            }

            public Replaced(@NotNull T oldEntity, @NotNull T newEntity2) {
                Intrinsics.checkParameterIsNotNull(oldEntity, (String)"oldEntity");
                Intrinsics.checkParameterIsNotNull(newEntity2, (String)"newEntity");
                super(null);
                this.oldEntity = oldEntity;
                this.newEntity = newEntity2;
            }

            @NotNull
            public final T component1() {
                return this.oldEntity;
            }

            @NotNull
            public final T component2() {
                return this.newEntity;
            }

            @NotNull
            public final Replaced<T> copy(@NotNull T oldEntity, @NotNull T newEntity2) {
                Intrinsics.checkParameterIsNotNull(oldEntity, (String)"oldEntity");
                Intrinsics.checkParameterIsNotNull(newEntity2, (String)"newEntity");
                return new Replaced<T>(oldEntity, newEntity2);
            }

            public static /* synthetic */ Replaced copy$default(Replaced replaced, WorkspaceEntityData workspaceEntityData, WorkspaceEntityData workspaceEntityData2, int n, Object object) {
                if ((n & 1) != 0) {
                    workspaceEntityData = replaced.oldEntity;
                }
                if ((n & 2) != 0) {
                    workspaceEntityData2 = replaced.newEntity;
                }
                return replaced.copy(workspaceEntityData, workspaceEntityData2);
            }

            @NotNull
            public String toString() {
                return "Replaced(oldEntity=" + this.oldEntity + ", newEntity=" + this.newEntity + ")";
            }

            public int hashCode() {
                T t = this.oldEntity;
                T t2 = this.newEntity;
                return (t != null ? t.hashCode() : 0) * 31 + (t2 != null ? t2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Replaced)) break block3;
                        Replaced replaced = (Replaced)object;
                        if (!Intrinsics.areEqual(this.oldEntity, replaced.oldEntity) || !Intrinsics.areEqual(this.newEntity, replaced.newEntity)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "create", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl;", "from", "storage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "intellij.platform.workspaceModel.storage"})
    public static final class Companion {
        @NotNull
        public final WorkspaceEntityStorageBuilderImpl create() {
            return this.from(WorkspaceEntityStorageImpl.Companion.getEMPTY());
        }

        @NotNull
        public final WorkspaceEntityStorageBuilderImpl from(@NotNull WorkspaceEntityStorage storage) {
            WorkspaceEntityStorageBuilderImpl workspaceEntityStorageBuilderImpl;
            Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
            AbstractEntityStorage cfr_ignored_0 = (AbstractEntityStorage)storage;
            WorkspaceEntityStorage workspaceEntityStorage = storage;
            if (workspaceEntityStorage instanceof WorkspaceEntityStorageImpl) {
                MutableEntitiesBarrel copiedBarrel = MutableEntitiesBarrel.Companion.from(((WorkspaceEntityStorageImpl)storage).getEntitiesByType$intellij_platform_workspaceModel_storage());
                MutableRefsTable copiedRefs = MutableRefsTable.Companion.from(((WorkspaceEntityStorageImpl)storage).getRefs$intellij_platform_workspaceModel_storage());
                MutableStorageIndexes copiedIndex = ((AbstractEntityStorage)storage).getIndexes$intellij_platform_workspaceModel_storage().toMutable();
                workspaceEntityStorageBuilderImpl = new WorkspaceEntityStorageBuilderImpl(copiedBarrel, copiedRefs, copiedIndex);
            } else if (workspaceEntityStorage instanceof WorkspaceEntityStorageBuilderImpl) {
                MutableEntitiesBarrel copiedBarrel = MutableEntitiesBarrel.Companion.from(((WorkspaceEntityStorageBuilderImpl)storage).getEntitiesByType$intellij_platform_workspaceModel_storage().toImmutable());
                MutableRefsTable copiedRefs = MutableRefsTable.Companion.from(((WorkspaceEntityStorageBuilderImpl)storage).getRefs$intellij_platform_workspaceModel_storage().toImmutable());
                MutableStorageIndexes copiedIndexes = ((WorkspaceEntityStorageBuilderImpl)storage).getIndexes$intellij_platform_workspaceModel_storage().toImmutable().toMutable();
                workspaceEntityStorageBuilderImpl = new WorkspaceEntityStorageBuilderImpl(copiedBarrel, copiedRefs, copiedIndexes);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return workspaceEntityStorageBuilderImpl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

