/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.UnknownInvalidSdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkBalloonNotification;
import com.intellij.openapi.projectRoots.impl.UnknownSdkCollector;
import com.intellij.openapi.projectRoots.impl.UnknownSdkDownloader;
import com.intellij.openapi.projectRoots.impl.UnknownSdkEditorNotification;
import com.intellij.openapi.projectRoots.impl.UnknownSdkSnapshot;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkResolver;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Consumer;
import com.intellij.util.TripleFunction;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownSdkTracker {
    private static final Logger LOG = Logger.getInstance(UnknownSdkTracker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    private UnknownSdkSnapshot myPreviousRequestCache;

    @NotNull
    public static UnknownSdkTracker getInstance(@NotNull Project project) {
        if (project == null) {
            UnknownSdkTracker.$$$reportNull$$$0(0);
        }
        UnknownSdkTracker unknownSdkTracker = (UnknownSdkTracker)project.getService(UnknownSdkTracker.class);
        if (unknownSdkTracker == null) {
            UnknownSdkTracker.$$$reportNull$$$0(1);
        }
        return unknownSdkTracker;
    }

    public UnknownSdkTracker(@NotNull Project project) {
        if (project == null) {
            UnknownSdkTracker.$$$reportNull$$$0(2);
        }
        this.myPreviousRequestCache = null;
        this.myProject = project;
        this.myUpdateQueue = new MergingUpdateQueue(this.getClass().getSimpleName(), 700, true, null, (Disposable)this.myProject, null, false).usePassThroughInUnitTestMode();
    }

    @NotNull
    private Update newUpdateTask() {
        return new Update("update"){

            public void run() {
                if (!Registry.is((String)"unknown.sdk") || !UnknownSdkResolver.EP_NAME.hasAnyExtensions()) {
                    UnknownSdkTracker.this.showStatus(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
                    return;
                }
                new UnknownSdkCollector(UnknownSdkTracker.this.myProject).collectSdksPromise(snapshot -> {
                    if (snapshot.equals(UnknownSdkTracker.this.myPreviousRequestCache)) {
                        return;
                    }
                    UnknownSdkTracker.this.myPreviousRequestCache = snapshot;
                    UnknownSdkTracker.this.onFixableAndMissingSdksCollected(UnknownSdkTracker.filterOnlyAllowedEntries(snapshot.getResolvableSdks()), UnknownSdkTracker.filterOnlyAllowedSdkEntries(snapshot.getKnownSdks()));
                });
            }
        };
    }

    public void updateUnknownSdksNow() {
        this.myUpdateQueue.run(this.newUpdateTask());
    }

    public void updateUnknownSdks() {
        this.myUpdateQueue.queue(this.newUpdateTask());
    }

    private static boolean allowFixesFor(@NotNull SdkTypeId type) {
        if (type == null) {
            UnknownSdkTracker.$$$reportNull$$$0(3);
        }
        return UnknownSdkResolver.EP_NAME.findFirstSafe(it -> it.supportsResolution(type)) != null;
    }

    @NotNull
    private static <E extends UnknownSdk> List<E> filterOnlyAllowedEntries(@NotNull List<? extends E> input) {
        if (input == null) {
            UnknownSdkTracker.$$$reportNull$$$0(4);
        }
        ArrayList<UnknownSdk> copy2 = new ArrayList<UnknownSdk>();
        for (UnknownSdk item : input) {
            SdkType type = item.getSdkType();
            if (!UnknownSdkTracker.allowFixesFor((SdkTypeId)type)) continue;
            copy2.add(item);
        }
        ArrayList<UnknownSdk> arrayList = copy2;
        if (arrayList == null) {
            UnknownSdkTracker.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static List<Sdk> filterOnlyAllowedSdkEntries(@NotNull List<Sdk> input) {
        if (input == null) {
            UnknownSdkTracker.$$$reportNull$$$0(6);
        }
        ArrayList<Sdk> copy2 = new ArrayList<Sdk>();
        for (Sdk item : input) {
            SdkTypeId type = item.getSdkType();
            if (!UnknownSdkTracker.allowFixesFor(type)) continue;
            copy2.add(item);
        }
        ArrayList<Sdk> arrayList = copy2;
        if (arrayList == null) {
            UnknownSdkTracker.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private void onFixableAndMissingSdksCollected(final @NotNull List<UnknownSdk> fixable, final @NotNull List<Sdk> usedSdks) {
        if (fixable == null) {
            UnknownSdkTracker.$$$reportNull$$$0(8);
        }
        if (usedSdks == null) {
            UnknownSdkTracker.$$$reportNull$$$0(9);
        }
        if (fixable.isEmpty() && usedSdks.isEmpty()) {
            this.showStatus(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, ProjectBundle.message((String)"progress.title.resolving.sdks", (Object[])new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                List<UnknownInvalidSdk> invalidSdks = new ArrayList<UnknownInvalidSdk>();
                Map<UnknownSdk, UnknownSdkLocalSdkFix> localFixes = new HashMap<UnknownSdk, UnknownSdkLocalSdkFix>();
                Map<UnknownSdk, UnknownSdkDownloadableSdkFix> downloadFixes = new HashMap<UnknownSdk, UnknownSdkDownloadableSdkFix>();
                if (!usedSdks.isEmpty()) {
                    indicator.pushState();
                    indicator.setText(ProjectBundle.message((String)"progress.text.resolving.existing.sdks", (Object[])new Object[0]));
                    invalidSdks = UnknownInvalidSdk.resolveInvalidSdks(usedSdks);
                    fixable.addAll(invalidSdks);
                    indicator.popState();
                }
                if (!fixable.isEmpty()) {
                    indicator.pushState();
                    indicator.setText(ProjectBundle.message((String)"progress.text.resolving.missing.sdks", (Object[])new Object[0]));
                    List lookups = UnknownSdkTracker.this.collectSdkLookups(indicator);
                    if (!lookups.isEmpty()) {
                        indicator.setText(ProjectBundle.message((String)"progress.text.looking.for.local.sdks", (Object[])new Object[0]));
                        localFixes = UnknownSdkTracker.findFixesAndRemoveFixable(indicator, fixable, lookups, UnknownSdkResolver.UnknownSdkLookup::proposeLocalFix);
                        if (!fixable.isEmpty()) {
                            indicator.setText(ProjectBundle.message((String)"progress.text.looking.for.downloadable.sdks", (Object[])new Object[0]));
                            downloadFixes = UnknownSdkTracker.findFixesAndRemoveFixable(indicator, fixable, lookups, UnknownSdkResolver.UnknownSdkLookup::proposeDownload);
                        }
                    }
                    indicator.popState();
                }
                UnknownInvalidSdk.removeAndUpdate(invalidSdks, fixable, localFixes, downloadFixes);
                if (!localFixes.isEmpty()) {
                    indicator.pushState();
                    indicator.setText(ProjectBundle.message((String)"progress.text.configuring.sdks", (Object[])new Object[0]));
                    UnknownSdkTracker.this.configureLocalSdks(localFixes);
                    indicator.popState();
                }
                UnknownSdkTracker.this.showStatus(fixable, localFixes, downloadFixes, invalidSdks);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker$2", "run"));
            }
        });
    }

    private void showStatus(@NotNull List<UnknownSdk> unknownSdksWithoutFix, @NotNull Map<UnknownSdk, UnknownSdkLocalSdkFix> localFixes, @NotNull Map<UnknownSdk, UnknownSdkDownloadableSdkFix> downloadFixes, @NotNull List<UnknownInvalidSdk> invalidSdks) {
        if (unknownSdksWithoutFix == null) {
            UnknownSdkTracker.$$$reportNull$$$0(10);
        }
        if (localFixes == null) {
            UnknownSdkTracker.$$$reportNull$$$0(11);
        }
        if (downloadFixes == null) {
            UnknownSdkTracker.$$$reportNull$$$0(12);
        }
        if (invalidSdks == null) {
            UnknownSdkTracker.$$$reportNull$$$0(13);
        }
        UnknownSdkBalloonNotification.getInstance(this.myProject).notifyFixedSdks(localFixes);
        UnknownSdkEditorNotification.getInstance(this.myProject).showNotifications(unknownSdksWithoutFix, downloadFixes, invalidSdks);
    }

    @NotNull
    private List<UnknownSdkResolver.UnknownSdkLookup> collectSdkLookups(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnknownSdkTracker.$$$reportNull$$$0(14);
        }
        ArrayList<UnknownSdkResolver.UnknownSdkLookup> lookups = new ArrayList<UnknownSdkResolver.UnknownSdkLookup>();
        UnknownSdkResolver.EP_NAME.forEachExtensionSafe(ext -> {
            UnknownSdkResolver.UnknownSdkLookup resolver = ext.createResolver(this.myProject, indicator);
            if (resolver != null) {
                lookups.add(resolver);
            }
        });
        ArrayList<UnknownSdkResolver.UnknownSdkLookup> arrayList = lookups;
        if (arrayList == null) {
            UnknownSdkTracker.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    public void applyDownloadableFix(@NotNull UnknownSdk info, @NotNull UnknownSdkDownloadableSdkFix fix) {
        if (info == null) {
            UnknownSdkTracker.$$$reportNull$$$0(16);
        }
        if (fix == null) {
            UnknownSdkTracker.$$$reportNull$$$0(17);
        }
        UnknownSdkTracker.downloadFix(this.myProject, info, fix, (Consumer<? super Sdk>)((Consumer)sdk2 -> {}), (Consumer<? super Sdk>)((Consumer)sdk2 -> {
            if (sdk2 != null) {
                this.updateUnknownSdksNow();
            }
        }));
    }

    @ApiStatus.Internal
    public static void downloadFix(@Nullable Project project, @NotNull UnknownSdk info, @NotNull UnknownSdkDownloadableSdkFix fix, @NotNull Consumer<? super Sdk> onSdkNameReady, @NotNull Consumer<? super Sdk> onCompleted) {
        if (info == null) {
            UnknownSdkTracker.$$$reportNull$$$0(18);
        }
        if (fix == null) {
            UnknownSdkTracker.$$$reportNull$$$0(19);
        }
        if (onSdkNameReady == null) {
            UnknownSdkTracker.$$$reportNull$$$0(20);
        }
        if (onCompleted == null) {
            UnknownSdkTracker.$$$reportNull$$$0(21);
        }
        UnknownSdkDownloader.downloadFix(project, info, fix, task2 -> {
            String actualSdkName = info.getSdkName();
            if (actualSdkName == null) {
                actualSdkName = task2.getSuggestedSdkName();
            }
            return ProjectJdkTable.getInstance().createSdk(actualSdkName, (SdkTypeId)info.getSdkType());
        }, onSdkNameReady, (Consumer<? super Sdk>)((Consumer)sdk2 -> {
            if (sdk2 != null) {
                fix.configureSdk((Sdk)sdk2);
                UnknownSdkTracker.registerNewSdkInJdkTable(sdk2.getName(), sdk2);
            }
            onCompleted.consume(sdk2);
        }));
    }

    @NotNull
    public EditorNotificationPanel.ActionHandler createSdkSelectionPopup(@Nullable String sdkName, @Nullable SdkType sdkType) {
        EditorNotificationPanel.ActionHandler actionHandler = SdkPopupFactory.newBuilder().withProject(this.myProject).withSdkTypeFilter((Condition<SdkTypeId>)((Condition)type -> sdkType == null || Objects.equals(type, sdkType))).onSdkSelected(sdk2 -> {
            UnknownSdkTracker.registerNewSdkInJdkTable(sdkName, sdk2);
            this.updateUnknownSdks();
        }).buildEditorNotificationPanelHandler();
        if (actionHandler == null) {
            UnknownSdkTracker.$$$reportNull$$$0(22);
        }
        return actionHandler;
    }

    private void configureLocalSdks(@NotNull Map<UnknownSdk, UnknownSdkLocalSdkFix> localFixes) {
        if (localFixes == null) {
            UnknownSdkTracker.$$$reportNull$$$0(23);
        }
        if (localFixes.isEmpty()) {
            return;
        }
        for (Map.Entry<UnknownSdk, UnknownSdkLocalSdkFix> e : localFixes.entrySet()) {
            UnknownSdk info = e.getKey();
            UnknownSdkLocalSdkFix fix = e.getValue();
            UnknownSdkTracker.configureLocalSdk(info, fix, (Consumer<? super Sdk>)((Consumer)sdk2 -> {}));
        }
        this.updateUnknownSdks();
    }

    @ApiStatus.Internal
    public static void configureLocalSdk(@NotNull UnknownSdk info, @NotNull UnknownSdkLocalSdkFix fix, @NotNull Consumer<? super Sdk> onCompleted) {
        if (info == null) {
            UnknownSdkTracker.$$$reportNull$$$0(24);
        }
        if (fix == null) {
            UnknownSdkTracker.$$$reportNull$$$0(25);
        }
        if (onCompleted == null) {
            UnknownSdkTracker.$$$reportNull$$$0(26);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                String actualSdkName = info.getSdkName();
                if (actualSdkName == null) {
                    actualSdkName = fix.getSuggestedSdkName();
                }
                Sdk sdk2 = ProjectJdkTable.getInstance().createSdk(actualSdkName, (SdkTypeId)info.getSdkType());
                SdkModificator mod = sdk2.getSdkModificator();
                mod.setHomePath(FileUtil.toSystemIndependentName((String)fix.getExistingSdkHome()));
                mod.setVersionString(fix.getVersionString());
                mod.commitChanges();
                try {
                    info.getSdkType().setupSdkPaths(sdk2);
                }
                catch (Exception error) {
                    LOG.warn("Failed to setupPaths for " + sdk2 + ". " + error.getMessage(), (Throwable)error);
                }
                fix.configureSdk(sdk2);
                UnknownSdkTracker.registerNewSdkInJdkTable(actualSdkName, sdk2);
                LOG.info("Automatically set Sdk " + info + " to " + fix.getExistingSdkHome());
                onCompleted.consume((Object)sdk2);
            }
            catch (Exception error) {
                LOG.warn("Failed to configure " + info.getSdkType().getPresentableName() + "  for " + info + " for path " + fix + ". " + error.getMessage(), (Throwable)error);
                onCompleted.consume(null);
            }
        });
    }

    @NotNull
    private static <R> Map<UnknownSdk, R> findFixesAndRemoveFixable(@NotNull ProgressIndicator indicator, @NotNull List<UnknownSdk> infos, @NotNull List<UnknownSdkResolver.UnknownSdkLookup> lookups, @NotNull TripleFunction<UnknownSdkResolver.UnknownSdkLookup, UnknownSdk, ProgressIndicator, R> fun) {
        if (indicator == null) {
            UnknownSdkTracker.$$$reportNull$$$0(27);
        }
        if (infos == null) {
            UnknownSdkTracker.$$$reportNull$$$0(28);
        }
        if (lookups == null) {
            UnknownSdkTracker.$$$reportNull$$$0(29);
        }
        if (fun == null) {
            UnknownSdkTracker.$$$reportNull$$$0(30);
        }
        indicator.pushState();
        LinkedHashMap<UnknownSdk, Object> result2 = new LinkedHashMap<UnknownSdk, Object>();
        Iterator<UnknownSdk> iterator2 = infos.iterator();
        block0: while (iterator2.hasNext()) {
            UnknownSdk info = iterator2.next();
            for (UnknownSdkResolver.UnknownSdkLookup lookup2 : lookups) {
                indicator.pushState();
                Object fix = fun.fun((Object)lookup2, (Object)info, (Object)indicator);
                indicator.popState();
                if (fix == null) continue;
                result2.put(info, fix);
                iterator2.remove();
                continue block0;
            }
        }
        indicator.popState();
        LinkedHashMap<UnknownSdk, Object> linkedHashMap = result2;
        if (linkedHashMap == null) {
            UnknownSdkTracker.$$$reportNull$$$0(31);
        }
        return linkedHashMap;
    }

    private static void registerNewSdkInJdkTable(@Nullable String sdkName, @NotNull Sdk sdk2) {
        if (sdk2 == null) {
            UnknownSdkTracker.$$$reportNull$$$0(32);
        }
        WriteAction.run(() -> {
            ProjectJdkTable table = ProjectJdkTable.getInstance();
            if (sdkName != null) {
                Sdk clash = table.findJdk(sdkName);
                if (clash != null) {
                    LOG.warn("SDK with name " + sdkName + " already exists: clash=" + clash + ", new=" + sdk2);
                    return;
                }
                SdkModificator mod = sdk2.getSdkModificator();
                mod.setName(sdkName);
                mod.commitChanges();
            }
            table.addJdk(sdk2);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 15: 
            case 22: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 15: 
            case 22: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 15: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedSdks";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unknownSdksWithoutFix";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFixes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadFixes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidSdks";
                break;
            }
            case 14: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 16: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 17: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSdkNameReady";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onCompleted";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookups";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOnlyAllowedEntries";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOnlyAllowedSdkEntries";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSdkLookups";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdkSelectionPopup";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "findFixesAndRemoveFixable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 15: 
            case 22: 
            case 31: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "allowFixesFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterOnlyAllowedEntries";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterOnlyAllowedSdkEntries";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onFixableAndMissingSdksCollected";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showStatus";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectSdkLookups";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applyDownloadableFix";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "downloadFix";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "configureLocalSdks";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "configureLocalSdk";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findFixesAndRemoveFixable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "registerNewSdkInJdkTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 15: 
            case 22: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

