/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.ConsoleDependentFilterProvider;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.ConsoleFilterProviderEx;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsoleViewUtil {
    public static final Key<Boolean> EDITOR_IS_CONSOLE_HISTORY_VIEW = Key.create((String)"EDITOR_IS_CONSOLE_HISTORY_VIEW");
    private static final Key<Boolean> REPLACE_ACTION_ENABLED = Key.create((String)"REPLACE_ACTION_ENABLED");

    @NotNull
    public static EditorEx setupConsoleEditor(Project project, boolean foldingOutlineShown, boolean lineMarkerAreaShown) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = ((EditorFactoryImpl)editorFactory).createDocument(true);
        UndoUtil.disableUndoFor((Document)document);
        EditorEx editor = (EditorEx)editorFactory.createViewer(document, project, EditorKind.CONSOLE);
        ConsoleViewUtil.setupConsoleEditor(editor, foldingOutlineShown, lineMarkerAreaShown);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            ConsoleViewUtil.$$$reportNull$$$0(0);
        }
        return editorEx;
    }

    public static void setupConsoleEditor(@NotNull EditorEx editor, boolean foldingOutlineShown, boolean lineMarkerAreaShown) {
        if (editor == null) {
            ConsoleViewUtil.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            EditorSettings editorSettings = editor.getSettings();
            editorSettings.setLineMarkerAreaShown(lineMarkerAreaShown);
            editorSettings.setIndentGuidesShown(false);
            editorSettings.setLineNumbersShown(false);
            editorSettings.setFoldingOutlineShown(foldingOutlineShown);
            editorSettings.setAdditionalPageAtBottom(false);
            editorSettings.setAdditionalColumnsCount(0);
            editorSettings.setAdditionalLinesCount(0);
            editorSettings.setRightMarginShown(false);
            editorSettings.setCaretRowShown(false);
            editorSettings.setShowingSpecialChars(false);
            editor.getGutterComponentEx().setPaintBackground(false);
            DelegateColorScheme scheme = ConsoleViewUtil.updateConsoleColorScheme(editor.getColorsScheme());
            if (UISettings.getInstance().getPresentationMode()) {
                scheme.setEditorFontSize(UISettings.getInstance().getPresentationModeFontSize());
            }
            editor.setColorsScheme(scheme);
            editor.setHighlighter(new NullEditorHighlighter());
        });
    }

    @NotNull
    public static DelegateColorScheme updateConsoleColorScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            ConsoleViewUtil.$$$reportNull$$$0(2);
        }
        return new DelegateColorScheme(scheme){

            @Override
            @NotNull
            public Color getDefaultBackground() {
                Color color = this.getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY);
                Color color2 = color == null ? super.getDefaultBackground() : color;
                if (color2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return color2;
            }

            @Override
            @NotNull
            public FontPreferences getFontPreferences() {
                FontPreferences fontPreferences = this.getConsoleFontPreferences();
                if (fontPreferences == null) {
                    1.$$$reportNull$$$0(1);
                }
                return fontPreferences;
            }

            @Override
            public int getEditorFontSize() {
                return this.getConsoleFontSize();
            }

            @Override
            public String getEditorFontName() {
                return this.getConsoleFontName();
            }

            @Override
            public float getLineSpacing() {
                return this.getConsoleLineSpacing();
            }

            @Override
            @NotNull
            public Font getFont(EditorFontType key) {
                Font font = super.getFont(EditorFontType.getConsoleType((EditorFontType)key));
                if (font == null) {
                    1.$$$reportNull$$$0(2);
                }
                return font;
            }

            @Override
            public void setEditorFontSize(int fontSize) {
                this.setConsoleFontSize(fontSize);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/execution/impl/ConsoleViewUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultBackground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFontPreferences";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFont";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static boolean isConsoleViewEditor(@NotNull Editor editor) {
        if (editor == null) {
            ConsoleViewUtil.$$$reportNull$$$0(3);
        }
        return editor.getEditorKind() == EditorKind.CONSOLE;
    }

    public static boolean isReplaceActionEnabledForConsoleViewEditor(@NotNull Editor editor) {
        if (editor == null) {
            ConsoleViewUtil.$$$reportNull$$$0(4);
        }
        return editor.getUserData(REPLACE_ACTION_ENABLED) == Boolean.TRUE;
    }

    public static void enableReplaceActionForConsoleViewEditor(@NotNull Editor editor) {
        if (editor == null) {
            ConsoleViewUtil.$$$reportNull$$$0(5);
        }
        editor.putUserData(REPLACE_ACTION_ENABLED, (Object)true);
    }

    public static void printWithHighlighting(@NotNull ConsoleView console, @NotNull String text, @NotNull SyntaxHighlighter highlighter) {
        if (console == null) {
            ConsoleViewUtil.$$$reportNull$$$0(6);
        }
        if (text == null) {
            ConsoleViewUtil.$$$reportNull$$$0(7);
        }
        if (highlighter == null) {
            ConsoleViewUtil.$$$reportNull$$$0(8);
        }
        ConsoleViewUtil.printWithHighlighting(console, text, highlighter, null);
    }

    public static void printWithHighlighting(@NotNull ConsoleView console, @NotNull String text, @NotNull SyntaxHighlighter highlighter, Runnable doOnNewLine) {
        IElementType tokenType;
        if (console == null) {
            ConsoleViewUtil.$$$reportNull$$$0(9);
        }
        if (text == null) {
            ConsoleViewUtil.$$$reportNull$$$0(10);
        }
        if (highlighter == null) {
            ConsoleViewUtil.$$$reportNull$$$0(11);
        }
        Lexer lexer = highlighter.getHighlightingLexer();
        lexer.start((CharSequence)text, 0, text.length(), 0);
        while ((tokenType = lexer.getTokenType()) != null) {
            ConsoleViewContentType contentType = ConsoleViewUtil.getContentTypeForToken(tokenType, highlighter);
            StringTokenizer eolTokenizer = new StringTokenizer(lexer.getTokenText(), "\n", true);
            while (eolTokenizer.hasMoreTokens()) {
                String tok = eolTokenizer.nextToken();
                console.print(tok, contentType);
                if (doOnNewLine == null || !"\n".equals(tok)) continue;
                doOnNewLine.run();
            }
            lexer.advance();
        }
    }

    @NotNull
    public static ConsoleViewContentType getContentTypeForToken(@NotNull IElementType tokenType, @NotNull SyntaxHighlighter highlighter) {
        TextAttributesKey[] keys2;
        if (tokenType == null) {
            ConsoleViewUtil.$$$reportNull$$$0(12);
        }
        if (highlighter == null) {
            ConsoleViewUtil.$$$reportNull$$$0(13);
        }
        if ((keys2 = highlighter.getTokenHighlights(tokenType)).length == 0) {
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
            if (consoleViewContentType == null) {
                ConsoleViewUtil.$$$reportNull$$$0(14);
            }
            return consoleViewContentType;
        }
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType(ColorCache.keys.get(Arrays.asList(keys2)));
        if (consoleViewContentType == null) {
            ConsoleViewUtil.$$$reportNull$$$0(15);
        }
        return consoleViewContentType;
    }

    public static void printAsFileType(@NotNull ConsoleView console, @NotNull String text, @NotNull FileType fileType) {
        SyntaxHighlighter highlighter;
        if (console == null) {
            ConsoleViewUtil.$$$reportNull$$$0(16);
        }
        if (text == null) {
            ConsoleViewUtil.$$$reportNull$$$0(17);
        }
        if (fileType == null) {
            ConsoleViewUtil.$$$reportNull$$$0(18);
        }
        if ((highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, null, null)) != null) {
            ConsoleViewUtil.printWithHighlighting(console, text, highlighter);
        } else {
            console.print(text, ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    @NotNull
    public static List<Filter> computeConsoleFilters(@NotNull Project project, @Nullable ConsoleView consoleView, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            ConsoleViewUtil.$$$reportNull$$$0(19);
        }
        if (searchScope == null) {
            ConsoleViewUtil.$$$reportNull$$$0(20);
        }
        ArrayList<Filter> result2 = new ArrayList<Filter>();
        for (ConsoleFilterProvider eachProvider : (ConsoleFilterProvider[])ConsoleFilterProvider.FILTER_PROVIDERS.getExtensions()) {
            Object[] filters = consoleView != null && eachProvider instanceof ConsoleDependentFilterProvider ? ((ConsoleDependentFilterProvider)eachProvider).getDefaultFilters(consoleView, project, searchScope) : (eachProvider instanceof ConsoleFilterProviderEx ? ((ConsoleFilterProviderEx)eachProvider).getDefaultFilters(project, searchScope) : eachProvider.getDefaultFilters(project));
            ContainerUtil.addAll(result2, (Object[])filters);
        }
        ArrayList<Filter> arrayList = result2;
        if (arrayList == null) {
            ConsoleViewUtil.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/ConsoleViewUtil";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 6: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 7: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "setupConsoleEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/ConsoleViewUtil";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentTypeForToken";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "computeConsoleFilters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupConsoleEditor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateConsoleColorScheme";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isConsoleViewEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReplaceActionEnabledForConsoleViewEditor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "enableReplaceActionForConsoleViewEditor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "printWithHighlighting";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContentTypeForToken";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "printAsFileType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "computeConsoleFilters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ColorCache {
        static final Map<Key<?>, List<TextAttributesKey>> textAttributeKeys;
        static final Map<Key<?>, TextAttributes> mergedTextAttributes;
        static final Map<List<TextAttributesKey>, Key<?>> keys;

        private ColorCache() {
        }

        static {
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(LafManagerListener.TOPIC, (Object)new LafManagerListener(){

                public void lookAndFeelChanged(@NotNull LafManager source) {
                    if (source == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    mergedTextAttributes.clear();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/execution/impl/ConsoleViewUtil$ColorCache$1", "lookAndFeelChanged"));
                }
            });
            textAttributeKeys = new ConcurrentHashMap();
            mergedTextAttributes = ConcurrentFactoryMap.createMap(contentKey -> {
                EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
                TextAttributes result2 = scheme.getAttributes(HighlighterColors.TEXT);
                for (TextAttributesKey key : textAttributeKeys.get(contentKey)) {
                    TextAttributes attributes = scheme.getAttributes(key);
                    if (attributes == null) continue;
                    result2 = TextAttributes.merge((TextAttributes)result2, (TextAttributes)attributes);
                }
                return result2;
            });
            keys = ConcurrentFactoryMap.createMap(keys2 -> {
                StringBuilder keyName = new StringBuilder("ConsoleViewUtil_");
                for (TextAttributesKey key : keys2) {
                    keyName.append("_").append(key.getExternalName());
                }
                final Key newKey = new Key(keyName.toString());
                textAttributeKeys.put((Key<?>)newKey, (List<TextAttributesKey>)keys2);
                ConsoleViewContentType contentType = new ConsoleViewContentType(keyName.toString(), new TextAttributes()){

                    public TextAttributes getAttributes() {
                        return mergedTextAttributes.get(newKey);
                    }
                };
                ConsoleViewContentType.registerNewConsoleViewType((Key)newKey, (ConsoleViewContentType)contentType);
                return newKey;
            });
        }
    }

    private static class NullEditorHighlighter
    extends EmptyEditorHighlighter {
        private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();

        NullEditorHighlighter() {
            super(NULL_ATTRIBUTES);
        }

        @Override
        public void setAttributes(TextAttributes attributes) {
        }

        @Override
        public void setColorScheme(@NotNull EditorColorsScheme scheme) {
            if (scheme == null) {
                NullEditorHighlighter.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/execution/impl/ConsoleViewUtil$NullEditorHighlighter", "setColorScheme"));
        }
    }
}

