/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion;

import com.intellij.conversion.ArtifactsSettings;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectLibrariesSettings;
import com.intellij.conversion.ProjectSettings;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.conversion.WorkspaceSettings;
import com.intellij.openapi.components.StorageScheme;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ConversionContext {
    @NotNull
    public File getProjectBaseDir();

    @NotNull
    public File getProjectFile();

    @NotNull
    public StorageScheme getStorageScheme();

    public File getSettingsBaseDir();

    public ProjectSettings getProjectSettings() throws CannotConvertException;

    public RunManagerSettings getRunManagerSettings() throws CannotConvertException;

    public WorkspaceSettings getWorkspaceSettings() throws CannotConvertException;

    default public ModuleSettings getModuleSettings(File moduleFile) throws CannotConvertException {
        return this.getModuleSettings(moduleFile.toPath());
    }

    public ModuleSettings getModuleSettings(@NotNull Path var1) throws CannotConvertException;

    @Nullable
    public ModuleSettings getModuleSettings(@NotNull String var1);

    @Nullable
    public ComponentManagerSettings createProjectSettings(@NotNull String var1);

    @NotNull
    public String collapsePath(@NotNull String var1);

    public Collection<File> getLibraryClassRoots(@NotNull String var1, @NotNull String var2);

    @Nullable
    public ComponentManagerSettings getCompilerSettings();

    @Nullable
    public ComponentManagerSettings getProjectRootManagerSettings();

    @NotNull
    public List<Path> getModulePaths() throws CannotConvertException;

    @Deprecated
    public File[] getModuleFiles();

    public ComponentManagerSettings getModulesSettings();

    public ProjectLibrariesSettings getProjectLibrariesSettings() throws CannotConvertException;

    public ArtifactsSettings getArtifactsSettings() throws CannotConvertException;

    @NotNull
    public String expandPath(@NotNull String var1);
}

