/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.UnwrapHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class UnwrapTestCase
extends LightPlatformCodeInsightTestCase {
    protected void assertUnwrapped(String codeBefore, String expectedCodeAfter) {
        this.assertUnwrapped(codeBefore, expectedCodeAfter, 0);
    }

    protected void assertUnwrapped(String codeBefore, String expectedCodeAfter, final int option) {
        this.configureCode(codeBefore);
        UnwrapHandler h = new UnwrapHandler(){

            protected void selectOption(List<? extends UnwrapHandler.MyUnwrapAction> options2, Editor editor, PsiFile file2) {
                if (options2.isEmpty()) {
                    return;
                }
                options2.get(option).perform();
            }
        };
        h.invoke(this.getProject(), this.getEditor(), this.getFile());
        this.checkResultByText(this.createCode(expectedCodeAfter));
    }

    protected void assertOptions(String code, String ... expectedOptions) {
        this.configureCode(code);
        final ArrayList actualOptions = new ArrayList();
        UnwrapHandler h = new UnwrapHandler(){

            protected void selectOption(List<? extends UnwrapHandler.MyUnwrapAction> options2, Editor editor, PsiFile file2) {
                for (AnAction anAction : options2) {
                    actualOptions.add(anAction.getTemplatePresentation().getText());
                }
            }
        };
        h.invoke(this.getProject(), this.getEditor(), this.getFile());
        UnwrapTestCase.assertEquals(Arrays.asList(expectedOptions), actualOptions);
    }

    protected void configureCode(String codeBefore) {
        this.configureFromFileText(this.getFileNameToCreate(), this.createCode(codeBefore));
    }

    protected String getFileNameToCreate() {
        return "A.java";
    }

    protected String createCode(String codeBefore) {
        return "public class A {\n    void foo() {\n" + UnwrapTestCase.indentTwice(codeBefore) + "    }\n}";
    }

    protected static String indentTwice(String code) {
        return UnwrapTestCase.indent(code, 2);
    }

    protected static String indent(String code) {
        return UnwrapTestCase.indent(code, 1);
    }

    protected static String indent(String code, int times) {
        StringBuilder result = new StringBuilder();
        for (String line : StringUtil.tokenize((String)code, (String)"\n")) {
            for (int i = 0; i < times; ++i) {
                result.append("    ");
            }
            result.append(line).append('\n');
        }
        return result.toString();
    }
}

