/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters.values;

import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlDomBundle;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanValueConverter
extends ResolvingConverter<String> {
    @NonNls
    private static final String BOOLEAN = "boolean";
    @NonNls
    private static final String[] VARIANTS = new String[]{"false", "true"};
    private final boolean myAllowEmpty;

    public static BooleanValueConverter getInstance(boolean allowEmpty) {
        return new BooleanValueConverter(allowEmpty);
    }

    public BooleanValueConverter() {
        this(false);
    }

    public BooleanValueConverter(boolean allowEmpty) {
        this.myAllowEmpty = allowEmpty;
    }

    @NonNls
    public String[] getAllValues() {
        Object[] strings = ArrayUtil.mergeArrays((String[])this.getTrueValues(), (String[])this.getFalseValues());
        Arrays.sort(strings);
        return strings;
    }

    @NonNls
    public String[] getTrueValues() {
        return new String[]{"true"};
    }

    @NonNls
    public String[] getFalseValues() {
        return new String[]{"false"};
    }

    public boolean isTrue(String s) {
        return Arrays.binarySearch(this.getTrueValues(), s) >= 0;
    }

    @Override
    public String fromString(@Nullable @NonNls String stringValue, ConvertContext context) {
        if (stringValue != null && (this.myAllowEmpty && stringValue.trim().length() == 0 || Arrays.binarySearch(this.getAllValues(), stringValue) >= 0)) {
            return stringValue;
        }
        return null;
    }

    @Override
    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    @Override
    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        List<String> list = Arrays.asList(VARIANTS);
        if (list == null) {
            BooleanValueConverter.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return XmlDomBundle.message("value.converter.format.exception", s, BOOLEAN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/values/BooleanValueConverter", "getVariants"));
    }
}

