/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.changes;

import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.log.graph.DefaultColorGenerator;
import com.intellij.vcs.log.paint.PaintParameters;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHCommit;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRCommitsListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "()V", "messageComponent", "Lcom/intellij/ui/SimpleColoredComponent;", "nodeComponent", "Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRCommitsListCellRenderer$CommitNodeComponent;", "panel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lorg/jetbrains/annotations/NotNull;", "getPanel", "()Lcom/intellij/util/ui/components/BorderLayoutPanel;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "CommitNodeComponent", "intellij.vcs.github"})
public final class GHPRCommitsListCellRenderer
implements ListCellRenderer<GHCommit> {
    private final CommitNodeComponent nodeComponent;
    private final SimpleColoredComponent messageComponent;
    @NotNull
    private final BorderLayoutPanel panel;

    @NotNull
    public final BorderLayoutPanel getPanel() {
        return this.panel;
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends GHCommit> list2, @Nullable GHCommit value, int index, boolean isSelected, boolean cellHasFocus) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"list");
        this.messageComponent.clear();
        GHCommit gHCommit = value;
        String string = gHCommit != null ? gHCommit.getMessageHeadline() : null;
        SimpleColoredComponent simpleColoredComponent = this.messageComponent;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string2;
        simpleColoredComponent.append(string3, new SimpleTextAttributes(0, UIUtil.getListForeground((boolean)isSelected, (boolean)cellHasFocus)));
        SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)list2, (SimpleColoredComponent)this.messageComponent, (boolean)true, (boolean)isSelected);
        ListModel<? extends GHCommit> listModel = list2.getModel();
        Intrinsics.checkExpressionValueIsNotNull(listModel, (String)"list.model");
        int size = listModel.getSize();
        if (size <= 1) {
            this.nodeComponent.setType(CommitNodeComponent.Type.SINGLE);
        } else if (index == 0) {
            this.nodeComponent.setType(CommitNodeComponent.Type.FIRST);
        } else if (index == size - 1) {
            this.nodeComponent.setType(CommitNodeComponent.Type.LAST);
        } else {
            this.nodeComponent.setType(CommitNodeComponent.Type.MIDDLE);
        }
        this.panel.setBackground(UIUtil.getListBackground((boolean)isSelected, (boolean)cellHasFocus));
        return (Component)this.panel;
    }

    public GHPRCommitsListCellRenderer() {
        CommitNodeComponent commitNodeComponent;
        CommitNodeComponent commitNodeComponent2 = new CommitNodeComponent();
        GHPRCommitsListCellRenderer gHPRCommitsListCellRenderer = this;
        boolean bl = false;
        boolean bl2 = false;
        CommitNodeComponent $this$apply = commitNodeComponent2;
        boolean bl3 = false;
        $this$apply.setForeground((Color)new DefaultColorGenerator().getColor(1));
        gHPRCommitsListCellRenderer.nodeComponent = commitNodeComponent = commitNodeComponent2;
        this.messageComponent = new SimpleColoredComponent();
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel().addToLeft((Component)this.nodeComponent).addToCenter((Component)this.messageComponent);
        Intrinsics.checkExpressionValueIsNotNull((Object)borderLayoutPanel, (String)"BorderLayoutPanel().addT\u2026oCenter(messageComponent)");
        this.panel = borderLayoutPanel;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0018H\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRCommitsListCellRenderer$CommitNodeComponent;", "Ljavax/swing/JComponent;", "()V", "type", "Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRCommitsListCellRenderer$CommitNodeComponent$Type;", "getType", "()Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRCommitsListCellRenderer$CommitNodeComponent$Type;", "setType", "(Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRCommitsListCellRenderer$CommitNodeComponent$Type;)V", "drawEdge", "", "g", "Ljava/awt/Graphics2D;", "rect", "Ljava/awt/Rectangle;", "y1", "", "y2", "drawEdgeDown", "drawEdgeUp", "drawNode", "getPreferredSize", "Lcom/intellij/util/ui/JBDimension;", "paintComponent", "Ljava/awt/Graphics;", "Type", "intellij.vcs.github"})
    private static final class CommitNodeComponent
    extends JComponent {
        @NotNull
        private Type type = Type.SINGLE;

        @NotNull
        public final Type getType() {
            return this.type;
        }

        public final void setType(@NotNull Type type) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"<set-?>");
            this.type = type;
        }

        @NotNull
        public JBDimension getPreferredSize() {
            return new JBDimension(PaintParameters.getNodeWidth((int)22), 22);
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
            Rectangle rect = new Rectangle(this.getSize());
            JBInsets.removeFrom((Rectangle)rect, (Insets)this.getInsets());
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            if (this.isOpaque()) {
                g2.setColor(this.getBackground());
                g2.fill(new Rectangle2D.Float(rect.x, rect.y, rect.width, rect.height));
            }
            g2.setColor(this.getForeground());
            this.drawNode(g2, rect);
            if (this.type == Type.LAST || this.type == Type.MIDDLE) {
                this.drawEdgeUp(g2, rect);
            }
            if (this.type == Type.FIRST || this.type == Type.MIDDLE) {
                this.drawEdgeDown(g2, rect);
            }
        }

        private final void drawNode(Graphics2D g, Rectangle rect) {
            int radius = PaintParameters.getCircleRadius((int)rect.height);
            Ellipse2D.Double circle = new Ellipse2D.Double(rect.getCenterX() - (double)radius, rect.getCenterY() - (double)radius, (double)radius * 2.0, (double)radius * 2.0);
            g.fill(circle);
        }

        private final void drawEdgeUp(Graphics2D g, Rectangle rect) {
            double y1 = 0.0;
            double y2 = rect.getCenterY();
            this.drawEdge(g, rect, y1, y2);
        }

        private final void drawEdgeDown(Graphics2D g, Rectangle rect) {
            double y1 = rect.getCenterY();
            double y2 = rect.getMaxY();
            this.drawEdge(g, rect, y1, y2);
        }

        private final void drawEdge(Graphics2D g, Rectangle rect, double y1, double y2) {
            double x = rect.getCenterX();
            float width = PaintParameters.getLineThickness((int)rect.height);
            Rectangle2D.Double line = new Rectangle2D.Double(x - (double)(width / (float)2), y1 - 0.5, width, y1 + y2 + 0.5);
            g.fill(line);
        }

        public CommitNodeComponent() {
            this.setOpaque(false);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRCommitsListCellRenderer$CommitNodeComponent$Type;", "", "(Ljava/lang/String;I)V", "SINGLE", "FIRST", "MIDDLE", "LAST", "intellij.vcs.github"})
        public static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type SINGLE;
            public static final /* enum */ Type FIRST;
            public static final /* enum */ Type MIDDLE;
            public static final /* enum */ Type LAST;
            private static final /* synthetic */ Type[] $VALUES;

            static {
                Type[] typeArray = new Type[4];
                Type[] typeArray2 = typeArray;
                typeArray[0] = SINGLE = new Type();
                typeArray[1] = FIRST = new Type();
                typeArray[2] = MIDDLE = new Type();
                typeArray[3] = LAST = new Type();
                $VALUES = typeArray;
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String string) {
                return Enum.valueOf(Type.class, string);
            }
        }
    }
}

