/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import net.sf.mpxj.Duration;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.fasttrack.FastTrackField;
import net.sf.mpxj.fasttrack.FastTrackTable;

class MapRow {
    protected final Map<FastTrackField, Object> m_map;
    private final FastTrackTable m_table;

    public MapRow(FastTrackTable fastTrackTable, Map<FastTrackField, Object> map) {
        this.m_table = fastTrackTable;
        this.m_map = map;
    }

    public String getString(FastTrackField fastTrackField) {
        return (String)this.getObject(fastTrackField);
    }

    public Integer getInteger(FastTrackField fastTrackField) {
        return (Integer)this.getObject(fastTrackField);
    }

    public Double getDouble(FastTrackField fastTrackField) {
        return (Double)this.getObject(fastTrackField);
    }

    public Double getCurrency(FastTrackField fastTrackField) {
        return this.getDouble(fastTrackField);
    }

    public boolean getBoolean(FastTrackField fastTrackField) {
        boolean bl = false;
        Object object = this.getObject(fastTrackField);
        if (object != null) {
            bl = BooleanHelper.getBoolean((Boolean)object);
        }
        return bl;
    }

    public int getInt(FastTrackField fastTrackField) {
        return NumberHelper.getInt((Number)this.getObject(fastTrackField));
    }

    public Date getTimestamp(FastTrackField fastTrackField, FastTrackField fastTrackField2) {
        Date date = null;
        Date date2 = this.getDate(fastTrackField);
        if (date2 != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date2);
            Date date3 = this.getDate(fastTrackField2);
            if (date3 != null) {
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTime(date3);
                calendar.set(11, calendar2.get(11));
                calendar.set(12, calendar2.get(12));
                calendar.set(13, calendar2.get(13));
                calendar.set(14, calendar2.get(14));
            }
            date = calendar.getTime();
        }
        return date;
    }

    public Date getDate(FastTrackField fastTrackField) {
        return (Date)this.getObject(fastTrackField);
    }

    public Duration getDuration(FastTrackField fastTrackField) {
        Double d = (Double)this.getObject(fastTrackField);
        return d == null ? null : Duration.getInstance(d, this.m_table.getDurationTimeUnit());
    }

    public Duration getWork(FastTrackField fastTrackField) {
        Double d = (Double)this.getObject(fastTrackField);
        return d == null ? null : Duration.getInstance(d, this.m_table.getWorkTimeUnit());
    }

    public Object getObject(FastTrackField fastTrackField) {
        Object object = this.m_map.get(fastTrackField);
        return object;
    }

    public UUID getUUID(FastTrackField fastTrackField) {
        String string = this.getString(fastTrackField);
        UUID uUID = null;
        if (string != null && !string.isEmpty() && string.length() >= 36) {
            if (string.startsWith("{")) {
                string = string.substring(1, string.length() - 1);
            }
            if (string.length() > 16) {
                string = string.substring(0, 36);
            }
            uUID = UUID.fromString(string);
        }
        return uUID;
    }

    public Map<FastTrackField, Object> getMap() {
        return this.m_map;
    }
}

