/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * any(bvec2(false, false)) => false
 * any(bvec2(false, true)) => true
 * any(bvec2(true, false)) => true
 * any(bvec2(true, true)) => true
 */
#version 150

void main()
{
  float[any(bvec2(false, false)) == false ? 1 : -1] array0;
  float[any(bvec2(false, true)) == true ? 1 : -1] array1;
  float[any(bvec2(true, false)) == true ? 1 : -1] array2;
  float[any(bvec2(true, true)) == true ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
