/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * greaterThan(vec4(-1.5, -1.5, -1.5, -1.5), vec4(-1.5, -0.5, 0.5, 1.5)) => bvec4(false, false, false, false)
 * greaterThan(vec4(-0.5, -0.5, -0.5, -0.5), vec4(-1.5, -0.5, 0.5, 1.5)) => bvec4(true, false, false, false)
 * greaterThan(vec4(0.5, 0.5, 0.5, 0.5), vec4(-1.5, -0.5, 0.5, 1.5)) => bvec4(true, true, false, false)
 * greaterThan(vec4(1.5, 1.5, 1.5, 1.5), vec4(-1.5, -0.5, 0.5, 1.5)) => bvec4(true, true, true, false)
 */
#version 120

void main()
{
  float[all(equal(greaterThan(vec4(-1.5, -1.5, -1.5, -1.5), vec4(-1.5, -0.5, 0.5, 1.5)), bvec4(false, false, false, false))) ? 1 : -1] array0;
  float[all(equal(greaterThan(vec4(-0.5, -0.5, -0.5, -0.5), vec4(-1.5, -0.5, 0.5, 1.5)), bvec4(true, false, false, false))) ? 1 : -1] array1;
  float[all(equal(greaterThan(vec4(0.5, 0.5, 0.5, 0.5), vec4(-1.5, -0.5, 0.5, 1.5)), bvec4(true, true, false, false))) ? 1 : -1] array2;
  float[all(equal(greaterThan(vec4(1.5, 1.5, 1.5, 1.5), vec4(-1.5, -0.5, 0.5, 1.5)), bvec4(true, true, true, false))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
