/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import org.directwebremoting.extend.NestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;

public class ArrayOutboundVariable
extends NestedOutboundVariable {
    public ArrayOutboundVariable(OutboundContext context) {
        super(context);
    }

    @Override
    public String getDeclareCode() {
        if (this.isInline()) {
            return this.getChildDeclareCodes();
        }
        return this.getChildDeclareCodes() + "var " + this.getVariableName() + "=[];";
    }

    @Override
    public String getBuildCode() {
        if (this.isInline()) {
            return this.getChildBuildCodes();
        }
        StringBuffer buffer = new StringBuffer(this.getChildBuildCodes());
        int i = 0;
        String variableName = this.getVariableName();
        for (OutboundVariable child : this.getChildren()) {
            if (child != null) {
                buffer.append(variableName);
                buffer.append('[');
                buffer.append(i);
                buffer.append("]=");
                buffer.append(child.getAssignCode());
                buffer.append(';');
            }
            ++i;
        }
        buffer.append("\r\n");
        return buffer.toString();
    }

    @Override
    public String getAssignCode() {
        if (this.isInline()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[");
            boolean first = true;
            for (OutboundVariable child : this.getChildren()) {
                if (!first) {
                    buffer.append(',');
                }
                buffer.append(child.getAssignCode());
                first = false;
            }
            buffer.append("]");
            return buffer.toString();
        }
        return this.getVariableName();
    }
}

