function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { last, findIndex, isNaN } from 'lodash';
import React, { Component } from 'react';
import { isColorDark } from '@elastic/eui';
import { MetricVisValue } from './metric_vis_value';
import { getHeatmapColors } from '../../../charts/public';
import { getFormatService } from '../services';
export var MetricVisComponent = /*#__PURE__*/function (_Component) {
  _inherits(MetricVisComponent, _Component);

  var _super = _createSuper(MetricVisComponent);

  function MetricVisComponent() {
    var _this;

    _classCallCheck(this, MetricVisComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "getFormattedValue", function (fieldFormatter, value) {
      var format = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'text';
      if (isNaN(value)) return '-';
      return fieldFormatter.convert(value, format);
    });

    _defineProperty(_assertThisInitialized(_this), "filterBucket", function (metric) {
      var dimensions = _this.props.visParams.dimensions;

      if (!dimensions.bucket) {
        return;
      }

      var table = _this.props.visData;

      _this.props.vis.API.events.filter({
        table: table,
        column: dimensions.bucket.accessor,
        row: metric.rowIndex
      });
    });

    _defineProperty(_assertThisInitialized(_this), "renderMetric", function (metric, index) {
      return /*#__PURE__*/React.createElement(MetricVisValue, {
        key: index,
        metric: metric,
        fontSize: _this.props.visParams.metric.style.fontSize,
        onFilter: _this.props.visParams.dimensions.bucket ? _this.filterBucket : undefined,
        showLabel: _this.props.visParams.metric.labels.show
      });
    });

    return _this;
  }

  _createClass(MetricVisComponent, [{
    key: "getLabels",
    value: function getLabels() {
      var config = this.props.visParams.metric;
      var isPercentageMode = config.percentageMode;
      var colorsRange = config.colorsRange;
      var max = last(colorsRange).to;
      var labels = [];
      colorsRange.forEach(function (range) {
        var from = isPercentageMode ? Math.round(100 * range.from / max) : range.from;
        var to = isPercentageMode ? Math.round(100 * range.to / max) : range.to;
        labels.push("".concat(from, " - ").concat(to));
      });
      return labels;
    }
  }, {
    key: "getColors",
    value: function getColors() {
      var config = this.props.visParams.metric;
      var invertColors = config.invertColors;
      var colorSchema = config.colorSchema;
      var colorsRange = config.colorsRange;
      var labels = this.getLabels();
      var colors = {};

      for (var i = 0; i < labels.length; i += 1) {
        var divider = Math.max(colorsRange.length - 1, 1);
        var val = invertColors ? 1 - i / divider : i / divider;
        colors[labels[i]] = getHeatmapColors(val, colorSchema);
      }

      return colors;
    }
  }, {
    key: "getBucket",
    value: function getBucket(val) {
      var config = this.props.visParams.metric;
      var bucket = findIndex(config.colorsRange, function (range) {
        return range.from <= val && range.to > val;
      });

      if (bucket === -1) {
        if (val < config.colorsRange[0].from) bucket = 0;else bucket = config.colorsRange.length - 1;
      }

      return bucket;
    }
  }, {
    key: "getColor",
    value: function getColor(val, labels, colors) {
      var bucket = this.getBucket(val);
      var label = labels[bucket];
      return colors[label];
    }
  }, {
    key: "needsLightText",
    value: function needsLightText(bgColor) {
      var colors = /rgb\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)/.exec(bgColor);

      if (!colors) {
        return false;
      }

      var _colors$slice$map = colors.slice(1).map(function (c) {
        return parseInt(c, 10);
      }),
          _colors$slice$map2 = _slicedToArray(_colors$slice$map, 3),
          red = _colors$slice$map2[0],
          green = _colors$slice$map2[1],
          blue = _colors$slice$map2[2];

      return isColorDark(red, green, blue);
    }
  }, {
    key: "processTableGroups",
    value: function processTableGroups(table) {
      var _this2 = this;

      var config = this.props.visParams.metric;
      var dimensions = this.props.visParams.dimensions;
      var isPercentageMode = config.percentageMode;
      var min = config.colorsRange[0].from;
      var max = last(config.colorsRange).to;
      var colors = this.getColors();
      var labels = this.getLabels();
      var metrics = [];
      var bucketColumnId;
      var bucketFormatter;

      if (dimensions.bucket) {
        bucketColumnId = table.columns[dimensions.bucket.accessor].id;
        bucketFormatter = getFormatService().deserialize(dimensions.bucket.format);
      }

      dimensions.metrics.forEach(function (metric) {
        var columnIndex = metric.accessor;
        var column = table === null || table === void 0 ? void 0 : table.columns[columnIndex];
        var formatter = getFormatService().deserialize(metric.format);
        table.rows.forEach(function (row, rowIndex) {
          var title = column.name;
          var value = row[column.id];

          var color = _this2.getColor(value, labels, colors);

          if (isPercentageMode) {
            value = (value - min) / (max - min);
          }

          value = _this2.getFormattedValue(formatter, value, 'html');

          if (bucketColumnId) {
            var bucketValue = _this2.getFormattedValue(bucketFormatter, row[bucketColumnId]);

            title = "".concat(bucketValue, " - ").concat(title);
          }

          var shouldColor = config.colorsRange.length > 1;
          metrics.push({
            label: title,
            value: value,
            color: shouldColor && config.style.labelColor ? color : undefined,
            bgColor: shouldColor && config.style.bgColor ? color : undefined,
            lightText: shouldColor && config.style.bgColor && _this2.needsLightText(color),
            rowIndex: rowIndex
          });
        });
      });
      return metrics;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.props.renderComplete();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.props.renderComplete();
    }
  }, {
    key: "render",
    value: function render() {
      var metricsHtml;

      if (this.props.visData) {
        var metrics = this.processTableGroups(this.props.visData);
        metricsHtml = metrics.map(this.renderMetric);
      }

      return /*#__PURE__*/React.createElement("div", {
        className: "mtrVis"
      }, metricsHtml);
    }
  }]);

  return MetricVisComponent;
}(Component);