var _AggGroupNames$Bucket, _AggGroupNames$Metric;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _, { defaults } from 'lodash';
import { AggGroupNames } from '../../data/public';
_AggGroupNames$Bucket = AggGroupNames.Buckets;
_AggGroupNames$Metric = AggGroupNames.Metrics;
export var Schemas = function Schemas(schemas) {
  var _this = this;

  _classCallCheck(this, Schemas);

  _defineProperty(this, "all", []);

  _defineProperty(this, _AggGroupNames$Bucket, []);

  _defineProperty(this, _AggGroupNames$Metric, []);

  _(schemas || []).chain().map(function (schema) {
    if (!schema.name) throw new Error('all schema must have a unique name');

    if (schema.name === 'split') {
      schema.params = [{
        name: 'row',
        default: true
      }];
    }

    defaults(schema, {
      min: 0,
      max: Infinity,
      group: AggGroupNames.Buckets,
      title: schema.name,
      aggFilter: '*',
      editor: false,
      params: []
    });
    return schema;
  }).tap(function (fullSchemas) {
    _this.all = fullSchemas;
  }).groupBy('group').forOwn(function (group, groupName) {
    // @ts-ignore
    _this[groupName] = group;
  }).commit();
};
export var getSchemaByName = function getSchemaByName(schemas, schemaName) {
  return schemas.find(function (s) {
    return s.name === schemaName;
  }) || {};
};