function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Suspense, lazy } from 'react';
import { render as _render, unmountComponentAtNode } from 'react-dom';
import { i18n } from '@kbn/i18n';
import { EuiErrorBoundary, EuiLoadingChart } from '@elastic/eui';
import { DefaultEditorDataTab } from './components/sidebar';
var DefaultEditor = /*#__PURE__*/lazy(function () {
  return import('./default_editor');
});

var DefaultEditorController = /*#__PURE__*/function () {
  function DefaultEditorController(el, vis, eventEmitter, embeddableHandler) {
    _classCallCheck(this, DefaultEditorController);

    _defineProperty(this, "el", void 0);

    _defineProperty(this, "state", void 0);

    this.el = el;
    var visType = vis.type;
    var optionTabs = [].concat(_toConsumableArray(visType.schemas.buckets || visType.schemas.metrics ? [{
      name: 'data',
      title: i18n.translate('visDefaultEditor.sidebar.tabs.dataLabel', {
        defaultMessage: 'Data'
      }),
      editor: DefaultEditorDataTab
    }] : []), _toConsumableArray(!visType.editorConfig.optionTabs && visType.editorConfig.optionsTemplate ? [{
      name: 'options',
      title: i18n.translate('visDefaultEditor.sidebar.tabs.optionsLabel', {
        defaultMessage: 'Options'
      }),
      editor: visType.editorConfig.optionsTemplate
    }] : visType.editorConfig.optionTabs));
    this.state = {
      vis: vis,
      optionTabs: optionTabs,
      eventEmitter: eventEmitter,
      embeddableHandler: embeddableHandler
    };
  }

  _createClass(DefaultEditorController, [{
    key: "render",
    value: function render(props) {
      _render( /*#__PURE__*/React.createElement(EuiErrorBoundary, null, /*#__PURE__*/React.createElement(Suspense, {
        fallback: /*#__PURE__*/React.createElement("div", {
          style: {
            display: 'flex',
            flex: '1 1 auto',
            justifyContent: 'center',
            alignItems: 'center'
          }
        }, /*#__PURE__*/React.createElement(EuiLoadingChart, {
          size: "xl",
          mono: true
        }))
      }, /*#__PURE__*/React.createElement(DefaultEditor, _extends({}, this.state, props)))), this.el);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      unmountComponentAtNode(this.el);
    }
  }]);

  return DefaultEditorController;
}();

export { DefaultEditorController };