function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { useEffect, useCallback, useMemo } from 'react';
import { i18n } from '@kbn/i18n';
var DEFAULT_METRIC = 'custom';
var CUSTOM_METRIC = {
  text: i18n.translate('visDefaultEditor.controls.customMetricLabel', {
    defaultMessage: 'Custom metric'
  }),
  value: DEFAULT_METRIC
};

function useCompatibleAggCallback(aggFilter) {
  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  return useCallback(isCompatibleAggregation(aggFilter), [aggFilter]);
}
/**
 * the effect is used to set up a default metric aggregation in case,
 * when previously selected metric has been removed
 */


function useFallbackMetric(setValue, aggFilter, metricAggs, value, fallbackValue) {
  var isCompatibleAgg = useCompatibleAggCallback(aggFilter);
  useEffect(function () {
    if (metricAggs && value && value !== DEFAULT_METRIC) {
      // ensure that metric is set to a valid agg
      var respAgg = metricAggs.filter(isCompatibleAgg).find(function (aggregation) {
        return aggregation.id === value;
      });

      if (!respAgg && value !== fallbackValue) {
        setValue(fallbackValue);
      }
    }
  }, [setValue, isCompatibleAgg, metricAggs, value, fallbackValue]);
}
/**
 * this makes an array of available options in appropriate format for EuiSelect,
 * calculates if an option is disabled
 */


function useAvailableOptions(aggFilter) {
  var metricAggs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  var defaultOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
  var isCompatibleAgg = useCompatibleAggCallback(aggFilter);
  var options = useMemo(function () {
    return [].concat(_toConsumableArray(metricAggs.map(function (respAgg) {
      return {
        text: i18n.translate('visDefaultEditor.controls.definiteMetricLabel', {
          defaultMessage: 'Metric: {metric}',
          values: {
            metric: safeMakeLabel(respAgg)
          }
        }),
        value: respAgg.id,
        disabled: !isCompatibleAgg(respAgg)
      };
    })), [CUSTOM_METRIC], _toConsumableArray(defaultOptions));
  }, [metricAggs, defaultOptions, isCompatibleAgg]);
  return options;
}
/**
 * the effect is used to set up the editor form validity
 * and reset it if a param has been removed
 */


function useValidation(setValidity, isValid) {
  useEffect(function () {
    setValidity(isValid);
    return function () {
      return setValidity(true);
    };
  }, [isValid, setValidity]);
}

function safeMakeLabel(agg) {
  try {
    return agg.makeLabel();
  } catch (e) {
    return i18n.translate('visDefaultEditor.controls.aggNotValidLabel', {
      defaultMessage: '- agg not valid -'
    });
  }
}

function isCompatibleAggregation(aggFilter) {
  return function (agg) {
    return !aggFilter.includes("!".concat(agg.type.name));
  };
}

export { CUSTOM_METRIC, safeMakeLabel, isCompatibleAggregation, useAvailableOptions, useFallbackMetric, useValidation };