function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, useEffect } from 'react';
import { AGG_PARAMS_ACTION_KEYS } from './agg_params_state';

function DefaultEditorAggParam(props) {
  var agg = props.agg,
      aggParam = props.aggParam,
      ParamEditor = props.paramEditor,
      setAggParamValue = props.setAggParamValue,
      onChangeParamsState = props.onChangeParamsState,
      rest = _objectWithoutProperties(props, ["agg", "aggParam", "paramEditor", "setAggParamValue", "onChangeParamsState"]);

  var setValidity = useCallback(function (valid) {
    onChangeParamsState({
      type: AGG_PARAMS_ACTION_KEYS.VALID,
      paramName: aggParam.name,
      payload: valid
    });
  }, [onChangeParamsState, aggParam.name]); // setTouched can be called from sub-agg which passes a parameter

  var setTouched = useCallback(function () {
    var isTouched = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
    onChangeParamsState({
      type: AGG_PARAMS_ACTION_KEYS.TOUCHED,
      paramName: aggParam.name,
      payload: isTouched
    });
  }, [onChangeParamsState, aggParam.name]);
  var setValue = useCallback(function (value) {
    if (props.value !== value) {
      setAggParamValue(agg.id, aggParam.name, value);
    }
  }, [setAggParamValue, agg.id, aggParam.name, props.value]);
  useEffect(function () {
    if (aggParam.shouldShow && !aggParam.shouldShow(agg)) {
      setValidity(true);
    }
  }, [agg, agg.params.field, aggParam, setValidity]);

  if (aggParam.shouldShow && !aggParam.shouldShow(agg)) {
    return null;
  }

  return /*#__PURE__*/React.createElement(ParamEditor, _extends({
    agg: agg,
    aggParam: aggParam,
    setValidity: setValidity,
    setTouched: setTouched,
    setValue: setValue
  }, rest));
}

export { DefaultEditorAggParam };