function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { htmlIdGenerator, EuiButton, EuiButtonEmpty, EuiCallOut, EuiFieldText, EuiForm, EuiFormRow, EuiModal, EuiModalBody, EuiModalFooter, EuiModalHeader, EuiModalHeaderTitle, EuiOverlayMask, EuiSpacer, EuiSwitch, EuiTextArea } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import React from 'react';
import { EuiText } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
var generateId = htmlIdGenerator();
export var SavedObjectSaveModal = /*#__PURE__*/function (_React$Component) {
  _inherits(SavedObjectSaveModal, _React$Component);

  var _super = _createSuper(SavedObjectSaveModal);

  function SavedObjectSaveModal() {
    var _this;

    _classCallCheck(this, SavedObjectSaveModal);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "warning", /*#__PURE__*/React.createRef());

    _defineProperty(_assertThisInitialized(_this), "state", {
      title: _this.props.title,
      copyOnSave: Boolean(_this.props.initialCopyOnSave),
      isTitleDuplicateConfirmed: false,
      hasTitleDuplicate: false,
      isLoading: false,
      visualizationDescription: _this.props.description ? _this.props.description : ''
    });

    _defineProperty(_assertThisInitialized(_this), "renderViewDescription", function () {
      if (!_this.props.showDescription) {
        return;
      }

      return /*#__PURE__*/React.createElement(EuiFormRow, {
        fullWidth: true,
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjects.saveModal.descriptionLabel",
          defaultMessage: "Description"
        })
      }, /*#__PURE__*/React.createElement(EuiTextArea, {
        "data-test-subj": "viewDescription",
        value: _this.state.visualizationDescription,
        onChange: _this.onDescriptionChange
      }));
    });

    _defineProperty(_assertThisInitialized(_this), "onDescriptionChange", function (event) {
      _this.setState({
        visualizationDescription: event.target.value
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onTitleDuplicate", function () {
      _this.setState({
        isLoading: false,
        isTitleDuplicateConfirmed: true,
        hasTitleDuplicate: true
      });

      if (_this.warning.current) {
        _this.warning.current.focus();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "saveSavedObject", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (!_this.state.isLoading) {
                _context.next = 2;
                break;
              }

              return _context.abrupt("return");

            case 2:
              _this.setState({
                isLoading: true
              });

              _context.next = 5;
              return _this.props.onSave({
                newTitle: _this.state.title,
                newCopyOnSave: _this.state.copyOnSave,
                isTitleDuplicateConfirmed: _this.state.isTitleDuplicateConfirmed,
                onTitleDuplicate: _this.onTitleDuplicate,
                newDescription: _this.state.visualizationDescription
              });

            case 5:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));

    _defineProperty(_assertThisInitialized(_this), "onTitleChange", function (event) {
      _this.setState({
        title: event.target.value,
        isTitleDuplicateConfirmed: false,
        hasTitleDuplicate: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onCopyOnSaveChange", function (event) {
      _this.setState({
        copyOnSave: event.target.checked
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onFormSubmit", function (event) {
      event.preventDefault();

      _this.saveSavedObject();
    });

    _defineProperty(_assertThisInitialized(_this), "renderConfirmButton", function () {
      var _this$state = _this.state,
          isLoading = _this$state.isLoading,
          title = _this$state.title;
      var confirmLabel = i18n.translate('savedObjects.saveModal.saveButtonLabel', {
        defaultMessage: 'Save'
      });

      if (_this.props.confirmButtonLabel) {
        confirmLabel = _this.props.confirmButtonLabel;
      }

      return /*#__PURE__*/React.createElement(EuiButton, {
        fill: true,
        "data-test-subj": "confirmSaveSavedObjectButton",
        isLoading: isLoading,
        isDisabled: title.length === 0,
        type: "submit"
      }, confirmLabel);
    });

    _defineProperty(_assertThisInitialized(_this), "renderDuplicateTitleCallout", function (duplicateWarningId) {
      if (!_this.state.hasTitleDuplicate) {
        return;
      }

      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", {
        ref: _this.warning,
        tabIndex: -1
      }, /*#__PURE__*/React.createElement(EuiCallOut, {
        title: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjects.saveModal.duplicateTitleLabel",
          defaultMessage: "A {objectType} with the title '{title}' already exists",
          values: {
            objectType: _this.props.objectType,
            title: _this.state.title
          }
        }),
        color: "warning",
        "data-test-subj": "titleDupicateWarnMsg",
        id: duplicateWarningId
      }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "savedObjects.saveModal.duplicateTitleDescription",
        defaultMessage: "Clicking {confirmSaveLabel} will save the {objectType} with this duplicate title.",
        values: {
          objectType: _this.props.objectType,
          confirmSaveLabel: /*#__PURE__*/React.createElement("strong", null, _this.props.confirmButtonLabel ? _this.props.confirmButtonLabel : i18n.translate('savedObjects.saveModal.saveButtonLabel', {
            defaultMessage: 'Save'
          }))
        }
      })))), /*#__PURE__*/React.createElement(EuiSpacer, null));
    });

    _defineProperty(_assertThisInitialized(_this), "renderCopyOnSave", function () {
      if (!_this.props.showCopyOnSave) {
        return;
      }

      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSwitch, {
        "data-test-subj": "saveAsNewCheckbox",
        checked: _this.state.copyOnSave,
        onChange: _this.onCopyOnSaveChange,
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjects.saveModal.saveAsNewLabel",
          defaultMessage: "Save as new {objectType}",
          values: {
            objectType: _this.props.objectType
          }
        })
      }), /*#__PURE__*/React.createElement(EuiSpacer, null));
    });

    return _this;
  }

  _createClass(SavedObjectSaveModal, [{
    key: "render",
    value: function render() {
      var _this$state2 = this.state,
          isTitleDuplicateConfirmed = _this$state2.isTitleDuplicateConfirmed,
          hasTitleDuplicate = _this$state2.hasTitleDuplicate,
          title = _this$state2.title;
      var duplicateWarningId = generateId();
      return /*#__PURE__*/React.createElement(EuiOverlayMask, null, /*#__PURE__*/React.createElement("form", {
        onSubmit: this.onFormSubmit
      }, /*#__PURE__*/React.createElement(EuiModal, {
        "data-test-subj": "savedObjectSaveModal",
        className: "kbnSavedObjectSaveModal",
        onClose: this.props.onClose
      }, /*#__PURE__*/React.createElement(EuiModalHeader, null, /*#__PURE__*/React.createElement(EuiModalHeaderTitle, null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "savedObjects.saveModal.saveTitle",
        defaultMessage: "Save {objectType}",
        values: {
          objectType: this.props.objectType
        }
      }))), /*#__PURE__*/React.createElement(EuiModalBody, null, this.renderDuplicateTitleCallout(duplicateWarningId), /*#__PURE__*/React.createElement(EuiForm, null, !this.props.showDescription && this.props.description && /*#__PURE__*/React.createElement(EuiFormRow, null, /*#__PURE__*/React.createElement(EuiText, {
        color: "subdued"
      }, this.props.description)), this.renderCopyOnSave(), /*#__PURE__*/React.createElement(EuiFormRow, {
        fullWidth: true,
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjects.saveModal.titleLabel",
          defaultMessage: "Title"
        })
      }, /*#__PURE__*/React.createElement(EuiFieldText, {
        fullWidth: true,
        autoFocus: true,
        "data-test-subj": "savedObjectTitle",
        value: title,
        onChange: this.onTitleChange,
        isInvalid: !isTitleDuplicateConfirmed && hasTitleDuplicate || title.length === 0,
        "aria-describedby": this.state.hasTitleDuplicate ? duplicateWarningId : undefined
      })), this.renderViewDescription(), typeof this.props.options === 'function' ? this.props.options(this.state) : this.props.options)), /*#__PURE__*/React.createElement(EuiModalFooter, null, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        "data-test-subj": "saveCancelButton",
        onClick: this.props.onClose
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "savedObjects.saveModal.cancelButtonLabel",
        defaultMessage: "Cancel"
      })), this.renderConfirmButton()))));
    }
  }]);

  return SavedObjectSaveModal;
}(React.Component);