function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, useMemo } from 'react';
import { EuiIcon, EuiLink, EuiPanel, EuiSpacer, EuiText, EuiTitle } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { NumberInputOption, SelectOption, SwitchOption } from '../../../charts/public';
import { WmsOptions } from '../../../maps_legacy/public';

var mapLayerForOption = function mapLayerForOption(_ref) {
  var layerId = _ref.layerId,
      name = _ref.name;
  return {
    text: name,
    value: layerId
  };
};

var mapFieldForOption = function mapFieldForOption(_ref2) {
  var description = _ref2.description,
      name = _ref2.name;
  return {
    text: description,
    value: name
  };
};

function RegionMapOptions(props) {
  var serviceSettings = props.serviceSettings,
      stateParams = props.stateParams,
      vis = props.vis,
      setValue = props.setValue;
  var vectorLayers = vis.type.editorConfig.collections.vectorLayers;
  var vectorLayerOptions = useMemo(function () {
    return vectorLayers.map(mapLayerForOption);
  }, [vectorLayers]);
  var fieldOptions = useMemo(function () {
    return (stateParams.selectedLayer && stateParams.selectedLayer.fields || []).map(mapFieldForOption);
  }, [stateParams.selectedLayer]);
  var setEmsHotLink = useCallback( /*#__PURE__*/function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(layer) {
      var emsHotLink;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return serviceSettings.getEMSHotLink(layer);

            case 2:
              emsHotLink = _context.sent;
              setValue('emsHotLink', emsHotLink);

            case 4:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function (_x) {
      return _ref3.apply(this, arguments);
    };
  }(), [setValue, serviceSettings]);
  var setLayer = useCallback( /*#__PURE__*/function () {
    var _ref4 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(paramName, value) {
      var newLayer;
      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              newLayer = vectorLayers.find(function (_ref5) {
                var layerId = _ref5.layerId;
                return layerId === value;
              });

              if (newLayer) {
                setValue(paramName, newLayer);
                setValue('selectedJoinField', newLayer.fields[0]);
                setEmsHotLink(newLayer);
              }

            case 2:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    }));

    return function (_x2, _x3) {
      return _ref4.apply(this, arguments);
    };
  }(), [vectorLayers, setEmsHotLink, setValue]);
  var setField = useCallback(function (paramName, value) {
    if (stateParams.selectedLayer) {
      setValue(paramName, stateParams.selectedLayer.fields.find(function (f) {
        return f.name === value;
      }));
    }
  }, [setValue, stateParams.selectedLayer]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "regionMap.visParams.layerSettingsTitle",
    defaultMessage: "Layer settings"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(SelectOption, {
    id: "regionMapOptionsSelectLayer",
    label: i18n.translate('regionMap.visParams.vectorMapLabel', {
      defaultMessage: 'Vector map'
    }),
    labelAppend: stateParams.emsHotLink && /*#__PURE__*/React.createElement(EuiText, {
      size: "xs"
    }, /*#__PURE__*/React.createElement(EuiLink, {
      href: stateParams.emsHotLink,
      target: "_blank",
      title: i18n.translate('regionMap.visParams.previewOnEMSLinkTitle', {
        defaultMessage: 'Preview {selectedLayerName} on the Elastic Maps Service',
        values: {
          selectedLayerName: stateParams.selectedLayer && stateParams.selectedLayer.name
        }
      })
    }, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "regionMap.visParams.previewOnEMSLinkText",
      defaultMessage: "Preview on EMS"
    }), ' ', /*#__PURE__*/React.createElement(EuiIcon, {
      type: "popout",
      size: "s"
    }))),
    options: vectorLayerOptions,
    paramName: "selectedLayer",
    value: stateParams.selectedLayer && stateParams.selectedLayer.layerId,
    setValue: setLayer
  }), /*#__PURE__*/React.createElement(SelectOption, {
    id: "regionMapOptionsSelectJoinField",
    label: i18n.translate('regionMap.visParams.joinFieldLabel', {
      defaultMessage: 'Join field'
    }),
    options: fieldOptions,
    paramName: "selectedJoinField",
    value: stateParams.selectedJoinField && stateParams.selectedJoinField.name,
    setValue: setField
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('regionMap.visParams.displayWarningsLabel', {
      defaultMessage: 'Display warnings'
    }),
    tooltip: i18n.translate('regionMap.visParams.switchWarningsTipText', {
      defaultMessage: 'Turns on/off warnings. When turned on, warning will be shown for each term that cannot be matched to a shape in the vector layer based on the join field. When turned off, these warnings will be turned off.'
    }),
    paramName: "isDisplayWarning",
    value: stateParams.isDisplayWarning,
    setValue: setValue
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('regionMap.visParams.showAllShapesLabel', {
      defaultMessage: 'Show all shapes'
    }),
    tooltip: i18n.translate('regionMap.visParams.turnOffShowingAllShapesTipText', {
      defaultMessage: 'Turning this off only shows the shapes that were matched with a corresponding term.'
    }),
    paramName: "showAllShapes",
    value: stateParams.showAllShapes,
    setValue: setValue
  })), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "regionMap.visParams.styleSettingsLabel",
    defaultMessage: "Style settings"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(SelectOption, {
    label: i18n.translate('regionMap.visParams.colorSchemaLabel', {
      defaultMessage: 'Color schema'
    }),
    options: vis.type.editorConfig.collections.colorSchemas,
    paramName: "colorSchema",
    value: stateParams.colorSchema,
    setValue: setValue
  }), /*#__PURE__*/React.createElement(NumberInputOption, {
    label: i18n.translate('regionMap.visParams.outlineWeightLabel', {
      defaultMessage: 'Border thickness'
    }),
    min: 0,
    paramName: "outlineWeight",
    value: stateParams.outlineWeight,
    setValue: setValue
  })), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(WmsOptions, props));
}

export { RegionMapOptions };