function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { share } from 'rxjs/operators';
import { FilterManager } from './filter_manager';
import { createAddToQueryLog } from './lib';
import { TimefilterService } from './timefilter';
import { createSavedQueryService } from './saved_query/saved_query_service';
import { createQueryStateObservable } from './state_sync/create_global_query_observable';
/**
 * Query Service
 * @internal
 */

export var QueryService = /*#__PURE__*/function () {
  function QueryService() {
    _classCallCheck(this, QueryService);

    _defineProperty(this, "filterManager", void 0);

    _defineProperty(this, "timefilter", void 0);

    _defineProperty(this, "state$", void 0);
  }

  _createClass(QueryService, [{
    key: "setup",
    value: function setup(_ref) {
      var storage = _ref.storage,
          uiSettings = _ref.uiSettings;
      this.filterManager = new FilterManager(uiSettings);
      var timefilterService = new TimefilterService();
      this.timefilter = timefilterService.setup({
        uiSettings: uiSettings,
        storage: storage
      });
      this.state$ = createQueryStateObservable({
        filterManager: this.filterManager,
        timefilter: this.timefilter
      }).pipe(share());
      return {
        filterManager: this.filterManager,
        timefilter: this.timefilter,
        state$: this.state$
      };
    }
  }, {
    key: "start",
    value: function start(_ref2) {
      var savedObjectsClient = _ref2.savedObjectsClient,
          storage = _ref2.storage,
          uiSettings = _ref2.uiSettings;
      return {
        addToQueryLog: createAddToQueryLog({
          storage: storage,
          uiSettings: uiSettings
        }),
        filterManager: this.filterManager,
        savedQueries: createSavedQueryService(savedObjectsClient),
        state$: this.state$,
        timefilter: this.timefilter
      };
    }
  }, {
    key: "stop",
    value: function stop() {// nothing to do here yet
    }
  }]);

  return QueryService;
}();
/** @public */