function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { Subject } from 'rxjs';
import { UiSettingsApi } from './ui_settings_api';
import { UiSettingsClient } from './ui_settings_client';

/** @internal */
export var UiSettingsService = /*#__PURE__*/function () {
  function UiSettingsService() {
    _classCallCheck(this, UiSettingsService);

    _defineProperty(this, "uiSettingsApi", void 0);

    _defineProperty(this, "uiSettingsClient", void 0);

    _defineProperty(this, "done$", new Subject());
  }

  _createClass(UiSettingsService, [{
    key: "setup",
    value: function setup(_ref) {
      var http = _ref.http,
          injectedMetadata = _ref.injectedMetadata;
      this.uiSettingsApi = new UiSettingsApi(http);
      http.addLoadingCountSource(this.uiSettingsApi.getLoadingCount$()); // TODO: Migrate away from legacyMetadata https://github.com/elastic/kibana/issues/22779

      var legacyMetadata = injectedMetadata.getLegacyMetadata();
      this.uiSettingsClient = new UiSettingsClient({
        api: this.uiSettingsApi,
        defaults: legacyMetadata.uiSettings.defaults,
        initialSettings: legacyMetadata.uiSettings.user,
        done$: this.done$
      });
      return this.uiSettingsClient;
    }
  }, {
    key: "start",
    value: function start() {
      return this.uiSettingsClient;
    }
  }, {
    key: "stop",
    value: function stop() {
      this.done$.complete();

      if (this.uiSettingsApi) {
        this.uiSettingsApi.stop();
      }
    }
  }]);

  return UiSettingsService;
}();