/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Unknown variant for internal use only for when plugins are not known.
 * @internal
 */

/**
 * Custom window type for loading bundles. Do not extend global Window to avoid leaking these types.
 * @internal
 */

/**
 * Reads the plugin's bundle declared in the global context.
 */
export function read(name) {
  var coreWindow = window;
  var exportId = "plugin/".concat(name, "/public");

  if (!coreWindow.__kbnBundles__.has(exportId)) {
    throw new Error("Definition of plugin \"".concat(name, "\" not found and may have failed to load."));
  }

  var pluginExport = coreWindow.__kbnBundles__.get(exportId);

  if (typeof (pluginExport === null || pluginExport === void 0 ? void 0 : pluginExport.plugin) !== 'function') {
    throw new Error("Definition of plugin \"".concat(name, "\" should be a function."));
  } else {
    return pluginExport.plugin;
  }
}