"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkCompatibleTypesTask = checkCompatibleTypesTask;

var _check_collector_integrity = require("../check_collector_integrity");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function checkCompatibleTypesTask({
  reporter,
  roots
}) {
  return roots.map(root => ({
    task: async () => {
      if (root.parsedCollections) {
        const differences = (0, _check_collector_integrity.checkCompatibleTypeDescriptor)(root.parsedCollections);
        const reporterWithContext = reporter.withContext({
          name: root.config.root
        });

        if (differences.length) {
          reporterWithContext.report(`${JSON.stringify(differences, null, 2)}. \nPlease fix the collectors and run the check again.`);
          throw reporter;
        }
      }
    },
    title: `Checking in ${root.config.root}`
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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