/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.regions.loops;

import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.regions.AbstractRegion;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.dex.regions.loops.LoopType;
import jadx.core.utils.BlockUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class LoopRegion
extends AbstractRegion {
    private final LoopInfo info;
    @Nullable
    private IfCondition condition;
    private final BlockNode conditionBlock;
    private BlockNode preCondition;
    private IRegion body;
    private final boolean conditionAtEnd;
    private LoopType type;

    public LoopRegion(IRegion parent, LoopInfo info, @Nullable BlockNode header, boolean reversed) {
        super(parent);
        this.info = info;
        this.conditionBlock = header;
        this.condition = IfCondition.fromIfBlock(header);
        this.conditionAtEnd = reversed;
    }

    public LoopInfo getInfo() {
        return this.info;
    }

    public IfCondition getCondition() {
        return this.condition;
    }

    public void setCondition(IfCondition condition) {
        this.condition = condition;
    }

    public BlockNode getHeader() {
        return this.conditionBlock;
    }

    public IRegion getBody() {
        return this.body;
    }

    public void setBody(IRegion body) {
        this.body = body;
    }

    public boolean isConditionAtEnd() {
        return this.conditionAtEnd;
    }

    public void setPreCondition(BlockNode preCondition) {
        this.preCondition = preCondition;
    }

    private IfNode getIfInsn() {
        return (IfNode)BlockUtils.getLastInsn(this.conditionBlock);
    }

    public boolean checkPreCondition() {
        List<InsnNode> insns = this.preCondition.getInstructions();
        if (insns.isEmpty()) {
            return true;
        }
        IfNode ifInsn = this.getIfInsn();
        int size = insns.size();
        for (int i = 0; i < size; ++i) {
            InsnNode insn = insns.get(i);
            if (insn.getResult() == null) {
                return false;
            }
            RegisterArg res = insn.getResult();
            if (res.getSVar().getUseCount() > 1) {
                return false;
            }
            boolean found = false;
            for (int j = i + 1; j < size; ++j) {
                if (!insns.get(i).containsVar(res)) continue;
                found = true;
            }
            if (!found && ifInsn.containsVar(res)) {
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void mergePreCondition() {
        if (this.preCondition != null && this.conditionBlock != null) {
            List<InsnNode> condInsns = this.conditionBlock.getInstructions();
            List<InsnNode> preCondInsns = this.preCondition.getInstructions();
            preCondInsns.addAll(condInsns);
            condInsns.clear();
            condInsns.addAll(preCondInsns);
            preCondInsns.clear();
            this.preCondition = null;
        }
    }

    public int getConditionSourceLine() {
        InsnNode lastInsn = BlockUtils.getLastInsn(this.conditionBlock);
        return lastInsn == null ? 0 : lastInsn.getSourceLine();
    }

    public LoopType getType() {
        return this.type;
    }

    public void setType(LoopType type) {
        this.type = type;
    }

    @Override
    public List<IContainer> getSubBlocks() {
        ArrayList<IContainer> all = new ArrayList<IContainer>(3);
        if (this.preCondition != null) {
            all.add(this.preCondition);
        }
        if (this.conditionBlock != null) {
            all.add(this.conditionBlock);
        }
        if (this.body != null) {
            all.add(this.body);
        }
        return Collections.unmodifiableList(all);
    }

    @Override
    public boolean replaceSubBlock(IContainer oldBlock, IContainer newBlock) {
        return false;
    }

    @Override
    public String baseString() {
        return this.body == null ? "-" : this.body.baseString();
    }

    public String toString() {
        return "LOOP:" + this.info.getId() + ": " + this.baseString();
    }
}

