/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.SupertypeSupplier;
import org.jetbrains.kotlin.fir.resolve.transformers.FirImmutableCompositeScope;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypesResolutionKt;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationStatus;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aJ\u001c\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aJ\u0012\u0010\u001d\u001a\u00020\r2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\fJ\u0012\u0010\u001f\u001a\u00020\u00142\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\fJ \u0010 \u001a\u00020\u00142\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\r0\u000bj\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;", "", "()V", "fileScopesMap", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirImmutableCompositeScope;", "Lkotlin/collections/HashMap;", "scopesForNestedClassesMap", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "supertypeStatusMap", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationStatus;", "Lkotlin/collections/LinkedHashMap;", "supertypesSupplier", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "getSupertypesSupplier", "()Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "breakLoops", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getOrPutFileScope", "file", "scope", "Lkotlin/Function0;", "getOrPutScopeForNestedClasses", "regularClass", "getSupertypesComputationStatus", "classLikeDeclaration", "startComputingSupertypes", "storeSupertypes", "resolvedTypesRefs", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "resolve"})
final class SupertypeComputationSession {
    private final HashMap<FirFile, FirImmutableCompositeScope> fileScopesMap;
    private final HashMap<FirRegularClass, FirImmutableCompositeScope> scopesForNestedClassesMap;
    private final LinkedHashMap<FirClassLikeDeclaration<?>, SupertypeComputationStatus> supertypeStatusMap;
    @NotNull
    private final SupertypeSupplier supertypesSupplier;

    @NotNull
    public final SupertypeSupplier getSupertypesSupplier() {
        return this.supertypesSupplier;
    }

    @NotNull
    public final SupertypeComputationStatus getSupertypesComputationStatus(@NotNull FirClassLikeDeclaration<?> classLikeDeclaration) {
        Intrinsics.checkParameterIsNotNull(classLikeDeclaration, (String)"classLikeDeclaration");
        SupertypeComputationStatus supertypeComputationStatus = this.supertypeStatusMap.get(classLikeDeclaration);
        if (supertypeComputationStatus == null) {
            supertypeComputationStatus = SupertypeComputationStatus.NotComputed.INSTANCE;
        }
        return supertypeComputationStatus;
    }

    @NotNull
    public final FirImmutableCompositeScope getOrPutFileScope(@NotNull FirFile file2, @NotNull Function0<FirImmutableCompositeScope> scope2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull(scope2, (String)"scope");
        Map $this$getOrPut$iv = this.fileScopesMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(file2);
        if (value$iv == null) {
            boolean bl = false;
            FirImmutableCompositeScope answer$iv = (FirImmutableCompositeScope)scope2.invoke();
            $this$getOrPut$iv.put(file2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (FirImmutableCompositeScope)object;
    }

    @NotNull
    public final FirImmutableCompositeScope getOrPutScopeForNestedClasses(@NotNull FirRegularClass regularClass, @NotNull Function0<FirImmutableCompositeScope> scope2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)regularClass, (String)"regularClass");
        Intrinsics.checkParameterIsNotNull(scope2, (String)"scope");
        Map $this$getOrPut$iv = this.scopesForNestedClassesMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(regularClass);
        if (value$iv == null) {
            boolean bl = false;
            FirImmutableCompositeScope answer$iv = (FirImmutableCompositeScope)scope2.invoke();
            $this$getOrPut$iv.put(regularClass, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (FirImmutableCompositeScope)object;
    }

    public final void startComputingSupertypes(@NotNull FirClassLikeDeclaration<?> classLikeDeclaration) {
        Intrinsics.checkParameterIsNotNull(classLikeDeclaration, (String)"classLikeDeclaration");
        boolean bl = this.supertypeStatusMap.get(classLikeDeclaration) == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Unexpected in startComputingSupertypes supertype status for " + classLikeDeclaration + ": " + this.supertypeStatusMap.get(classLikeDeclaration);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        ((Map)this.supertypeStatusMap).put(classLikeDeclaration, SupertypeComputationStatus.Computing.INSTANCE);
    }

    public final void storeSupertypes(@NotNull FirClassLikeDeclaration<?> classLikeDeclaration, @NotNull List<? extends FirTypeRef> resolvedTypesRefs) {
        Intrinsics.checkParameterIsNotNull(classLikeDeclaration, (String)"classLikeDeclaration");
        Intrinsics.checkParameterIsNotNull(resolvedTypesRefs, (String)"resolvedTypesRefs");
        boolean bl = this.supertypeStatusMap.get(classLikeDeclaration) instanceof SupertypeComputationStatus.Computing;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Unexpected in storeSupertypes supertype status for " + classLikeDeclaration + ": " + this.supertypeStatusMap.get(classLikeDeclaration);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        ((Map)this.supertypeStatusMap).put(classLikeDeclaration, new SupertypeComputationStatus.Computed(resolvedTypesRefs));
    }

    public final void breakLoops(@NotNull FirSession session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        boolean bl = false;
        HashSet visited2 = new HashSet();
        boolean bl2 = false;
        HashSet inProcess = new HashSet();
        Function1 $fun$dfs$1 = new Function1<FirClassLikeDeclaration<?>, Unit>(this, visited2, inProcess, session){
            final /* synthetic */ SupertypeComputationSession this$0;
            final /* synthetic */ HashSet $visited;
            final /* synthetic */ HashSet $inProcess;
            final /* synthetic */ FirSession $session;

            public final void invoke(@NotNull FirClassLikeDeclaration<?> classLikeDeclaration) {
                Intrinsics.checkParameterIsNotNull(classLikeDeclaration, (String)"classLikeDeclaration");
                SupertypeComputationStatus supertypeComputationStatus = (SupertypeComputationStatus)SupertypeComputationSession.access$getSupertypeStatusMap$p(this.this$0).get(classLikeDeclaration);
                if (supertypeComputationStatus == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)supertypeComputationStatus, (String)"supertypeStatusMap[classLikeDeclaration] ?: return");
                SupertypeComputationStatus supertypeComputationStatus2 = supertypeComputationStatus;
                if (this.$visited.contains(classLikeDeclaration)) {
                    return;
                }
                if (this.$inProcess.contains(classLikeDeclaration)) {
                    return;
                }
                this.$inProcess.add(classLikeDeclaration);
                boolean bl = supertypeComputationStatus2 instanceof SupertypeComputationStatus.Computed;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string2 = "Expected computed supertypes in breakLoops for " + classLikeDeclaration.getSymbol().getClassId();
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                List<FirTypeRef> typeRefs = ((SupertypeComputationStatus.Computed)supertypeComputationStatus2).getSupertypeRefs();
                bl3 = false;
                List resultingTypeRefs = new ArrayList<E>();
                boolean wereChanges = false;
                for (FirTypeRef typeRef : typeRefs) {
                    FirTypeRef firTypeRef;
                    FirClassLikeDeclaration<?> fir = FirSupertypesResolutionKt.firClassLike(typeRef, this.$session);
                    if (fir != null) {
                        FirClassLikeDeclaration<?> firClassLikeDeclaration;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        FirClassLikeDeclaration<?> p1 = firClassLikeDeclaration;
                        boolean bl7 = false;
                        this.invoke(p1);
                    }
                    if (CollectionsKt.contains((Iterable)this.$inProcess, fir)) {
                        Object object;
                        wereChanges = true;
                        firTypeRef = FirSupertypesResolutionKt.access$createErrorTypeRef(typeRef, "Loop in supertype: " + classLikeDeclaration.getSymbol().getClassId() + " -> " + ((object = fir) != null && (object = object.getSymbol()) != null ? ((FirClassLikeSymbol)object).getClassId() : null));
                    } else {
                        firTypeRef = typeRef;
                    }
                    resultingTypeRefs.add(firTypeRef);
                }
                if (wereChanges) {
                    ((Map)SupertypeComputationSession.access$getSupertypeStatusMap$p(this.this$0)).put(classLikeDeclaration, new SupertypeComputationStatus.Computed(resultingTypeRefs));
                }
                this.$inProcess.remove(classLikeDeclaration);
                this.$visited.add(classLikeDeclaration);
            }
            {
                this.this$0 = supertypeComputationSession;
                this.$visited = hashSet;
                this.$inProcess = hashSet2;
                this.$session = firSession;
                super(1);
            }
        };
        Iterator<FirClassLikeDeclaration<?>> iterator2 = this.supertypeStatusMap.keySet().iterator();
        while (iterator2.hasNext()) {
            FirClassLikeDeclaration<?> classifier2;
            FirClassLikeDeclaration<?> firClassLikeDeclaration = classifier2 = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(firClassLikeDeclaration, (String)"classifier");
            $fun$dfs$1.invoke(firClassLikeDeclaration);
        }
    }

    public SupertypeComputationSession() {
        SupertypeComputationSession supertypeComputationSession = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        supertypeComputationSession.fileScopesMap = hashMap;
        supertypeComputationSession = this;
        bl = false;
        hashMap = new HashMap();
        supertypeComputationSession.scopesForNestedClassesMap = hashMap;
        supertypeComputationSession = this;
        bl = false;
        hashMap = new LinkedHashMap();
        supertypeComputationSession.supertypeStatusMap = hashMap;
        this.supertypesSupplier = new SupertypeSupplier(this){
            final /* synthetic */ SupertypeComputationSession this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<ConeClassLikeType> forClass(@NotNull FirClass<?> firClass) {
                List list2;
                Object object;
                Intrinsics.checkParameterIsNotNull(firClass, (String)"firClass");
                if (firClass.getResolvePhase().compareTo((Enum)FirResolvePhase.SUPER_TYPES) > 0) {
                    return FirDeclarationUtilKt.getSuperConeTypes(firClass);
                }
                SupertypeComputationStatus supertypeComputationStatus = this.this$0.getSupertypesComputationStatus((FirClassLikeDeclaration)firClass);
                if (!(supertypeComputationStatus instanceof SupertypeComputationStatus.Computed)) {
                    supertypeComputationStatus = null;
                }
                if ((object = (SupertypeComputationStatus.Computed)supertypeComputationStatus) != null && (object = ((SupertypeComputationStatus.Computed)object).getSupertypeRefs()) != null) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = (Iterable)object;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        ConeClassLikeType coneClassLikeType;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        FirTypeRef it = (FirTypeRef)element$iv$iv;
                        boolean bl2 = false;
                        FirTypeRef $this$coneTypeSafe$iv = it;
                        boolean $i$f$coneTypeSafe = false;
                        FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
                        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                            firTypeRef = null;
                        }
                        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
                        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                        if (!(coneKotlinType instanceof ConeClassLikeType)) {
                            coneKotlinType = null;
                        }
                        if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        ConeClassLikeType it$iv$iv = coneClassLikeType;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    list2 = null;
                }
                List list3 = list2;
                boolean bl = false;
                List list4 = list3;
                if (list4 == null) {
                    list4 = CollectionsKt.emptyList();
                }
                return list4;
            }

            @Nullable
            public ConeClassLikeType expansionForTypeAlias(@NotNull FirTypeAlias typeAlias) {
                ConeClassLikeType coneClassLikeType;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)typeAlias, (String)"typeAlias");
                if (typeAlias.getResolvePhase().compareTo((Enum)FirResolvePhase.SUPER_TYPES) > 0) {
                    return FirDeclarationUtilKt.getExpandedConeType(typeAlias);
                }
                SupertypeComputationStatus supertypeComputationStatus = this.this$0.getSupertypesComputationStatus(typeAlias);
                if (!(supertypeComputationStatus instanceof SupertypeComputationStatus.Computed)) {
                    supertypeComputationStatus = null;
                }
                if ((object = (SupertypeComputationStatus.Computed)supertypeComputationStatus) != null && (object = ((SupertypeComputationStatus.Computed)object).getSupertypeRefs()) != null && (object = (FirTypeRef)CollectionsKt.getOrNull((List)object, (int)0)) != null) {
                    Object $this$coneTypeSafe$iv = object;
                    boolean $i$f$coneTypeSafe = false;
                    Object object2 = $this$coneTypeSafe$iv;
                    if (!(object2 instanceof FirResolvedTypeRef)) {
                        object2 = null;
                    }
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)object2;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeClassLikeType)) {
                        coneKotlinType = null;
                    }
                    coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
                } else {
                    coneClassLikeType = null;
                }
                return coneClassLikeType;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ LinkedHashMap access$getSupertypeStatusMap$p(SupertypeComputationSession $this) {
        return $this.supertypeStatusMap;
    }
}

