/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.assistedinject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.assistedinject.Parameter;
import org.elasticsearch.common.inject.assistedinject.ParameterListKey;

class AssistedConstructor<T> {
    private final Constructor<T> constructor;
    private final ParameterListKey assistedParameters;
    private final List<Parameter> allParameters;

    AssistedConstructor(Constructor<T> constructor, List<TypeLiteral<?>> parameterTypes) {
        this.constructor = constructor;
        Annotation[][] annotations = constructor.getParameterAnnotations();
        ArrayList<Type> typeList = new ArrayList<Type>();
        this.allParameters = new ArrayList<Parameter>(parameterTypes.size());
        for (int i = 0; i < parameterTypes.size(); ++i) {
            Parameter parameter = new Parameter(parameterTypes.get(i).getType(), annotations[i]);
            this.allParameters.add(parameter);
            if (!parameter.isProvidedByFactory()) continue;
            typeList.add(parameter.getType());
        }
        this.assistedParameters = new ParameterListKey(typeList);
    }

    public ParameterListKey getAssistedParameters() {
        return this.assistedParameters;
    }

    public List<Parameter> getAllParameters() {
        return this.allParameters;
    }

    public Set<Class<?>> getDeclaredExceptions() {
        return new HashSet(Arrays.asList(this.constructor.getExceptionTypes()));
    }

    public T newInstance(Object[] args) throws Throwable {
        try {
            return this.constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public String toString() {
        return this.constructor.toString();
    }
}

