/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.ldap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationServiceException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.ldap.LdapAuthoritiesPopulator;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.ldap.LdapAuthenticator;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.ldap.LdapUserDetailsMapper;
import org.springframework.security.userdetails.ldap.UserDetailsContextMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LdapAuthenticationProvider
implements AuthenticationProvider {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$providers$ldap$LdapAuthenticationProvider == null ? (class$org$springframework$security$providers$ldap$LdapAuthenticationProvider = LdapAuthenticationProvider.class$("org.springframework.security.providers.ldap.LdapAuthenticationProvider")) : class$org$springframework$security$providers$ldap$LdapAuthenticationProvider));
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private LdapAuthenticator authenticator;
    private LdapAuthoritiesPopulator authoritiesPopulator;
    private UserDetailsContextMapper userDetailsContextMapper = new LdapUserDetailsMapper();
    private boolean useAuthenticationRequestCredentials = true;
    static /* synthetic */ Class class$org$springframework$security$providers$ldap$LdapAuthenticationProvider;
    static /* synthetic */ Class class$org$springframework$security$providers$UsernamePasswordAuthenticationToken;

    public LdapAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator) {
        this.setAuthenticator(authenticator);
        this.setAuthoritiesPopulator(authoritiesPopulator);
    }

    public LdapAuthenticationProvider(LdapAuthenticator authenticator) {
        this.setAuthenticator(authenticator);
        this.setAuthoritiesPopulator(new NullAuthoritiesPopulator());
    }

    private void setAuthenticator(LdapAuthenticator authenticator) {
        Assert.notNull((Object)authenticator, (String)"An LdapAuthenticator must be supplied");
        this.authenticator = authenticator;
    }

    private LdapAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    private void setAuthoritiesPopulator(LdapAuthoritiesPopulator authoritiesPopulator) {
        Assert.notNull((Object)authoritiesPopulator, (String)"An LdapAuthoritiesPopulator must be supplied");
        this.authoritiesPopulator = authoritiesPopulator;
    }

    protected LdapAuthoritiesPopulator getAuthoritiesPopulator() {
        return this.authoritiesPopulator;
    }

    public void setUserDetailsContextMapper(UserDetailsContextMapper userDetailsContextMapper) {
        Assert.notNull((Object)userDetailsContextMapper, (String)"UserDetailsContextMapper must not be null");
        this.userDetailsContextMapper = userDetailsContextMapper;
    }

    protected UserDetailsContextMapper getUserDetailsContextMapper() {
        return this.userDetailsContextMapper;
    }

    public void setUseAuthenticationRequestCredentials(boolean useAuthenticationRequestCredentials) {
        this.useAuthenticationRequestCredentials = useAuthenticationRequestCredentials;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Assert.isInstanceOf((Class)(class$org$springframework$security$providers$UsernamePasswordAuthenticationToken == null ? (class$org$springframework$security$providers$UsernamePasswordAuthenticationToken = LdapAuthenticationProvider.class$("org.springframework.security.providers.UsernamePasswordAuthenticationToken")) : class$org$springframework$security$providers$UsernamePasswordAuthenticationToken), (Object)authentication, (String)this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.onlySupports", "Only UsernamePasswordAuthenticationToken is supported"));
        UsernamePasswordAuthenticationToken userToken = (UsernamePasswordAuthenticationToken)authentication;
        String username = userToken.getName();
        if (!StringUtils.hasLength((String)username)) {
            throw new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.emptyUsername", "Empty Username"));
        }
        String password = (String)authentication.getCredentials();
        Assert.notNull((Object)password, (String)"Null password was supplied in authentication token");
        if (password.length() == 0) {
            logger.debug((Object)("Rejecting empty password for user " + username));
            throw new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.emptyPassword", "Empty Password"));
        }
        try {
            DirContextOperations userData = this.getAuthenticator().authenticate(authentication);
            GrantedAuthority[] extraAuthorities = this.loadUserAuthorities(userData, username, password);
            UserDetails user = this.userDetailsContextMapper.mapUserFromContext(userData, username, extraAuthorities);
            return this.createSuccessfulAuthentication(userToken, user);
        }
        catch (NamingException ldapAccessFailure) {
            throw new AuthenticationServiceException(ldapAccessFailure.getMessage(), ldapAccessFailure);
        }
    }

    protected GrantedAuthority[] loadUserAuthorities(DirContextOperations userData, String username, String password) {
        return this.getAuthoritiesPopulator().getGrantedAuthorities(userData, username);
    }

    protected Authentication createSuccessfulAuthentication(UsernamePasswordAuthenticationToken authentication, UserDetails user) {
        Object password = this.useAuthenticationRequestCredentials ? authentication.getCredentials() : user.getPassword();
        return new UsernamePasswordAuthenticationToken(user, password, user.getAuthorities());
    }

    public boolean supports(Class authentication) {
        return (class$org$springframework$security$providers$UsernamePasswordAuthenticationToken == null ? (class$org$springframework$security$providers$UsernamePasswordAuthenticationToken = LdapAuthenticationProvider.class$("org.springframework.security.providers.UsernamePasswordAuthenticationToken")) : class$org$springframework$security$providers$UsernamePasswordAuthenticationToken).isAssignableFrom(authentication);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class NullAuthoritiesPopulator
    implements LdapAuthoritiesPopulator {
        private NullAuthoritiesPopulator() {
        }

        public GrantedAuthority[] getGrantedAuthorities(DirContextOperations userDetails, String username) {
            return new GrantedAuthority[0];
        }
    }
}

