/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.ComplexVector;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class BasicVector_CharBuffer
extends AbstractVector {
    private int capacity;
    private CharBuffer elements;
    private boolean directAllocation;

    public BasicVector_CharBuffer(int capacity) {
        this(capacity, false);
    }

    public BasicVector_CharBuffer(int capacity, boolean directAllocation) {
        this.directAllocation = directAllocation;
        if (directAllocation) {
            ByteBuffer b = ByteBuffer.allocateDirect(capacity * 2);
            this.elements = b.asCharBuffer();
        } else {
            this.elements = CharBuffer.allocate(capacity);
        }
        this.capacity = capacity;
    }

    public BasicVector_CharBuffer(LispObject[] array, boolean directAllocation) {
        this.capacity = array.length;
        this.directAllocation = directAllocation;
        if (directAllocation) {
            ByteBuffer b = ByteBuffer.allocateDirect(this.capacity * 2);
            this.elements = b.asCharBuffer();
        } else {
            this.elements = CharBuffer.allocate(this.capacity);
        }
        int i = array.length;
        while (i-- > 0) {
            this.elements.put(i, (char)Fixnum.getValue(array[i]));
        }
    }

    public BasicVector_CharBuffer(ByteBuffer buffer, boolean directAllocation) {
        this.elements = buffer.asCharBuffer();
        this.directAllocation = directAllocation;
        this.capacity = buffer.limit();
    }

    public BasicVector_CharBuffer(CharBuffer buffer, boolean directAllocation) {
        this.elements = buffer;
        this.directAllocation = directAllocation;
        this.capacity = buffer.limit();
    }

    @Override
    public LispObject typeOf() {
        return Lisp.list(Symbol.SIMPLE_ARRAY, Lisp.UNSIGNED_BYTE_16, new Cons(Fixnum.getInstance(this.capacity)));
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.VECTOR;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public LispObject getElementType() {
        return Lisp.UNSIGNED_BYTE_16;
    }

    @Override
    public boolean isSimpleVector() {
        return false;
    }

    @Override
    public boolean hasFillPointer() {
        return false;
    }

    @Override
    public boolean isAdjustable() {
        return false;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int length() {
        return this.capacity;
    }

    @Override
    public LispObject elt(int index) {
        try {
            return Fixnum.getInstance(this.elements.get(index));
        }
        catch (IndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
            return Lisp.NIL;
        }
    }

    @Override
    public int aref(int index) {
        try {
            return this.elements.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.elements.limit());
            return 0;
        }
    }

    @Override
    public LispObject AREF(int index) {
        try {
            return Fixnum.getInstance(this.elements.get(index));
        }
        catch (IndexOutOfBoundsException e) {
            this.badIndex(index, this.elements.limit());
            return Lisp.NIL;
        }
    }

    @Override
    public void aset(int index, int n) {
        try {
            this.elements.put(index, (char)n);
        }
        catch (IndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
        }
    }

    @Override
    public void aset(int index, LispObject obj) {
        if (obj instanceof Fixnum) {
            try {
                this.elements.put(index, (char)((Fixnum)obj).value);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.badIndex(index, this.capacity);
            }
        } else {
            Lisp.type_error(obj, Lisp.UNSIGNED_BYTE_16);
        }
    }

    @Override
    public LispObject subseq(int start, int end) {
        BasicVector_CharBuffer v = new BasicVector_CharBuffer(end - start);
        int i = start;
        int j = 0;
        try {
            while (i < end) {
                v.elements.put(j++, this.elements.get(i++));
            }
            return v;
        }
        catch (IndexOutOfBoundsException e) {
            return Lisp.error(new TypeError("Array index out of bounds: " + i + "."));
        }
    }

    @Override
    public void fill(LispObject obj) {
        if (!(obj instanceof Fixnum)) {
            Lisp.type_error(obj, Symbol.FIXNUM);
            return;
        }
        int n = ((Fixnum)obj).value;
        if (n < 0 || n > 65535) {
            Lisp.type_error(obj, Lisp.UNSIGNED_BYTE_16);
            return;
        }
        char m = (char)n;
        int i = this.capacity;
        while (i-- > 0) {
            this.elements.put(i, m);
        }
    }

    @Override
    public void shrink(int n) {
        if (n < this.length()) {
            this.elements.limit(n);
            this.capacity = n;
            return;
        }
        if (n == this.capacity) {
            return;
        }
        Lisp.error(new LispError("End of native shrink routine:  shouldn't be reachable."));
    }

    @Override
    public LispObject reverse() {
        BasicVector_CharBuffer result = new BasicVector_CharBuffer(this.capacity);
        int i = 0;
        int j = this.capacity - 1;
        while (i < this.capacity) {
            result.elements.put(i, this.elements.get(j));
            ++i;
            --j;
        }
        return result;
    }

    @Override
    public LispObject nreverse() {
        int i = 0;
        for (int j = this.capacity - 1; i < j; ++i, --j) {
            char temp = this.elements.get(i);
            this.elements.put(i, this.elements.get(j));
            this.elements.put(j, temp);
        }
        return this;
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, LispObject initialElement, LispObject initialContents) {
        if (initialContents != null) {
            LispObject[] newElements = new LispObject[newCapacity];
            if (initialContents.listp()) {
                LispObject list = initialContents;
                for (int i = 0; i < newCapacity; ++i) {
                    newElements[i] = list.car();
                    list = list.cdr();
                }
            } else if (initialContents.vectorp()) {
                for (int i = 0; i < newCapacity; ++i) {
                    newElements[i] = initialContents.elt(i);
                }
            } else {
                Lisp.type_error(initialContents, Symbol.SEQUENCE);
            }
            return new BasicVector_CharBuffer(newElements, this.directAllocation);
        }
        if (this.capacity != newCapacity) {
            LispObject[] newElements = new LispObject[newCapacity];
            System.arraycopy(this.elements.array(), 0, newElements, 0, Math.min(this.capacity, newCapacity));
            if (initialElement != null) {
                for (int i = this.capacity; i < newCapacity; ++i) {
                    newElements[i] = initialElement;
                }
            }
            return new BasicVector_CharBuffer(newElements, this.directAllocation);
        }
        return this;
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, AbstractArray displacedTo, int displacement) {
        return new ComplexVector(newCapacity, displacedTo, displacement);
    }
}

