/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.exceptions.ParserException;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ServerNamePairParser;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerNameIndicationExtensionParser
extends ExtensionParser<ServerNameIndicationExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private List<ServerNamePair> pairList;

    public ServerNameIndicationExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(ServerNameIndicationExtensionMessage msg) {
        if ((Integer)msg.getExtensionLength().getValue() > 0) {
            this.parseServerNameListLength(msg);
            this.parseServerNameListBytes(msg);
            int position = 0;
            this.pairList = new LinkedList<ServerNamePair>();
            while (position < (Integer)msg.getServerNameListLength().getValue()) {
                ServerNamePairParser parser = new ServerNamePairParser(position, (byte[])msg.getServerNameListBytes().getValue());
                this.pairList.add(parser.parse());
                if (position == parser.getPointer()) {
                    throw new ParserException("Ran into infinite Loop while parsing ServerNamePair");
                }
                position = parser.getPointer();
            }
            this.parseServerNameList(msg);
        } else {
            LOGGER.debug("Received empty SNI Extension");
        }
    }

    @Override
    protected ServerNameIndicationExtensionMessage createExtensionMessage() {
        return new ServerNameIndicationExtensionMessage();
    }

    private void parseServerNameListLength(ServerNameIndicationExtensionMessage msg) {
        msg.setServerNameListLength(this.parseIntField(2));
        LOGGER.debug("ServerNameListLength: " + msg.getServerNameListLength().getValue());
    }

    private void parseServerNameListBytes(ServerNameIndicationExtensionMessage msg) {
        msg.setServerNameListBytes(this.parseByteArrayField((Integer)msg.getServerNameListLength().getValue()));
        LOGGER.debug("ServerNameListBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getServerNameListBytes().getValue())));
    }

    private void parseServerNameList(ServerNameIndicationExtensionMessage msg) {
        msg.setServerNameList(this.pairList);
    }
}

