/*
 * Decompiled with CFR 0.152.
 */
package tr.util;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import tr.util.Observable;
import tr.util.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObservableImpl
implements Observable,
Serializable {
    private static final long serialVersionUID = 2383745834L;
    private transient List<WeakReference<Observer>> observers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WeakReference<Observer>> getObservers() {
        ObservableImpl observableImpl = this;
        synchronized (observableImpl) {
            if (this.observers == null) {
                this.observers = new Vector<WeakReference<Observer>>();
            }
        }
        return this.observers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(Observer observer) {
        if (observer == null) {
            return;
        }
        ObservableImpl observableImpl = this;
        synchronized (observableImpl) {
            Iterator<WeakReference<Observer>> i = this.getObservers().iterator();
            while (i.hasNext()) {
                Observer entry = (Observer)i.next().get();
                if (entry == null) {
                    i.remove();
                    continue;
                }
                if (entry != observer) continue;
                return;
            }
            this.getObservers().add(new WeakReference<Observer>(observer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObserver(Observer observer) {
        if (observer == null) {
            return;
        }
        ObservableImpl observableImpl = this;
        synchronized (observableImpl) {
            Iterator<WeakReference<Observer>> i = this.getObservers().iterator();
            while (i.hasNext()) {
                Observer entry = (Observer)i.next().get();
                if (entry != null && entry != observer) continue;
                i.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObservers() {
        ObservableImpl observableImpl = this;
        synchronized (observableImpl) {
            this.getObservers().clear();
        }
    }

    @Override
    public void resetObservers() {
    }

    public void notifyObservers(Observable observable) {
        this.notifyObservers(observable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Observable observable, Object object) {
        ObservableImpl observableImpl = this;
        synchronized (observableImpl) {
            Iterator<WeakReference<Observer>> i = this.getObservers().iterator();
            while (i.hasNext()) {
                Observer observer = (Observer)i.next().get();
                if (observer == null) {
                    i.remove();
                    continue;
                }
                new Notifier(observer, observable, object).start();
            }
        }
    }

    private static class Notifier
    extends Thread {
        private final Observer observer;
        private final Observable observable;
        private final Object object;

        public Notifier(Observer observer, Observable observable, Object object) {
            this.observer = observer;
            this.observable = observable;
            this.object = object;
        }

        public void run() {
            this.observer.update(this.observable, this.object);
        }
    }
}

