/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateSettings;
import org.netbeans.modules.autoupdate.ui.actions.AvailableUpdatesNotification;
import org.netbeans.modules.autoupdate.ui.actions.BalloonManager;
import org.netbeans.modules.autoupdate.ui.actions.PluginManagerAction;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizard;
import org.netbeans.modules.autoupdate.ui.wizards.LazyInstallUnitWizardIterator;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoupdateCheckScheduler {
    private static RequestProcessor.Task regularlyCheck = null;
    private static final RequestProcessor REGULARLY_CHECK_TIMER = new RequestProcessor("auto-checker-reqularly-timer", 1, true);
    private static final Logger err = Logger.getLogger(AutoupdateCheckScheduler.class.getName());
    private static boolean wasRealCheckUpdateCenters = false;
    private static Runnable doCheckAvailableUpdates = new Runnable(){

        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.getDefault().post(doCheckAvailableUpdates);
                return;
            }
            boolean bl = false;
            if (Utilities.shouldCheckAvailableUpdates()) {
                Collection<UpdateElement> collection = AutoupdateCheckScheduler.checkUpdateElements(OperationWizardModel.OperationType.UPDATE, false);
                bl = collection != null && !collection.isEmpty();
                LazyInstallUnitWizardIterator.LazyUnit.storeUpdateElements(OperationWizardModel.OperationType.UPDATE, collection);
            }
            if (!bl && Utilities.shouldCheckAvailableNewPlugins()) {
                LazyInstallUnitWizardIterator.LazyUnit.storeUpdateElements(OperationWizardModel.OperationType.INSTALL, AutoupdateCheckScheduler.checkUpdateElements(OperationWizardModel.OperationType.INSTALL, false));
            }
            RequestProcessor.getDefault().post(doCheckLazyUpdates, 500);
        }
    };
    private static Runnable doCheck = new Runnable(){

        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.getDefault().post(doCheck);
                return;
            }
            if (AutoupdateCheckScheduler.timeToCheck()) {
                AutoupdateCheckScheduler.scheduleRefreshProviders();
                wasRealCheckUpdateCenters = true;
                if (AutoupdateCheckScheduler.getWaitPeriod() > 0 && regularlyCheck != null && regularlyCheck.getDelay() <= 0) {
                    regularlyCheck = REGULARLY_CHECK_TIMER.post(doCheck, AutoupdateCheckScheduler.getWaitPeriod(), 1);
                }
            }
        }
    };
    private static Runnable doCheckLazyUpdates = new Runnable(){

        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.getDefault().post(doCheckLazyUpdates);
                return;
            }
            Collection<LazyInstallUnitWizardIterator.LazyUnit> collection = LazyInstallUnitWizardIterator.LazyUnit.loadLazyUnits(OperationWizardModel.OperationType.UPDATE);
            boolean bl = collection != null && !collection.isEmpty();
            AutoupdateCheckScheduler.notifyAvailable(collection, OperationWizardModel.OperationType.UPDATE);
            if (!bl) {
                Collection<LazyInstallUnitWizardIterator.LazyUnit> collection2 = LazyInstallUnitWizardIterator.LazyUnit.loadLazyUnits(OperationWizardModel.OperationType.INSTALL);
                AutoupdateCheckScheduler.notifyAvailable(collection2, OperationWizardModel.OperationType.INSTALL);
            }
        }
    };
    private static AvailableUpdatesNotification.UpdatesFlasher flasher;

    private AutoupdateCheckScheduler() {
    }

    public static void signOn() {
        AutoupdateSettings.generateIdentity();
        if (AutoupdateCheckScheduler.timeToCheck()) {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                public void run() {
                    RequestProcessor.getDefault().post(doCheck, 5000);
                }
            });
        } else {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                public void run() {
                    RequestProcessor.getDefault().post(doCheckLazyUpdates, 11000);
                }
            });
        }
    }

    private static void scheduleRefreshProviders() {
        AutoupdateCheckScheduler.refreshUpdateCenters(null);
        final long l = System.currentTimeMillis();
        RequestProcessor.Task task = RequestProcessor.getDefault().post(doCheckAvailableUpdates, 500);
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                task.removeTaskListener((TaskListener)this);
                long l2 = (System.currentTimeMillis() - l - 500L) / 1000L;
                if (l2 > 0L) {
                    Utilities.putTimeOfInitialization(l2);
                }
            }
        });
    }

    private static Runnable getRefresher(final UpdateUnitProvider updateUnitProvider, final Collection<String> collection, final ProgressHandle progressHandle) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    block5: {
                        try {
                            err.log(Level.FINE, "Start refresh " + updateUnitProvider.getName() + "[" + updateUnitProvider.getDisplayName() + "]");
                            updateUnitProvider.refresh(progressHandle, true);
                            PluginManagerUI pluginManagerUI = PluginManagerAction.getPluginManagerUI();
                            if (pluginManagerUI == null || !pluginManagerUI.initTask.isFinished()) break block5;
                            pluginManagerUI.updateUnitsChanged();
                        }
                        catch (IOException iOException) {
                            err.log(Level.INFO, iOException.getMessage(), iOException);
                            if (collection != null) {
                                collection.add(iOException.getLocalizedMessage());
                            }
                            Object var3_4 = null;
                            err.log(Level.FINEST, "Refresh of " + updateUnitProvider.getName() + "[" + updateUnitProvider.getDisplayName() + "]" + " is finish.");
                        }
                    }
                    Object var3_3 = null;
                    err.log(Level.FINEST, "Refresh of " + updateUnitProvider.getName() + "[" + updateUnitProvider.getDisplayName() + "]" + " is finish.");
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    err.log(Level.FINEST, "Refresh of " + updateUnitProvider.getName() + "[" + updateUnitProvider.getDisplayName() + "]" + " is finish.");
                    throw throwable;
                }
            }
        };
    }

    public static void runCheckAvailableUpdates(int n) {
        RequestProcessor.getDefault().post(doCheckAvailableUpdates, n);
    }

    public static Collection<UpdateElement> checkUpdateElements(OperationWizardModel.OperationType operationType, boolean bl) {
        Set set;
        UpdateUnit updateUnit;
        OperationContainer.OperationInfo operationInfo;
        UpdateElement updateElement;
        List<UnitCategory> list;
        err.log(Level.FINEST, "Check UpdateElements for " + (Object)((Object)operationType));
        if (bl) {
            AutoupdateCheckScheduler.refreshUpdateCenters(ProgressHandleFactory.createHandle((String)"dummy-check-for-updates"));
        }
        List list2 = UpdateManager.getDefault().getUpdateUnits(Utilities.getUnitTypes());
        boolean bl2 = OperationWizardModel.OperationType.UPDATE == operationType;
        List<UnitCategory> list3 = list = bl2 ? Utilities.makeUpdateCategories(list2, false) : Utilities.makeAvailableCategories(list2, false);
        if (list == null || list.isEmpty()) {
            err.log(Level.FINE, "findUpdateElements(" + (Object)((Object)operationType) + ") doesn't find any elements.");
            return null;
        }
        Set<Object> set2 = new HashSet<UpdateElement>();
        boolean bl3 = false;
        boolean bl4 = false;
        OperationContainer operationContainer = bl2 ? OperationContainer.createForUpdate() : OperationContainer.createForInstall();
        block0: for (UnitCategory unitCategory : list) {
            for (Unit unit : unitCategory.getUnits()) {
                updateElement = bl2 ? ((Unit.Update)unit).getRelevantElement() : ((Unit.Available)unit).getRelevantElement();
                if (!operationContainer.canBeAdded(updateElement.getUpdateUnit(), updateElement) || bl3) continue;
                operationInfo = operationContainer.add(updateElement);
                if (operationInfo == null) {
                    set2.add(updateElement);
                    continue;
                }
                updateUnit = new HashSet(operationInfo.getRequiredElements());
                set = operationInfo.getBrokenDependencies();
                if (!set.isEmpty()) {
                    err.log(Level.WARNING, "Plugin " + operationInfo + " cannot be installed because some dependencies cannot be satisfied: " + set);
                    bl4 = true;
                    continue block0;
                }
                for (Object object : updateUnit) {
                    if (!object.getUpdateUnit().isPending()) continue;
                    err.log(Level.WARNING, "Plugin " + operationInfo.getUpdateElement() + " depends on " + object + " in pending state.");
                    bl3 = true;
                    set2 = Collections.emptySet();
                    break;
                }
                operationContainer.add((Collection)updateUnit);
                set2.add(updateElement);
            }
        }
        if (!bl3 && !operationContainer.listInvalid().isEmpty()) {
            err.log(Level.WARNING, "Plugins " + set2 + " cannot be installed, Install Container contains invalid elements " + operationContainer.listInvalid());
        }
        if (!bl3 && bl4) {
            set2 = new HashSet();
            for (UnitCategory unitCategory : list) {
                for (Unit unit : unitCategory.getUnits()) {
                    Object object;
                    updateElement = bl2 ? OperationContainer.createForUpdate() : OperationContainer.createForInstall();
                    if (!updateElement.canBeAdded(updateUnit = (operationInfo = bl2 ? ((Unit.Update)unit).getRelevantElement() : ((Unit.Available)unit).getRelevantElement()).getUpdateUnit(), (UpdateElement)operationInfo)) continue;
                    set = updateElement.add((UpdateElement)operationInfo);
                    if (set == null) {
                        set2.add((UpdateElement)operationInfo);
                        continue;
                    }
                    boolean bl5 = false;
                    object = new HashSet(set.getRequiredElements());
                    Object object2 = object.iterator();
                    while (object2.hasNext()) {
                        UpdateElement updateElement2 = (UpdateElement)object2.next();
                        if (!updateElement2.getUpdateUnit().isPending()) continue;
                        err.log(Level.WARNING, "Plugin " + operationInfo + " depends on " + updateElement2 + " in pending state.");
                        bl5 = true;
                    }
                    if (bl5) continue;
                    updateElement.add((Collection)object);
                    object2 = new HashSet();
                    for (OperationContainer.OperationInfo operationInfo2 : updateElement.listAll()) {
                        object2.addAll(operationInfo2.getBrokenDependencies());
                    }
                    if (object2.isEmpty() && updateElement.listInvalid().isEmpty()) {
                        set2.add((UpdateElement)operationInfo);
                        continue;
                    }
                    updateElement.removeAll();
                    if (!object2.isEmpty()) {
                        err.log(Level.WARNING, "Plugin " + operationInfo + " cannot be installed because some dependencies cannot be satisfied: " + object2);
                        continue;
                    }
                    err.log(Level.WARNING, "Plugin " + operationInfo + " cannot be installed, Install Container contains invalid elements " + updateElement.listInvalid());
                }
            }
        }
        err.log(Level.FINE, "findUpdateElements(" + (Object)((Object)operationType) + ") returns " + set2.size() + " elements.");
        return set2;
    }

    private static Collection<String> refreshUpdateCenters(ProgressHandle progressHandle) {
        long l = System.currentTimeMillis();
        HashSet<String> hashSet = new HashSet<String>();
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run refreshProviders in EQ!";
        HashSet<RequestProcessor.Task> hashSet2 = new HashSet<RequestProcessor.Task>();
        for (UpdateUnitProvider updateUnitProvider : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true)) {
            RequestProcessor.Task task = RequestProcessor.getDefault().post(AutoupdateCheckScheduler.getRefresher(updateUnitProvider, hashSet, progressHandle));
            hashSet2.add(task);
        }
        err.log(Level.FINEST, "Waiting for all refreshTasks...");
        for (RequestProcessor.Task task : hashSet2) {
            task.waitFinished();
        }
        err.log(Level.FINEST, "Waiting for all refreshTasks is done.");
        long l2 = (System.currentTimeMillis() - l) / 1000L;
        if (l2 > 0L) {
            Utilities.putTimeOfRefreshUpdateCenters(l2);
        }
        return hashSet;
    }

    private static boolean timeToCheck() {
        if (AutoupdateCheckScheduler.getReqularlyTimerTask() != null && AutoupdateCheckScheduler.getReqularlyTimerTask().getDelay() <= 0 && AutoupdateCheckScheduler.getWaitPeriod() > 0) {
            return true;
        }
        if (AutoupdateSettings.getLastCheck() == null) {
            return true;
        }
        switch (AutoupdateSettings.getPeriod()) {
            case 0: {
                return true;
            }
            case 5: {
                return false;
            }
            case 6: {
                return AutoupdateSettings.getLastCheck().getTime() + (long)AutoupdateSettings.getCheckInterval() < new Date().getTime();
            }
        }
        Date date = AutoupdateSettings.getLastCheck();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(10, 0);
        gregorianCalendar.set(9, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        switch (AutoupdateSettings.getPeriod()) {
            case 1: {
                gregorianCalendar.add(5, 1);
                break;
            }
            case 2: {
                gregorianCalendar.add(3, 1);
                break;
            }
            case 3: {
                gregorianCalendar.add(3, 2);
                break;
            }
            case 4: {
                gregorianCalendar.add(2, 1);
            }
        }
        return gregorianCalendar.getTime().before(new Date());
    }

    private static RequestProcessor.Task getReqularlyTimerTask() {
        if (regularlyCheck == null && AutoupdateCheckScheduler.getWaitPeriod() > 0) {
            int n;
            int n2 = n = AutoupdateCheckScheduler.getWaitPeriod();
            if (AutoupdateSettings.getLastCheck() != null) {
                n2 = n - (int)(System.currentTimeMillis() - AutoupdateSettings.getLastCheck().getTime());
            }
            if (n2 <= 0) {
                n2 = n;
            }
            regularlyCheck = REGULARLY_CHECK_TIMER.post(doCheck, n2, 1);
        }
        return regularlyCheck;
    }

    private static int getWaitPeriod() {
        switch (AutoupdateSettings.getPeriod()) {
            case 5: {
                return 0;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 86400000;
            }
            case 2: {
                return 604800000;
            }
            case 3: {
                return 1209600000;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
            case 6: {
                return AutoupdateSettings.getCheckInterval();
            }
        }
        return 0;
    }

    public static void notifyAvailable(final Collection<LazyInstallUnitWizardIterator.LazyUnit> collection, final OperationWizardModel.OperationType operationType) {
        if (collection == null || collection.isEmpty()) {
            if (flasher != null) {
                flasher.disappear();
            }
            BalloonManager.dismiss();
            return;
        }
        final Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                boolean bl = false;
                RequestProcessor.Task task = PluginManagerUI.getRunningTask();
                if (task != null && !task.isFinished()) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AutoupdateCheckScheduler.class, (String)"AutoupdateCheckScheduler_InstallInProgress"), 2));
                    return;
                }
                try {
                    bl = new InstallUnitWizard().invokeLazyWizard(collection, operationType, false);
                    Object var4_3 = null;
                    if (!bl) return;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (!bl) throw throwable;
                    PluginManagerUI pluginManagerUI = PluginManagerAction.getPluginManagerUI();
                    if (pluginManagerUI != null) {
                        pluginManagerUI.updateUnitsChanged();
                    }
                    if (flasher != null) {
                        flasher.disappear();
                    }
                    BalloonManager.dismiss();
                    RequestProcessor.getDefault().post(doCheckAvailableUpdates);
                    throw throwable;
                }
                PluginManagerUI pluginManagerUI = PluginManagerAction.getPluginManagerUI();
                if (pluginManagerUI != null) {
                    pluginManagerUI.updateUnitsChanged();
                }
                if (flasher != null) {
                    flasher.disappear();
                }
                BalloonManager.dismiss();
                RequestProcessor.getDefault().post(doCheckAvailableUpdates);
            }
        };
        boolean bl = flasher != null;
        flasher = AvailableUpdatesNotification.getFlasher(runnable);
        assert (flasher != null) : "Updates Flasher cannot be null.";
        flasher.startFlashing();
        final Runnable runnable2 = new Runnable(){

            public void run() {
                BalloonManager.show(flasher, AutoupdateCheckScheduler.createBalloonContent(collection.size()), new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        runnable.run();
                    }
                }, Utilities.getShowingBalloonTimeout());
            }
        };
        if (!bl) {
            if (AutoupdateCheckScheduler.canShowBalloon()) {
                SwingUtilities.invokeLater(runnable2);
            }
            flasher.addMouseListener(new MouseAdapter(){
                RequestProcessor.Task t = null;
                private RequestProcessor RP = new RequestProcessor("balloon-manager");

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.t = this.RP.post(new Runnable(){

                        public void run() {
                            runnable2.run();
                        }
                    }, ToolTipManager.sharedInstance().getInitialDelay());
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    if (null != this.t) {
                        this.t.cancel();
                        this.t = null;
                        BalloonManager.dismissSlowly(ToolTipManager.sharedInstance().getDismissDelay());
                    }
                }
            });
        }
    }

    private static boolean canShowBalloon() {
        if (Utilities.allowShowingBalloon() != null) {
            return Utilities.allowShowingBalloon();
        }
        return wasRealCheckUpdateCenters;
    }

    private static JComponent createBalloonContent(int n) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(n == 1 ? NbBundle.getMessage(AutoupdateCheckScheduler.class, (String)"AutoupdateCheckScheduler_UpdateFound_ToolTip", (Object)n) : NbBundle.getMessage(AutoupdateCheckScheduler.class, (String)"AutoupdateCheckScheduler_UpdatesFound_ToolTip", (Object)n));
        jLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/autoupdate/ui/resources/info_icon.png")));
        jLabel.setIconTextGap(10);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(NbBundle.getMessage(AutoupdateCheckScheduler.class, (String)"AutoupdateCheckScheduler_UpdateFound_Hint")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 0, 0), 0, 0));
        return jPanel;
    }
}

