/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.solr.common.SolrException;

public class PropertiesUtil {
    public static String substituteProperty(String value, Properties coreProperties) {
        if (value == null || value.indexOf(36) == -1) {
            return value;
        }
        ArrayList<String> fragments = new ArrayList<String>();
        ArrayList<String> propertyRefs = new ArrayList<String>();
        PropertiesUtil.parsePropertyString(value, fragments, propertyRefs);
        StringBuilder sb = new StringBuilder();
        Iterator i = fragments.iterator();
        Iterator j = propertyRefs.iterator();
        while (i.hasNext()) {
            String fragment = (String)i.next();
            if (fragment == null) {
                String propertyName = (String)j.next();
                String defaultValue = null;
                int colon_index = propertyName.indexOf(58);
                if (colon_index > -1) {
                    defaultValue = propertyName.substring(colon_index + 1);
                    propertyName = propertyName.substring(0, colon_index);
                }
                if (coreProperties != null) {
                    fragment = coreProperties.getProperty(propertyName);
                }
                if (fragment == null) {
                    fragment = System.getProperty(propertyName, defaultValue);
                }
                if (fragment == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No system property or default value specified for " + propertyName + " value:" + value);
                }
            }
            sb.append(fragment);
        }
        return sb.toString();
    }

    private static void parsePropertyString(String value, List<String> fragments, List<String> propertyRefs) {
        int pos;
        int prev = 0;
        while ((pos = value.indexOf("$", prev)) >= 0) {
            if (pos > 0) {
                fragments.add(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                fragments.add("$");
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                if (value.charAt(pos + 1) == '$') {
                    fragments.add("$");
                    prev = pos + 2;
                    continue;
                }
                fragments.add(value.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                throw new RuntimeException("Syntax error in property: " + value);
            }
            String propertyName = value.substring(pos + 2, endName);
            fragments.add(null);
            propertyRefs.add(propertyName);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            fragments.add(value.substring(prev));
        }
    }

    public static Integer toInteger(String value, Integer defValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public static boolean toBoolean(String value) {
        return "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
    }
}

