/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.tagger;

import com.carrotsearch.hppc.IntArrayList;
import java.util.Arrays;

public abstract class OffsetCorrector {
    protected final String docText;
    protected final IntArrayList tagInfo;
    protected final IntArrayList parentChangeOffsets;
    protected final IntArrayList parentChangeIds;
    protected final int[] offsetPair = new int[]{-1, -1};
    protected final IntArrayList nonTaggableOffsets;

    protected OffsetCorrector(String docText, boolean hasNonTaggable) {
        this.docText = docText;
        int guessNumElements = Math.max(docText.length() / 20, 4);
        this.tagInfo = new IntArrayList(guessNumElements * 5);
        this.parentChangeOffsets = new IntArrayList(guessNumElements * 2);
        this.parentChangeIds = new IntArrayList(guessNumElements * 2);
        this.nonTaggableOffsets = hasNonTaggable ? new IntArrayList(guessNumElements / 5) : null;
    }

    public int[] correctPair(int leftOffset, int rightOffset) {
        if (this.spansNonTaggable(leftOffset, rightOffset = this.correctEndOffsetForCloseElement(rightOffset))) {
            return null;
        }
        int startTag = this.lookupTag(leftOffset);
        int endTag = this.lookupTag(rightOffset - 1);
        int iTag = startTag;
        while (!this.tagEnclosesOffset(iTag, rightOffset)) {
            int tagOpenEndOff = this.getOpenEndOff(iTag);
            if (this.hasNonWhitespace(tagOpenEndOff, leftOffset)) {
                return null;
            }
            leftOffset = this.getOpenStartOff(iTag);
            iTag = this.getParentTag(iTag);
        }
        int ancestorTag = iTag;
        iTag = endTag;
        while (iTag != ancestorTag) {
            int tagCloseStartOff = this.getCloseStartOff(iTag);
            if (this.hasNonWhitespace(rightOffset, tagCloseStartOff)) {
                return null;
            }
            rightOffset = this.getCloseEndOff(iTag);
            iTag = this.getParentTag(iTag);
        }
        this.offsetPair[0] = leftOffset;
        this.offsetPair[1] = rightOffset;
        return this.offsetPair;
    }

    protected int correctEndOffsetForCloseElement(int endOffset) {
        int newEndOffset;
        if (this.docText.charAt(endOffset - 1) == '>' && (newEndOffset = this.docText.lastIndexOf(60, endOffset - 2)) > this.offsetPair[0]) {
            return newEndOffset;
        }
        return endOffset;
    }

    protected boolean hasNonWhitespace(int start, int end) {
        for (int i = start; i < end; ++i) {
            if (Character.isWhitespace(this.docText.charAt(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean tagEnclosesOffset(int tag, int off) {
        return off >= this.getOpenStartOff(tag) && off < this.getCloseEndOff(tag);
    }

    protected int getParentTag(int tag) {
        return this.tagInfo.get(tag * 5 + 0);
    }

    protected int getOpenStartOff(int tag) {
        return this.tagInfo.get(tag * 5 + 1);
    }

    protected int getOpenEndOff(int tag) {
        return this.tagInfo.get(tag * 5 + 2);
    }

    protected int getCloseStartOff(int tag) {
        return this.tagInfo.get(tag * 5 + 3);
    }

    protected int getCloseEndOff(int tag) {
        return this.tagInfo.get(tag * 5 + 4);
    }

    protected int lookupTag(int off) {
        int idx = Arrays.binarySearch(this.parentChangeOffsets.buffer, 0, this.parentChangeOffsets.size(), off);
        if (idx < 0) {
            idx = -idx - 1 - 1;
        }
        return this.parentChangeIds.get(idx);
    }

    protected boolean spansNonTaggable(int startOff, int endOff) {
        if (this.nonTaggableOffsets == null) {
            return false;
        }
        int idx = Arrays.binarySearch(this.nonTaggableOffsets.buffer, 0, this.nonTaggableOffsets.size(), startOff);
        if (idx >= 0) {
            return true;
        }
        if (((idx = -idx - 1) & 1) == 1) {
            return true;
        }
        if (idx == this.nonTaggableOffsets.size()) {
            return false;
        }
        return this.nonTaggableOffsets.get(idx) < endOff;
    }
}

