/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ChooseComponentsToExportDialog;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\u001a\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00100\u000fH\u0014J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/configurationStore/ExportSettingsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "exportSettings", "saveFile", "Ljava/nio/file/Path;", "markedComponents", "", "Lcom/intellij/configurationStore/ExportableItem;", "getExportableComponents", "", "", "update", "intellij.platform.configurationStore.impl"})
public class ExportSettingsAction
extends AnAction
implements DumbAware {
    @NotNull
    protected Map<Path, List<ExportableItem>> getExportableComponents() {
        return ExportSettingsActionKt.getExportableComponentsMap$default(true, true, null, null, 12, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void exportSettings(@NotNull Path saveFile, @NotNull Set<ExportableItem> markedComponents) {
        void $this$mapTo$iv;
        Intrinsics.checkParameterIsNotNull((Object)saveFile, (String)"saveFile");
        Intrinsics.checkParameterIsNotNull(markedComponents, (String)"markedComponents");
        Object object = markedComponents;
        Collection destination$iv = (Collection)new ObjectOpenHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            ExportableItem exportableItem = (ExportableItem)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Path path = it.getFile();
            collection.add(path);
        }
        ObjectOpenHashSet exportFiles = (ObjectOpenHashSet)destination$iv;
        object = PathKt.outputStream((Path)saveFile);
        boolean bl = false;
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)object;
            boolean bl2 = false;
            Set set = (Set)exportFiles;
            String string = FileUtil.toSystemIndependentName((String)PathManager.getConfigPath());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.toSystemIndepen\u2026hManager.getConfigPath())");
            ExportSettingsActionKt.exportSettings(set, it, string);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(ExportSettingsActionKt.isImportExportActionApplicable());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        ApplicationManager.getApplication().saveSettings();
        Map<Path, List<ExportableItem>> map = this.getExportableComponents();
        String string = ConfigurationStoreBundle.message("title.select.components.to.export", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ConfigurationStoreBundle\u2026ct.components.to.export\")");
        String string2 = ConfigurationStoreBundle.message("prompt.please.check.all.components.to.export", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ConfigurationStoreBundle\u2026ll.components.to.export\")");
        ChooseComponentsToExportDialog dialog = new ChooseComponentsToExportDialog(map, true, string, string2);
        if (!dialog.showAndGet()) {
            return;
        }
        Set<ExportableItem> markedComponents = dialog.getExportableComponents$intellij_platform_configurationStore_impl();
        if (markedComponents.isEmpty()) {
            return;
        }
        Path saveFile = dialog.getExportFile$intellij_platform_configurationStore_impl();
        try {
            if (PathKt.exists((Path)saveFile)) {
                String string3 = IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"IdeBundle.message(\"title.file.already.exists\")");
                String string4 = ConfigurationStoreBundle.message("prompt.overwrite.settings.file", ((Object)saveFile).toString());
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"ConfigurationStoreBundle\u2026le\", saveFile.toString())");
                String string5 = IdeBundle.message((String)"action.overwrite", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"IdeBundle.message(\"action.overwrite\")");
                if (MessageUtil.showOkCancelDialog$default((String)string3, (String)string4, (String)string5, null, (Icon)Messages.getWarningIcon(), null, null, (int)104, null) != 0) {
                    return;
                }
            }
            this.exportSettings(saveFile, markedComponents);
            RevealFileAction.showDialog((Project)AnAction.getEventProject((AnActionEvent)e), (String)ConfigurationStoreBundle.message("message.settings.exported.successfully", new Object[0]), (String)ConfigurationStoreBundle.message("title.export.successful", new Object[0]), (File)saveFile.toFile(), null);
        }
        catch (IOException e2) {
            Messages.showErrorDialog((String)ConfigurationStoreBundle.message("error.writing.settings", e2.toString()), (String)IdeBundle.message((String)"title.error.writing.file", (Object[])new Object[0]));
        }
    }
}

