/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.NettyKt;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Random;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServerKt;
import org.jetbrains.io.BuiltInServerThreadFactory;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.DelegatingHttpRequestHandler;
import org.jetbrains.io.IdeaNettyLogger;
import org.jetbrains.io.PortUnificationServerHandler;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/io/BuiltInServer;", "Lcom/intellij/openapi/Disposable;", "eventLoopGroup", "Lio/netty/channel/EventLoopGroup;", "port", "", "channelRegistrar", "Lorg/jetbrains/io/ChannelRegistrar;", "(Lio/netty/channel/EventLoopGroup;ILorg/jetbrains/io/ChannelRegistrar;)V", "getEventLoopGroup", "()Lio/netty/channel/EventLoopGroup;", "isRunning", "", "()Z", "getPort", "()I", "dispose", "", "Companion", "intellij.platform.ide.util.io"})
public final class BuiltInServer
implements Disposable {
    @NotNull
    private final EventLoopGroup eventLoopGroup;
    private final int port;
    private final ChannelRegistrar channelRegistrar;
    public static final Companion Companion = new Companion(null);

    public final boolean isRunning() {
        return !this.channelRegistrar.isEmpty();
    }

    public void dispose() {
        this.channelRegistrar.close();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BuiltInServer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        logger.info("web server stopped");
    }

    @NotNull
    public final EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public final int getPort() {
        return this.port;
    }

    private BuiltInServer(EventLoopGroup eventLoopGroup, int port, ChannelRegistrar channelRegistrar) {
        this.eventLoopGroup = eventLoopGroup;
        this.port = port;
        this.channelRegistrar = channelRegistrar;
    }

    static {
        if (SystemProperties.getBooleanProperty((String)"io.netty.random.id", (boolean)true)) {
            System.setProperty("io.netty.machineId", "28:f0:76:ff:fe:16:65:0e");
            System.setProperty("io.netty.processId", String.valueOf(new Random().nextInt(65535)));
        }
        System.setProperty("io.netty.serviceThreadPrefix", "Netty ");
        BuiltInServer.Companion.setSystemPropertyIfNotConfigured("io.netty.allocator.numDirectArenas", "1");
        BuiltInServer.Companion.setSystemPropertyIfNotConfigured("io.netty.allocator.numHeapArenas", "1");
        BuiltInServer.Companion.setSystemPropertyIfNotConfigured("io.netty.allocator.useCacheForAllThreads", "false");
        BuiltInServer.Companion.setSystemPropertyIfNotConfigured("io.netty.allocator.cacheTrimIntervalMillis", "600000");
        IdeaNettyLogger logger = new IdeaNettyLogger();
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new InternalLoggerFactory(logger){
            final /* synthetic */ IdeaNettyLogger $logger;

            @NotNull
            protected IdeaNettyLogger newInstance(@NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return this.$logger;
            }
            {
                this.$logger = $captured_local_variable$0;
            }
        });
    }

    public /* synthetic */ BuiltInServer(EventLoopGroup eventLoopGroup, int port, ChannelRegistrar channelRegistrar, DefaultConstructorMarker $constructor_marker) {
        this(eventLoopGroup, port, channelRegistrar);
    }

    public static final int getRecommendedWorkerCount() {
        return Companion.getRecommendedWorkerCount();
    }

    @JvmStatic
    @NotNull
    public static final BuiltInServer startNioOrOio(int workerCount, int firstPort, int portsCount, boolean tryAnyPort, @Nullable Supplier<ChannelHandler> handler2) {
        return Companion.startNioOrOio(workerCount, firstPort, portsCount, tryAnyPort, handler2);
    }

    @JvmStatic
    public static final void configureChildHandler(@NotNull ServerBootstrap bootstrap, @NotNull ChannelRegistrar channelRegistrar, @Nullable Supplier<ChannelHandler> channelHandler) {
        Companion.configureChildHandler(bootstrap, channelRegistrar, channelHandler);
    }

    @JvmStatic
    public static final void replaceDefaultHandler(@NotNull ChannelHandlerContext context, @NotNull ChannelHandler channelHandler) {
        Companion.replaceDefaultHandler(context, channelHandler);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0007J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0016H\u0007J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J>\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015J:\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0010\b\u0002\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015J8\u0010$\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0007R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006%"}, d2={"Lorg/jetbrains/io/BuiltInServer$Companion;", "", "()V", "recommendedWorkerCount", "", "recommendedWorkerCount$annotations", "getRecommendedWorkerCount", "()I", "bind", "firstPort", "portsCount", "tryAnyPort", "", "bootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "channelRegistrar", "Lorg/jetbrains/io/ChannelRegistrar;", "isEventLoopGroupOwner", "configureChildHandler", "", "channelHandler", "Ljava/util/function/Supplier;", "Lio/netty/channel/ChannelHandler;", "replaceDefaultHandler", "context", "Lio/netty/channel/ChannelHandlerContext;", "setSystemPropertyIfNotConfigured", "name", "", "value", "start", "Lorg/jetbrains/io/BuiltInServer;", "eventLoopGroup", "Lio/netty/channel/EventLoopGroup;", "handler", "workerCount", "startNioOrOio", "intellij.platform.ide.util.io"})
    public static final class Companion {
        private final void setSystemPropertyIfNotConfigured(String name, String value) {
            if (System.getProperty(name) == null) {
                System.setProperty(name, value);
            }
        }

        @JvmStatic
        public static /* synthetic */ void recommendedWorkerCount$annotations() {
        }

        public final int getRecommendedWorkerCount() {
            return PlatformUtils.isIdeaCommunity() ? 2 : 3;
        }

        @NotNull
        public final BuiltInServer start(int workerCount, int firstPort, int portsCount, boolean tryAnyPort, @Nullable Supplier<ChannelHandler> handler2) throws Exception {
            return this.start((EventLoopGroup)BuiltInServerKt.access$multiThreadEventLoopGroup(workerCount, new BuiltInServerThreadFactory()), true, firstPort, portsCount, tryAnyPort, handler2);
        }

        public static /* synthetic */ BuiltInServer start$default(Companion companion, int n, int n2, int n3, boolean bl, Supplier supplier, int n4, Object object) throws Exception {
            if ((n4 & 8) != 0) {
                bl = false;
            }
            if ((n4 & 0x10) != 0) {
                supplier = null;
            }
            return companion.start(n, n2, n3, bl, supplier);
        }

        @JvmStatic
        @NotNull
        public final BuiltInServer startNioOrOio(int workerCount, int firstPort, int portsCount, boolean tryAnyPort, @Nullable Supplier<ChannelHandler> handler2) {
            EventExecutorGroup eventExecutorGroup;
            BuiltInServerThreadFactory threadFactory = new BuiltInServerThreadFactory();
            try {
                eventExecutorGroup = (EventExecutorGroup)BuiltInServerKt.access$multiThreadEventLoopGroup(workerCount, threadFactory);
            }
            catch (IllegalStateException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(BuiltInServer.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn((Throwable)e);
                eventExecutorGroup = (EventExecutorGroup)new OioEventLoopGroup(1, (ThreadFactory)threadFactory);
            }
            EventLoopGroup loopGroup = (EventLoopGroup)eventExecutorGroup;
            return this.start(loopGroup, true, firstPort, portsCount, tryAnyPort, handler2);
        }

        @NotNull
        public final BuiltInServer start(@NotNull EventLoopGroup eventLoopGroup, boolean isEventLoopGroupOwner, int firstPort, int portsCount, boolean tryAnyPort, @Nullable Supplier<ChannelHandler> handler2) throws Exception {
            Intrinsics.checkParameterIsNotNull((Object)eventLoopGroup, (String)"eventLoopGroup");
            ChannelRegistrar channelRegistrar = new ChannelRegistrar();
            ServerBootstrap bootstrap = NettyKt.serverBootstrap(eventLoopGroup);
            this.configureChildHandler(bootstrap, channelRegistrar, handler2);
            int port = this.bind(firstPort, portsCount, tryAnyPort, bootstrap, channelRegistrar, isEventLoopGroupOwner);
            return new BuiltInServer(eventLoopGroup, port, channelRegistrar, null);
        }

        @JvmStatic
        public final void configureChildHandler(@NotNull ServerBootstrap bootstrap, @NotNull ChannelRegistrar channelRegistrar, @Nullable Supplier<ChannelHandler> channelHandler) {
            Intrinsics.checkParameterIsNotNull((Object)bootstrap, (String)"bootstrap");
            Intrinsics.checkParameterIsNotNull((Object)((Object)channelRegistrar), (String)"channelRegistrar");
            PortUnificationServerHandler portUnificationServerHandler = channelHandler == null ? new PortUnificationServerHandler() : null;
            bootstrap.childHandler(new ChannelHandler(channelRegistrar, channelHandler, portUnificationServerHandler){
                final /* synthetic */ ChannelRegistrar $channelRegistrar;
                final /* synthetic */ Supplier $channelHandler;
                final /* synthetic */ PortUnificationServerHandler $portUnificationServerHandler;

                protected void initChannel(@NotNull Channel channel) {
                    Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                    ChannelPipeline channelPipeline = channel.pipeline();
                    ChannelHandler[] channelHandlerArray = new ChannelHandler[2];
                    channelHandlerArray[0] = (ChannelHandler)this.$channelRegistrar;
                    Supplier supplier = this.$channelHandler;
                    if (supplier == null || (supplier = (ChannelHandler)supplier.get()) == null) {
                        supplier = (ChannelHandler)this.$portUnificationServerHandler;
                    }
                    channelHandlerArray[1] = supplier;
                    channelPipeline.addLast(channelHandlerArray);
                }
                {
                    this.$channelRegistrar = $captured_local_variable$0;
                    this.$channelHandler = $captured_local_variable$1;
                    this.$portUnificationServerHandler = $captured_local_variable$2;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final int bind(int firstPort, int portsCount, boolean tryAnyPort, ServerBootstrap bootstrap, ChannelRegistrar channelRegistrar, boolean isEventLoopGroupOwner) throws Exception {
            ChannelFuture future;
            InetAddress address = InetAddress.getLoopbackAddress();
            int n = 0;
            int n2 = portsCount;
            while (n < n2) {
                void i;
                int port = firstPort + i;
                if (ArrayUtil.indexOf((int[])BuiltInServerKt.access$getFORBIDDEN_PORTS$p(), (int)i) < 0) {
                    ChannelFuture future2;
                    ChannelFuture channelFuture = future2 = bootstrap.bind(address, port).awaitUninterruptibly();
                    Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"future");
                    if (channelFuture.isSuccess()) {
                        channelRegistrar.setServerChannel(future2.channel(), isEventLoopGroupOwner);
                        return port;
                    }
                    if (!tryAnyPort && i == portsCount - 1) {
                        ExceptionUtil.rethrowAll((Throwable)future2.cause());
                    }
                }
                ++i;
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(BuiltInServer.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.info("We cannot bind to our default range, so, try to bind to any free port");
            ChannelFuture channelFuture = future = bootstrap.bind(address, 0).awaitUninterruptibly();
            Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"future");
            if (channelFuture.isSuccess()) {
                channelRegistrar.setServerChannel(future.channel(), isEventLoopGroupOwner);
                SocketAddress socketAddress = future.channel().localAddress();
                if (socketAddress == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
                }
                return ((InetSocketAddress)socketAddress).getPort();
            }
            Throwable throwable = future.cause();
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"future.cause()");
            throw throwable;
        }

        @JvmStatic
        public final void replaceDefaultHandler(@NotNull ChannelHandlerContext context, @NotNull ChannelHandler channelHandler) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)channelHandler, (String)"channelHandler");
            context.pipeline().replace(DelegatingHttpRequestHandler.class, "replacedDefaultHandler", channelHandler);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

