/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.artifact.impl;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.JpsArtifactType;
import org.jetbrains.jps.model.artifact.elements.JpsArchivePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.impl.JpsArtifactReferenceImpl;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;

public class JpsArtifactImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsArtifactImpl<P>>
implements JpsArtifact {
    private static final JpsElementChildRole<JpsCompositePackagingElement> ROOT_ELEMENT_CHILD_ROLE = JpsElementChildRoleBase.create((String)"root element");
    private final JpsArtifactType<P> myArtifactType;
    private String myOutputPath;
    private boolean myBuildOnMake;

    public JpsArtifactImpl(@NotNull String name, @NotNull JpsCompositePackagingElement rootElement, @NotNull JpsArtifactType<P> type, @NotNull P properties) {
        if (name == null) {
            JpsArtifactImpl.$$$reportNull$$$0(0);
        }
        if (rootElement == null) {
            JpsArtifactImpl.$$$reportNull$$$0(1);
        }
        if (type == null) {
            JpsArtifactImpl.$$$reportNull$$$0(2);
        }
        if (properties == null) {
            JpsArtifactImpl.$$$reportNull$$$0(3);
        }
        super(name);
        this.myArtifactType = type;
        this.myContainer.setChild(ROOT_ELEMENT_CHILD_ROLE, (JpsElement)rootElement);
        this.myContainer.setChild(type.getPropertiesRole(), properties);
    }

    private JpsArtifactImpl(JpsArtifactImpl<P> original) {
        super(original);
        this.myArtifactType = original.myArtifactType;
        this.myOutputPath = original.myOutputPath;
    }

    @NotNull
    public JpsArtifactImpl<P> createCopy() {
        return new JpsArtifactImpl<P>(this);
    }

    public String getOutputPath() {
        return this.myOutputPath;
    }

    public void setOutputPath(@Nullable String outputPath) {
        if (!Objects.equals(this.myOutputPath, outputPath)) {
            this.myOutputPath = outputPath;
            this.fireElementChanged();
        }
    }

    @Nullable
    public String getOutputFilePath() {
        if (StringUtil.isEmpty((String)this.myOutputPath)) {
            return null;
        }
        JpsCompositePackagingElement root = this.getRootElement();
        return root instanceof JpsArchivePackagingElement ? this.myOutputPath + "/" + ((JpsArchivePackagingElement)root).getArchiveName() : this.myOutputPath;
    }

    @NotNull
    public JpsArtifactType<P> getArtifactType() {
        JpsArtifactType<P> jpsArtifactType = this.myArtifactType;
        if (jpsArtifactType == null) {
            JpsArtifactImpl.$$$reportNull$$$0(4);
        }
        return jpsArtifactType;
    }

    @NotNull
    public JpsArtifactReferenceImpl createReference() {
        return new JpsArtifactReferenceImpl(this.getName());
    }

    @NotNull
    public JpsCompositePackagingElement getRootElement() {
        JpsCompositePackagingElement jpsCompositePackagingElement = (JpsCompositePackagingElement)this.myContainer.getChild(ROOT_ELEMENT_CHILD_ROLE);
        if (jpsCompositePackagingElement == null) {
            JpsArtifactImpl.$$$reportNull$$$0(5);
        }
        return jpsCompositePackagingElement;
    }

    public void setRootElement(@NotNull JpsCompositePackagingElement rootElement) {
        if (rootElement == null) {
            JpsArtifactImpl.$$$reportNull$$$0(6);
        }
        this.myContainer.setChild(ROOT_ELEMENT_CHILD_ROLE, (JpsElement)rootElement);
    }

    public P getProperties() {
        return (P)this.myContainer.getChild(this.myArtifactType.getPropertiesRole());
    }

    public boolean isBuildOnMake() {
        return this.myBuildOnMake;
    }

    public void setBuildOnMake(boolean buildOnMake) {
        if (this.myBuildOnMake != buildOnMake) {
            this.myBuildOnMake = buildOnMake;
            this.fireElementChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/artifact/impl/JpsArtifactImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/artifact/impl/JpsArtifactImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setRootElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

