/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.NettyKt;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\r"}, d2={"isTrustedOrigin", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "writeAboutJson", "", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "writeApplicationInfoJson", "out", "Ljava/io/OutputStream;", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "intellij.platform.builtInServer.impl"})
public final class AboutHttpServiceKt {
    private static final boolean isTrustedOrigin(HttpRequest request) {
        String string = NettyKt.getOrigin((HttpRequest)request);
        if (string == null) {
            return false;
        }
        String origin = string;
        CharSequence charSequence = origin;
        String string2 = "https?://([a-z0-9-]+\\.)*hyperskill.org$";
        boolean bl = false;
        string2 = new Regex(string2);
        bl = false;
        return string2.matches(charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeApplicationInfoJson(@NotNull OutputStream out, @Nullable QueryStringDecoder urlDecoder) {
        JsonGenerator writer;
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        JsonGenerator jsonGenerator = writer = new JsonFactory().createGenerator(out).useDefaultPrettyPrinter();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonGenerator, (String)"writer");
        JsonGenerator $this$obj$iv = jsonGenerator;
        String fieldName$iv = null;
        boolean $i$f$obj = false;
        $this$obj$iv.writeStartObject();
        boolean bl = false;
        AboutHttpServiceKt.writeAboutJson(writer);
        if (urlDecoder != null && RestService.Companion.getBooleanParameter$default(RestService.Companion, "registeredFileTypes", urlDecoder, false, 4, null)) {
            void $this$array$iv;
            JsonGenerator jsonGenerator2 = writer;
            String fieldName$iv2 = "registeredFileTypes";
            boolean $i$f$array = false;
            String string = fieldName$iv2;
            boolean bl2 = false;
            boolean bl3 = false;
            String it$iv = string;
            boolean bl4 = false;
            $this$array$iv.writeFieldName(it$iv);
            $this$array$iv.writeStartArray();
            boolean bl5 = false;
            FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTypeRegistry, (String)"FileTypeRegistry.getInstance()");
            for (FileType fileType : fileTypeRegistry.getRegisteredFileTypes()) {
                JsonGenerator $this$obj$iv2 = writer;
                String fieldName$iv3 = null;
                boolean $i$f$obj2 = false;
                $this$obj$iv2.writeStartObject();
                boolean bl6 = false;
                FileType fileType2 = fileType;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileType2, (String)"fileType");
                writer.writeStringField("name", fileType2.getName());
                writer.writeStringField("description", fileType.getDescription());
                writer.writeBooleanField("isBinary", fileType.isBinary());
                $this$obj$iv2.writeEndObject();
            }
            $this$array$iv.writeEndArray();
        }
        if (urlDecoder != null && RestService.Companion.getBooleanParameter$default(RestService.Companion, "more", urlDecoder, false, 4, null)) {
            ApplicationInfoEx appInfo;
            ApplicationInfoEx applicationInfoEx = appInfo = ApplicationInfoEx.getInstanceEx();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfoEx, (String)"appInfo");
            writer.writeStringField("vendor", applicationInfoEx.getCompanyName());
            writer.writeBooleanField("isEAP", appInfo.isEAP());
            BuildNumber buildNumber = appInfo.getBuild();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"appInfo.build");
            writer.writeStringField("productCode", buildNumber.getProductCode());
            Calendar calendar = appInfo.getBuildDate();
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"appInfo.buildDate");
            Date date = calendar.getTime();
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"appInfo.buildDate.time");
            writer.writeNumberField("buildDate", date.getTime());
            BuildNumber buildNumber2 = appInfo.getBuild();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber2, (String)"appInfo.build");
            writer.writeBooleanField("isSnapshot", buildNumber2.isSnapshot());
            writer.writeStringField("configPath", PathManager.getConfigPath());
            writer.writeStringField("systemPath", PathManager.getSystemPath());
            writer.writeStringField("binPath", PathManager.getBinPath());
            writer.writeStringField("logPath", PathManager.getLogPath());
            writer.writeStringField("homePath", PathManager.getHomePath());
        }
        $this$obj$iv.writeEndObject();
        writer.close();
    }

    public static final void writeAboutJson(@NotNull JsonGenerator writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfoEx, (String)"ApplicationInfoEx.getInstanceEx()");
        String appName = applicationInfoEx.getFullApplicationName();
        if (!PlatformUtils.isIdeaUltimate()) {
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
            String productName = applicationNamesInfo.getProductName();
            String string = appName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"appName");
            String string2 = productName + " (" + productName + ')';
            String string3 = productName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"productName");
            appName = StringsKt.removePrefix((String)StringsKt.replace$default((String)string, (String)string2, (String)string3, (boolean)false, (int)4, null), (CharSequence)"JetBrains ");
        }
        writer.writeStringField("name", appName);
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        writer.writeStringField("productName", applicationNamesInfo.getProductName());
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        BuildNumber build = buildNumber;
        writer.writeNumberField("baselineVersion", build.getBaselineVersion());
        if (!build.isSnapshot()) {
            writer.writeStringField("buildNumber", build.asStringWithoutProductCode());
        }
    }

    public static final /* synthetic */ boolean access$isTrustedOrigin(HttpRequest request) {
        return AboutHttpServiceKt.isTrustedOrigin(request);
    }
}

