/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.fragments;

import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.util.Comparing;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class LineBlock {
    private final int myStartingLine1;
    private final int myModifiedLines1;
    private final int myStartingLine2;
    private final int myModifiedLines2;
    private TextDiffTypeEnum myType;
    public static final Comparator<LineBlock> COMPARATOR = (block1, block2) -> Comparing.compare(block1.getStartingLine1(), block2.getStartingLine1());

    public LineBlock(int startingLine1, int modifiedLines1, int startingLine2, int modifiedLines2, TextDiffTypeEnum blockType) {
        this.myStartingLine1 = startingLine1;
        this.myModifiedLines1 = modifiedLines1;
        this.myStartingLine2 = startingLine2;
        this.myModifiedLines2 = modifiedLines2;
        this.myType = blockType;
    }

    public int getModifiedLines1() {
        return this.myModifiedLines1;
    }

    public int getStartingLine1() {
        return this.myStartingLine1;
    }

    public int getStartingLine2() {
        return this.myStartingLine2;
    }

    public int getModifiedLines2() {
        return this.myModifiedLines2;
    }

    protected int getEndLine1() {
        return this.myStartingLine1 + this.myModifiedLines1;
    }

    protected int getEndLine2() {
        return this.myStartingLine2 + this.myModifiedLines2;
    }

    public TextDiffTypeEnum getType() {
        return this.myType;
    }

    protected void setType(@NotNull TextDiffTypeEnum type) {
        if (type == null) {
            LineBlock.$$$reportNull$$$0(0);
        }
        this.myType = type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/diff/impl/fragments/LineBlock", "setType"));
    }
}

