/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.NSTLibrary;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.ui.mac.touchbar.TouchBarStats;
import com.sun.jna.Pointer;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TBItemButton
extends TBItem {
    @Nullable
    protected final TouchBarStats.AnActionStats myActionStats;
    @Nullable
    protected Icon myOriginIcon;
    @Nullable
    protected String myText;
    protected int myLayoutBits = 0;
    protected int myFlags = 0;
    protected boolean myHasArrowIcon = false;
    protected int myUpdateOptions;
    protected boolean myIsDisabled = false;
    private boolean myNeedGetDisabledIcon = false;
    @Nullable
    private Runnable myAction;
    @Nullable
    private NSTLibrary.Action myNativeCallback;

    TBItemButton(@Nullable ItemListener listener2, @Nullable TouchBarStats.AnActionStats actionStats) {
        super("button", listener2);
        this.myActionStats = actionStats;
    }

    @Nullable
    private Icon getDarkIcon(@Nullable Icon icon2) {
        if (icon2 == null) {
            return null;
        }
        long startNs = this.myActionStats != null ? System.nanoTime() : 0L;
        icon2 = IconLoader.getDarkIcon((Icon)icon2, (boolean)true);
        if (this.myActionStats != null) {
            this.myActionStats.iconGetDarkDurationNs += System.nanoTime() - startNs;
        }
        return icon2;
    }

    TBItemButton setIcon(Icon icon2, boolean needGetDisabled) {
        if (!Objects.equals(icon2, this.myOriginIcon) || this.myNeedGetDisabledIcon != needGetDisabled) {
            this.myOriginIcon = icon2;
            this.myNeedGetDisabledIcon = needGetDisabled;
            this.myUpdateOptions |= 8;
        }
        return this;
    }

    TBItemButton setIcon(Icon icon2) {
        if (!Objects.equals(icon2, this.myOriginIcon) || this.myNeedGetDisabledIcon) {
            this.myOriginIcon = icon2;
            this.myNeedGetDisabledIcon = false;
            this.myUpdateOptions |= 8;
        }
        return this;
    }

    TBItemButton setHasArrowIcon(boolean hasArrowIcon) {
        if (hasArrowIcon != this.myHasArrowIcon) {
            this.myHasArrowIcon = hasArrowIcon;
            if (this.myNativePeer != ID.NIL) {
                Icon ic2 = this.myHasArrowIcon ? IconLoader.getIcon((String)"/mac/touchbar/popoverArrow_dark.svg") : null;
                NST.setArrowImage(this.myNativePeer, ic2);
            }
        }
        return this;
    }

    TBItemButton setText(String text) {
        if (!Objects.equals(text, this.myText)) {
            this.myText = text;
            this.myUpdateOptions |= 4;
        }
        return this;
    }

    TBItemButton setAction(Runnable action2, boolean executeOnEDT, ModalityState modality) {
        if (action2 != this.myAction) {
            this.myAction = action2;
            this.myNativeCallback = this.myAction == null ? null : () -> {
                if (executeOnEDT) {
                    @NotNull Application app = ApplicationManager.getApplication();
                    if (modality != null) {
                        app.invokeLater(this.myAction, modality);
                    } else {
                        app.invokeLater(this.myAction);
                    }
                } else {
                    this.myAction.run();
                }
                if (this.myListener != null) {
                    this.myListener.onItemEvent(this, 0);
                }
            };
            this.myUpdateOptions |= 0x10;
        }
        return this;
    }

    TBItemButton setWidth(int width) {
        return this.setLayout(width, 0, 2, 8);
    }

    TBItemButton setLayout(int width, int widthFlags, int margin, int border) {
        if (width < 0) {
            width = 0;
        }
        if (margin < 0) {
            margin = 0;
        }
        if (border < 0) {
            border = 0;
        }
        int newLayout = width & 0xFFF;
        newLayout |= widthFlags;
        newLayout |= NSTLibrary.margin2mask((byte)margin);
        if (this.myLayoutBits != (newLayout |= NSTLibrary.border2mask((byte)border))) {
            this.myLayoutBits = newLayout;
            this.myUpdateOptions |= 1;
        }
        return this;
    }

    TBItemButton setPriority(byte prio) {
        int flags = this.myFlags | NSTLibrary.priority2mask(prio);
        if (flags != this.myFlags) {
            this.myFlags = flags;
            this.myUpdateOptions |= 2;
        }
        return this;
    }

    TBItemButton setToggle(boolean toggle) {
        int flags = TBItemButton._applyFlag(this.myFlags, toggle, 8);
        if (flags != this.myFlags) {
            this.myFlags = flags;
            this.myUpdateOptions |= 2;
        }
        return this;
    }

    TBItemButton setColored(boolean isColored) {
        int flags = TBItemButton._applyFlag(this.myFlags, isColored, 4);
        if (flags != this.myFlags) {
            this.myFlags = flags;
            this.myUpdateOptions |= 2;
        }
        return this;
    }

    TBItemButton setSelected(boolean isSelected) {
        int flags = TBItemButton._applyFlag(this.myFlags, isSelected, 2);
        if (flags != this.myFlags) {
            this.myFlags = flags;
            this.myUpdateOptions |= 2;
        }
        return this;
    }

    TBItemButton setDisabled(boolean isDisabled) {
        this.myIsDisabled = isDisabled;
        int flags = TBItemButton._applyFlag(this.myFlags, isDisabled, 1);
        if (flags != this.myFlags) {
            this.myFlags = flags;
            this.myUpdateOptions |= 2;
        }
        return this;
    }

    TBItemButton setTransparentBg(boolean isTransparentBg) {
        int flags = TBItemButton._applyFlag(this.myFlags, isTransparentBg, 16);
        if (flags != this.myFlags) {
            this.myFlags = flags;
            this.myUpdateOptions |= 2;
        }
        return this;
    }

    @Nullable
    Updater getNativePeerUpdater() {
        if (!this.myIsVisible || this.myUpdateOptions == 0 || this.myNativePeer == ID.NIL) {
            return null;
        }
        return new Updater();
    }

    @Override
    protected ID _createNativePeer() {
        Icon icon2 = null;
        if (this.myOriginIcon != null) {
            icon2 = (Icon)ApplicationManager.getApplication().runReadAction(() -> this.getDarkIcon(this.myOriginIcon));
        }
        ID result2 = NST.createButton(this.getUid(), this.myLayoutBits, this._validateFlags(), this.myText, icon2, this.myNativeCallback);
        if (this.myHasArrowIcon) {
            Icon ic2 = IconLoader.getIcon((String)"/mac/touchbar/popoverArrow_dark.svg");
            NST.setArrowImage(result2, ic2);
        }
        return result2;
    }

    private int _validateFlags() {
        int flags = this.myFlags;
        if ((flags & 4) != 0 && (flags & 1) != 0) {
            return flags & 0xFFFFFFFB;
        }
        return flags;
    }

    private static int _applyFlag(int src, boolean include, int flag) {
        return include ? src | flag : src & ~flag;
    }

    class Updater {
        private Pair<Pointer, Dimension> myRaster = null;

        Updater() {
        }

        void prepareUpdateData() {
            long startNs;
            long l = startNs = TBItemButton.this.myActionStats != null ? System.nanoTime() : 0L;
            Icon icon2 = TBItemButton.this.myOriginIcon == null || (TBItemButton.this.myUpdateOptions & 8) == 0 ? null : (TBItemButton.this.myNeedGetDisabledIcon ? IconLoader.getDisabledIcon((Icon)TBItemButton.this.getDarkIcon(TBItemButton.this.myOriginIcon)) : TBItemButton.this.getDarkIcon(TBItemButton.this.myOriginIcon));
            this.myRaster = NST.get4ByteRGBARaster(icon2);
            if (TBItemButton.this.myActionStats != null && this.myRaster != null) {
                ++TBItemButton.this.myActionStats.iconUpdateIconRasterCount;
                TBItemButton.this.myActionStats.iconRenderingDurationNs += System.nanoTime() - startNs;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateNativePeer() {
            Object object = TBItemButton.this.myReleaseLock;
            synchronized (object) {
                if (TBItemButton.this.myNativePeer.equals((Object)ID.NIL)) {
                    return;
                }
                String text = (TBItemButton.this.myUpdateOptions & 4) != 0 ? TBItemButton.this.myText : null;
                NSTLibrary.Action callback2 = (TBItemButton.this.myUpdateOptions & 0x10) != 0 ? TBItemButton.this.myNativeCallback : null;
                int validFlags = TBItemButton.this._validateFlags();
                NST.updateButton(TBItemButton.this.myNativePeer, TBItemButton.this.myUpdateOptions, TBItemButton.this.myLayoutBits, validFlags, text, this.myRaster, callback2);
                TBItemButton.this.myUpdateOptions = 0;
            }
        }
    }
}

