/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.remoteServer.impl.runtime.ServerConnectionImpl;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionListener;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;

public class ServerConnectionEventDispatcher {
    private final MessageBus myMessageBus = ApplicationManager.getApplication().getMessageBus();
    private final MergingUpdateQueue myEventsQueue = new MergingUpdateQueue("remote server connection events", 500, false, null);
    private static final int DEPLOYMENTS_PRIORITY = 999;
    private static final int CONNECTION_STATUS_PRIORITY = 10;

    public void fireConnectionCreated(ServerConnection<?> connection) {
        ((ServerConnectionListener)this.myMessageBus.syncPublisher(ServerConnectionListener.TOPIC)).onConnectionCreated(connection);
    }

    public void queueConnectionStatusChanged(final ServerConnectionImpl<?> connection) {
        this.myEventsQueue.activate();
        this.myEventsQueue.queue(new Update(connection, 10){

            public void run() {
                ((ServerConnectionListener)ServerConnectionEventDispatcher.this.myMessageBus.syncPublisher(ServerConnectionListener.TOPIC)).onConnectionStatusChanged((ServerConnection)connection);
            }
        });
    }

    public void queueDeploymentsChanged(final ServerConnectionImpl<?> connection) {
        this.myEventsQueue.activate();
        this.myEventsQueue.queue(new Update(connection, 999){

            public void run() {
                ((ServerConnectionListener)ServerConnectionEventDispatcher.this.myMessageBus.syncPublisher(ServerConnectionListener.TOPIC)).onDeploymentsChanged((ServerConnection)connection);
            }
        });
    }
}

