/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vfs.impl.local.WatchRootsUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class CanonicalPathMap {
    private final NavigableSet<String> myOptimizedRecursiveWatchRoots;
    private final NavigableSet<String> myOptimizedFlatWatchRoots;
    private Collection<Pair<String, String>> myInitialPathMappings;
    private final MultiMap<String, String> myPathMappings;

    static CanonicalPathMap empty() {
        return new CanonicalPathMap(Collections.emptyNavigableSet(), Collections.emptyNavigableSet(), Collections.emptyNavigableSet());
    }

    CanonicalPathMap(@NotNull NavigableSet<String> optimizedRecursiveWatchRoots, @NotNull NavigableSet<String> optimizedFlatWatchRoots, @NotNull Collection<Pair<String, String>> initialPathMappings) {
        if (optimizedRecursiveWatchRoots == null) {
            CanonicalPathMap.$$$reportNull$$$0(0);
        }
        if (optimizedFlatWatchRoots == null) {
            CanonicalPathMap.$$$reportNull$$$0(1);
        }
        if (initialPathMappings == null) {
            CanonicalPathMap.$$$reportNull$$$0(2);
        }
        this.myOptimizedRecursiveWatchRoots = optimizedRecursiveWatchRoots;
        this.myOptimizedFlatWatchRoots = optimizedFlatWatchRoots;
        this.myInitialPathMappings = initialPathMappings;
        this.myPathMappings = MultiMap.createConcurrentSet();
    }

    @NotNull
    Pair<List<String>, List<String>> getCanonicalWatchRoots() {
        this.initializeMappings();
        ConcurrentHashMap canonicalPathMappings = new ConcurrentHashMap();
        ((Stream)Stream.concat(this.myOptimizedRecursiveWatchRoots.stream(), this.myOptimizedFlatWatchRoots.stream()).parallel()).forEach(root -> {
            String canonicalRoot = FileSystemUtil.resolveSymLink((String)root);
            if (canonicalRoot != null && OSAgnosticPathUtil.COMPARATOR.compare(canonicalRoot, root) != 0) {
                canonicalPathMappings.put(root, canonicalRoot);
            }
        });
        NavigableSet<String> canonicalRecursiveRoots = WatchRootsUtil.createFileNavigableSet();
        for (String root2 : this.myOptimizedRecursiveWatchRoots) {
            String canonical = (String)canonicalPathMappings.get(root2);
            if (canonical != null) {
                this.myPathMappings.putValue((Object)canonical, (Object)root2);
            } else {
                canonical = root2;
            }
            WatchRootsUtil.insertRecursivePath(canonicalRecursiveRoots, canonical);
        }
        HashSet<String> canonicalFlatRoots = new HashSet<String>();
        for (String root3 : this.myOptimizedFlatWatchRoots) {
            String canonical = (String)canonicalPathMappings.get(root3);
            if (canonical != null) {
                this.myPathMappings.putValue((Object)canonical, (Object)root3);
            } else {
                canonical = root3;
            }
            if (WatchRootsUtil.isCoveredRecursively(canonicalRecursiveRoots, canonical)) continue;
            canonicalFlatRoots.add(canonical);
        }
        Pair pair = Pair.pair(new ArrayList<String>(canonicalRecursiveRoots), new ArrayList(canonicalFlatRoots));
        if (pair == null) {
            CanonicalPathMap.$$$reportNull$$$0(3);
        }
        return pair;
    }

    private void initializeMappings() {
        String lastMapping = "";
        Collection lastCollection = null;
        for (Pair<String, String> mapping2 : this.myInitialPathMappings) {
            String currentMapping = (String)mapping2.first;
            if (!currentMapping.equals(lastMapping) || lastCollection == null) {
                lastMapping = (String)mapping2.first;
                lastCollection = this.myPathMappings.getModifiable((Object)lastMapping);
            }
            lastCollection.add((String)mapping2.second);
        }
        this.myInitialPathMappings = null;
    }

    void addMapping(@NotNull Collection<? extends Pair<String, String>> mapping2) {
        if (mapping2 == null) {
            CanonicalPathMap.$$$reportNull$$$0(4);
        }
        for (Pair<String, String> pair : mapping2) {
            String from = (String)pair.first;
            String to = (String)pair.second;
            Collection<String> preRemapPathToWatchedPaths = this.applyMapping(to);
            for (String realWatchedPath : preRemapPathToWatchedPaths) {
                this.myPathMappings.putValue((Object)from, (Object)realWatchedPath);
            }
            this.myPathMappings.putValue((Object)from, (Object)to);
        }
    }

    boolean belongsToWatchRoots(@NotNull String reportedPath, boolean isFile) {
        if (reportedPath == null) {
            CanonicalPathMap.$$$reportNull$$$0(5);
        }
        return WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, reportedPath) || this.myOptimizedFlatWatchRoots.contains(reportedPath) || isFile && this.myOptimizedFlatWatchRoots.contains(PathUtil.getParentPath((String)reportedPath));
    }

    @NotNull
    Collection<String> mapToOriginalWatchRoots(@NotNull String reportedPath, boolean isExact) {
        if (reportedPath == null) {
            CanonicalPathMap.$$$reportNull$$$0(6);
        }
        if (this.myOptimizedFlatWatchRoots.isEmpty() && this.myOptimizedRecursiveWatchRoots.isEmpty()) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                CanonicalPathMap.$$$reportNull$$$0(7);
            }
            return list2;
        }
        Collection<String> affectedPaths = this.applyMapping(reportedPath);
        HashSet<String> changedPaths = new HashSet<String>();
        for (String affectedPath : affectedPaths) {
            if (WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, affectedPath) || this.myOptimizedFlatWatchRoots.contains(affectedPath) || isExact && this.myOptimizedFlatWatchRoots.contains(PathUtil.getParentPath((String)affectedPath))) {
                changedPaths.add(affectedPath);
                continue;
            }
            if (isExact) continue;
            CanonicalPathMap.addPrefixedPaths(this.myOptimizedRecursiveWatchRoots, affectedPath, changedPaths);
            CanonicalPathMap.addPrefixedPaths(this.myOptimizedFlatWatchRoots, affectedPath, changedPaths);
        }
        HashSet<String> hashSet = changedPaths;
        if (hashSet == null) {
            CanonicalPathMap.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    private Collection<String> applyMapping(String reportedPath) {
        if (this.myPathMappings.isEmpty()) {
            return Collections.singletonList(reportedPath);
        }
        SmartList results = new SmartList((Object)reportedPath);
        WatchRootsUtil.forEachPathSegment(reportedPath, File.separatorChar, arg_0 -> this.lambda$applyMapping$1((List)results, reportedPath, arg_0));
        return results;
    }

    private static void addPrefixedPaths(NavigableSet<String> paths, String prefix, Collection<String> result2) {
        String possibleRoot = paths.ceiling(prefix);
        if (possibleRoot != null && FileUtil.startsWith((String)possibleRoot, (String)prefix)) {
            for (String root : paths.tailSet(prefix, false)) {
                if (FileUtil.startsWith((String)root, (String)prefix)) {
                    result2.add(root);
                    continue;
                }
                return;
            }
        }
    }

    private /* synthetic */ boolean lambda$applyMapping$1(List results, String reportedPath, String path) {
        Collection mappedPaths = this.myPathMappings.get((Object)path);
        for (String mappedPath : mappedPaths) {
            results.add(mappedPath + reportedPath.substring(path.length()));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optimizedRecursiveWatchRoots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optimizedFlatWatchRoots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialPathMappings";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/CanonicalPathMap";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportedPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/CanonicalPathMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalWatchRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToOriginalWatchRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addMapping";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "belongsToWatchRoots";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mapToOriginalWatchRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

