/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.FeatureImpl;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiserDialog;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginsAdvertiser {
    static final Logger LOG = Logger.getInstance(PluginsAdvertiser.class);
    private static final String CASHED_EXTENSIONS = "extensions.xml";
    public static final String IGNORE_ULTIMATE_EDITION = "ignoreUltimateEdition";
    public static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Plugins Suggestion", NotificationDisplayType.STICKY_BALLOON, true);
    public static final String FUS_GROUP_ID = "plugins.advertiser";
    private static SoftReference<KnownExtensions> ourKnownExtensions = new SoftReference(null);
    private static boolean extensionsHaveBeenUpdated = false;

    @NotNull
    public static List<Plugin> retrieve(@NotNull UnknownFeature unknownFeature) {
        if (unknownFeature == null) {
            PluginsAdvertiser.$$$reportNull$$$0(0);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("featureType", unknownFeature.getFeatureType());
        params.put("implementationName", unknownFeature.getImplementationName());
        params.put("build", MarketplaceRequests.getInstance().getBuildForPluginRepositoryRequests());
        List<FeatureImpl> features = MarketplaceRequests.getInstance().getFeatures(params);
        List list2 = ContainerUtil.map(features, feature -> new Plugin(feature.getPluginId() != null ? StringUtil.unquoteString((String)feature.getPluginId()) : null, feature.getPluginName() != null ? StringUtil.unquoteString((String)feature.getPluginName()) : null, feature.getBundled()));
        if (list2 == null) {
            PluginsAdvertiser.$$$reportNull$$$0(1);
        }
        return list2;
    }

    static void loadAllExtensions(Set<String> customPluginIds) throws IOException {
        Map<String, String> params = Collections.singletonMap("featureType", FileTypeFactory.FILE_TYPE_FACTORY_EP.getName());
        List<FeatureImpl> features = MarketplaceRequests.getInstance().getFeatures(params);
        Map<String, Set<Plugin>> setExtensions = features.stream().collect(Collectors.groupingBy(FeatureImpl::getImplementationName, Collectors.mapping(feature -> new Plugin(feature.getPluginId() != null ? StringUtil.unquoteString((String)feature.getPluginId()) : null, feature.getPluginName() != null ? StringUtil.unquoteString((String)feature.getPluginName()) : null, feature.getBundled(), customPluginIds.contains(feature.getPluginId())), Collectors.toSet())));
        PluginsAdvertiser.saveExtensions(setExtensions);
    }

    static void ensureDeleted() {
        FileUtil.delete((File)PluginsAdvertiser.getExtensionsFile());
    }

    @Nullable
    public static KnownExtensions loadExtensions() {
        if (!extensionsHaveBeenUpdated) {
            return null;
        }
        KnownExtensions knownExtensions = (KnownExtensions)ourKnownExtensions.get();
        if (knownExtensions != null) {
            return knownExtensions;
        }
        try {
            File file2 = PluginsAdvertiser.getExtensionsFile();
            if (file2.isFile()) {
                knownExtensions = (KnownExtensions)XmlSerializer.deserialize((Element)JDOMUtil.load((File)file2), KnownExtensions.class);
                ourKnownExtensions = new SoftReference((Object)knownExtensions);
                return knownExtensions;
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    private static File getExtensionsFile() {
        return new File(PathManager.getPluginsPath(), CASHED_EXTENSIONS);
    }

    static void saveExtensions(Map<String, Set<Plugin>> extensions2) throws IOException {
        File plugins = PluginsAdvertiser.getExtensionsFile();
        if (!plugins.isFile()) {
            FileUtil.ensureCanCreateFile((File)plugins);
        }
        JDOMUtil.write((Element)XmlSerializer.serialize((Object)new KnownExtensions(extensions2)), (File)plugins);
        extensionsHaveBeenUpdated = true;
    }

    public static void openDownloadPage() {
        BrowserUtil.browse((String)IdeUrlTrackingParametersProvider.getInstance().augmentUrl("https://www.jetbrains.com/idea/download/"));
    }

    static void enablePlugins(Project project, Collection<IdeaPluginDescriptor> disabledPlugins) {
        PluginManagerConfigurable.showPluginConfigurableAndEnable(project, disabledPlugins.toArray(new IdeaPluginDescriptor[0]));
    }

    @Nullable
    static List<String> hasBundledPluginToInstall(Collection<? extends Plugin> plugins) {
        if (PlatformUtils.isIdeaUltimate()) {
            return null;
        }
        ArrayList<String> bundled = new ArrayList<String>();
        for (Plugin plugin : plugins) {
            if (!plugin.myBundled || PluginManagerCore.getPlugin(PluginId.getId((String)plugin.myPluginId)) != null) continue;
            bundled.add(plugin.myPluginName != null ? plugin.myPluginName : plugin.myPluginId);
        }
        return bundled.isEmpty() ? null : bundled;
    }

    @Deprecated
    public static void installAndEnablePlugins(@NotNull Set<String> pluginIds, @NotNull Runnable onSuccess2) {
        if (pluginIds == null) {
            PluginsAdvertiser.$$$reportNull$$$0(2);
        }
        if (onSuccess2 == null) {
            PluginsAdvertiser.$$$reportNull$$$0(3);
        }
        PluginsAdvertiser.installAndEnable(new LinkedHashSet<PluginId>(ContainerUtil.map(pluginIds, it -> PluginId.getId((String)it))), onSuccess2);
    }

    public static void installAndEnable(@NotNull Set<PluginId> pluginIds, @NotNull Runnable onSuccess2) {
        if (pluginIds == null) {
            PluginsAdvertiser.$$$reportNull$$$0(4);
        }
        if (onSuccess2 == null) {
            PluginsAdvertiser.$$$reportNull$$$0(5);
        }
        PluginsAdvertiser.installAndEnable(null, pluginIds, true, onSuccess2);
    }

    public static void installAndEnable(@Nullable Project project, final @NotNull Set<PluginId> pluginIds, final boolean showDialog, final @NotNull Runnable onSuccess2) {
        if (pluginIds == null) {
            PluginsAdvertiser.$$$reportNull$$$0(6);
        }
        if (onSuccess2 == null) {
            PluginsAdvertiser.$$$reportNull$$$0(7);
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(project, IdeBundle.message((String)"plugins.advertiser.task.searching.for.plugins", (Object[])new Object[0]), true){
            private final Set<PluginDownloader> myPlugins;
            private List<IdeaPluginDescriptor> myRepositoryPlugins;
            private List<IdeaPluginDescriptor> myCustomPlugins;
            {
                super(arg0, arg1, arg2);
                this.myPlugins = new HashSet<PluginDownloader>();
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    @NotNull List ids = ContainerUtil.map((Collection)pluginIds, id2 -> id2.getIdString());
                    List<PluginNode> marketplacePlugins = MarketplaceRequests.getInstance().loadLastCompatiblePluginDescriptors(ids);
                    this.myCustomPlugins = RepositoryHelper.loadPluginsFromCustomRepositories(indicator);
                    this.myRepositoryPlugins = UpdateChecker.mergePluginsFromRepositories(marketplacePlugins, this.myCustomPlugins);
                    for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                        if (descriptor2.isEnabled() || !pluginIds.contains(descriptor2.getPluginId()) || !PluginManagerCore.isCompatible(descriptor2)) continue;
                        this.myPlugins.add(PluginDownloader.createDownloader(descriptor2));
                    }
                    for (IdeaPluginDescriptor loadedPlugin : this.myRepositoryPlugins) {
                        if (!pluginIds.contains(loadedPlugin.getPluginId())) continue;
                        this.myPlugins.add(PluginDownloader.createDownloader(loadedPlugin));
                    }
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }

            public void onSuccess() {
                if (this.myRepositoryPlugins == null) {
                    return;
                }
                PluginsAdvertiserDialog advertiserDialog = new PluginsAdvertiserDialog(null, this.myPlugins.toArray(new PluginDownloader[0]), this.myCustomPlugins);
                if (showDialog) {
                    if (advertiserDialog.showAndGet()) {
                        onSuccess2.run();
                    }
                } else if (advertiserDialog.doInstallPlugins()) {
                    onSuccess2.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$1", "run"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unknownFeature";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "retrieve";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installAndEnablePlugins";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "installAndEnable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="plugin")
    public static class Plugin
    implements Comparable<Plugin> {
        public String myPluginId;
        public String myPluginName;
        public boolean myBundled;
        public boolean myFromCustomRepository;

        @Deprecated
        public Plugin(PluginId pluginId, String pluginName, boolean bundled) {
            this(pluginId.getIdString(), pluginName, bundled);
        }

        public Plugin(String pluginId, String pluginName, boolean bundled) {
            this.myPluginId = pluginId;
            this.myBundled = bundled;
            this.myPluginName = pluginName;
        }

        public Plugin(String pluginId, String pluginName, boolean bundled, boolean isFromCustomRepository) {
            this.myPluginId = pluginId;
            this.myPluginName = pluginName;
            this.myBundled = bundled;
            this.myFromCustomRepository = isFromCustomRepository;
        }

        public Plugin() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Plugin plugin = (Plugin)o;
            if (this.myBundled != plugin.myBundled) {
                return false;
            }
            if (!this.myPluginId.equals(plugin.myPluginId)) {
                return false;
            }
            return this.myPluginName == null || this.myPluginName.equals(plugin.myPluginName);
        }

        public int hashCode() {
            int result2 = this.myPluginId.hashCode();
            result2 = 31 * result2 + (this.myBundled ? 1 : 0);
            result2 = 31 * result2 + (this.myPluginName != null ? this.myPluginName.hashCode() : 0);
            return result2;
        }

        @Override
        public int compareTo(@NotNull Plugin other) {
            if (other == null) {
                Plugin.$$$reportNull$$$0(0);
            }
            if (this.myBundled && !other.myBundled) {
                return -1;
            }
            if (!this.myBundled && other.myBundled) {
                return 1;
            }
            return Comparing.compare((Comparable)((Object)this.myPluginId), (Comparable)((Object)other.myPluginId));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$Plugin", "compareTo"));
        }
    }

    @Tag(value="plugins")
    public static final class PluginSet {
        public final Set<Plugin> myPlugins = new HashSet<Plugin>();

        public PluginSet() {
        }

        public PluginSet(Set<? extends Plugin> plugins) {
            this.myPlugins.addAll(plugins);
        }
    }

    @Tag(value="exts")
    public static final class KnownExtensions {
        @OptionTag
        @XMap
        public final Map<String, PluginSet> myExtensions;

        public KnownExtensions() {
            this.myExtensions = new HashMap<String, PluginSet>();
        }

        public KnownExtensions(@NotNull Map<String, Set<Plugin>> extensions2) {
            if (extensions2 == null) {
                KnownExtensions.$$$reportNull$$$0(0);
            }
            this.myExtensions = new HashMap<String, PluginSet>();
            for (String ext : extensions2.keySet()) {
                this.myExtensions.put(ext, new PluginSet(extensions2.get(ext)));
            }
        }

        @Nullable
        public Set<Plugin> find(@NotNull String extension) {
            PluginSet pluginSet;
            if (extension == null) {
                KnownExtensions.$$$reportNull$$$0(1);
            }
            return (pluginSet = this.myExtensions.get(extension)) != null ? pluginSet.myPlugins : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$KnownExtensions";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "find";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

