/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.options.ConfigurableWithOptionDescriptors;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BeanConfigurable<T>
implements UnnamedConfigurable,
ConfigurableWithOptionDescriptors {
    private final T myInstance;
    private String myTitle;
    private final List<BeanField> myFields;

    protected BeanConfigurable(@NotNull T beanInstance) {
        if (beanInstance == null) {
            BeanConfigurable.$$$reportNull$$$0(0);
        }
        this.myFields = new ArrayList<BeanField>();
        this.myInstance = beanInstance;
    }

    protected BeanConfigurable(@NotNull T beanInstance, String title) {
        if (beanInstance == null) {
            BeanConfigurable.$$$reportNull$$$0(1);
        }
        this(beanInstance);
        this.setTitle(title);
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    protected void setTitle(String title) {
        this.myTitle = title;
    }

    @Nullable
    protected T getInstance() {
        return this.myInstance;
    }

    @Deprecated
    protected void checkBox(@NonNls String fieldName, String title) {
        this.myFields.add(new CheckboxField(fieldName, title));
    }

    protected void checkBox(@NlsContexts.Checkbox @NotNull String title, @NotNull Getter<Boolean> getter, @NotNull Setter<Boolean> setter) {
        if (title == null) {
            BeanConfigurable.$$$reportNull$$$0(2);
        }
        if (getter == null) {
            BeanConfigurable.$$$reportNull$$$0(3);
        }
        if (setter == null) {
            BeanConfigurable.$$$reportNull$$$0(4);
        }
        CheckboxField field = new CheckboxField(new BeanMethodAccessor(getter, setter), title);
        this.myFields.add(field);
    }

    protected void checkBox(@NlsContexts.Checkbox @NotNull String title, @NotNull KMutableProperty0<Boolean> prop) {
        if (title == null) {
            BeanConfigurable.$$$reportNull$$$0(5);
        }
        if (prop == null) {
            BeanConfigurable.$$$reportNull$$$0(6);
        }
        this.myFields.add(new CheckboxField(new BeanKPropertyAccessor(prop), title));
    }

    protected <V> void component(final @NotNull JComponent component2, @NotNull Getter<? extends V> beanGetter, @NotNull Setter<? super V> beanSetter, final @NotNull Getter<? extends V> componentGetter, final @NotNull Setter<? super V> componentSetter) {
        if (component2 == null) {
            BeanConfigurable.$$$reportNull$$$0(7);
        }
        if (beanGetter == null) {
            BeanConfigurable.$$$reportNull$$$0(8);
        }
        if (beanSetter == null) {
            BeanConfigurable.$$$reportNull$$$0(9);
        }
        if (componentGetter == null) {
            BeanConfigurable.$$$reportNull$$$0(10);
        }
        if (componentSetter == null) {
            BeanConfigurable.$$$reportNull$$$0(11);
        }
        BeanField<JComponent> field = new BeanField<JComponent>(new BeanMethodAccessor(beanGetter, beanSetter)){

            @Override
            @NotNull
            JComponent createComponent() {
                JComponent jComponent = component2;
                if (jComponent == null) {
                    1.$$$reportNull$$$0(0);
                }
                return jComponent;
            }

            @Override
            Object getComponentValue() {
                return componentGetter.get();
            }

            @Override
            void setComponentValue(Object value2) {
                componentSetter.set(value2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/BeanConfigurable$1", "createComponent"));
            }
        };
        this.myFields.add(field);
    }

    @NotNull
    public List<OptionDescription> getOptionDescriptors(@NotNull String configurableId, @NotNull Function<? super String, String> nameConverter) {
        if (configurableId == null) {
            BeanConfigurable.$$$reportNull$$$0(12);
        }
        if (nameConverter == null) {
            BeanConfigurable.$$$reportNull$$$0(13);
        }
        List boxes = JBIterable.from(this.myFields).filter(CheckboxField.class).toList();
        T instance = this.getInstance();
        List list2 = ContainerUtil.map((Collection)boxes, box -> new BooleanOptionDescription((String)nameConverter.apply(((CheckboxField)box).getTitle()), configurableId, (CheckboxField)box, instance){
            final /* synthetic */ CheckboxField val$box;
            final /* synthetic */ Object val$instance;
            {
                this.val$box = checkboxField;
                this.val$instance = object;
                super(arg0, arg1);
            }

            public boolean isOptionEnabled() {
                return this.val$box.getValue(this.val$instance);
            }

            public void setOptionState(boolean enabled) {
                this.val$box.setValue(this.val$instance, enabled);
            }
        });
        if (list2 == null) {
            BeanConfigurable.$$$reportNull$$$0(14);
        }
        return list2;
    }

    public JComponent createComponent() {
        JPanel panel2 = new JPanel(new GridLayout(this.myFields.size(), 1, 0, JBUI.scale((int)5)));
        for (BeanField field : this.myFields) {
            panel2.add((Component)field.getComponent());
        }
        BorderLayoutPanel result2 = JBUI.Panels.simplePanel().addToTop((Component)panel2);
        if (this.myTitle != null) {
            result2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.myTitle));
        }
        return result2;
    }

    public boolean isModified() {
        for (BeanField field : this.myFields) {
            if (!field.isModified(this.myInstance)) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (BeanField field : this.myFields) {
            field.apply(this.myInstance);
        }
    }

    public void reset() {
        for (BeanField field : this.myFields) {
            field.reset(this.myInstance);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanInstance";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanGetter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanSetter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentGetter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentSetter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameConverter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/BeanConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/BeanConfigurable";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkBox";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "component";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOptionDescriptors";
                break;
            }
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CheckboxField
    extends BeanField<JCheckBox> {
        private final String myTitle;

        private CheckboxField(String fieldName, String title) {
            super(new BeanFieldAccessor(fieldName, Boolean.TYPE));
            this.myTitle = title;
        }

        private CheckboxField(BeanPropertyAccessor accessor, String title) {
            super(accessor);
            this.myTitle = title;
        }

        private String getTitle() {
            return this.myTitle;
        }

        private void setValue(Object settingsInstance, boolean value2) {
            this.myAccessor.setBeanValue(settingsInstance, value2);
        }

        private boolean getValue(Object settingsInstance) {
            return (Boolean)this.myAccessor.getBeanValue(settingsInstance);
        }

        @Override
        @NotNull
        JCheckBox createComponent() {
            return new JCheckBox(this.myTitle);
        }

        @Override
        Object getComponentValue() {
            return ((JCheckBox)this.getComponent()).isSelected();
        }

        @Override
        void setComponentValue(Object value2) {
            ((JCheckBox)this.getComponent()).setSelected((Boolean)value2);
        }
    }

    private static abstract class BeanField<T extends JComponent> {
        BeanPropertyAccessor myAccessor;
        T myComponent;

        private BeanField(BeanPropertyAccessor accessor) {
            this.myAccessor = accessor;
        }

        T getComponent() {
            if (this.myComponent == null) {
                this.myComponent = this.createComponent();
            }
            return this.myComponent;
        }

        @NotNull
        abstract T createComponent();

        boolean isModified(Object instance) {
            Object beanValue;
            Object componentValue = this.getComponentValue();
            return !Comparing.equal((Object)componentValue, (Object)(beanValue = this.myAccessor.getBeanValue(instance)));
        }

        void apply(Object instance) {
            this.myAccessor.setBeanValue(instance, this.getComponentValue());
        }

        void reset(Object instance) {
            this.setComponentValue(this.myAccessor.getBeanValue(instance));
        }

        abstract Object getComponentValue();

        abstract void setComponentValue(Object var1);
    }

    private static class BeanKPropertyAccessor<T>
    extends BeanPropertyAccessor {
        private final KMutableProperty0<T> myProperty;

        private BeanKPropertyAccessor(KMutableProperty0<T> property) {
            this.myProperty = property;
        }

        @Override
        Object getBeanValue(Object instance) {
            return this.myProperty.get();
        }

        @Override
        void setBeanValue(Object instance, @NotNull Object value2) {
            if (value2 == null) {
                BeanKPropertyAccessor.$$$reportNull$$$0(0);
            }
            this.myProperty.set(value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/options/BeanConfigurable$BeanKPropertyAccessor", "setBeanValue"));
        }
    }

    private static class BeanMethodAccessor<T>
    extends BeanPropertyAccessor {
        private final Getter<? extends T> myGetter;
        private final Setter<? super T> mySetter;

        private BeanMethodAccessor(Getter<? extends T> getter, Setter<? super T> setter) {
            this.myGetter = getter;
            this.mySetter = setter;
        }

        @Override
        Object getBeanValue(Object instance) {
            return this.myGetter.get();
        }

        @Override
        void setBeanValue(Object instance, @NotNull Object value2) {
            if (value2 == null) {
                BeanMethodAccessor.$$$reportNull$$$0(0);
            }
            this.mySetter.set(value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/options/BeanConfigurable$BeanMethodAccessor", "setBeanValue"));
        }
    }

    private static class BeanFieldAccessor
    extends BeanPropertyAccessor {
        private final String myFieldName;
        private final Class myValueClass;

        private BeanFieldAccessor(String fieldName, Class valueClass) {
            this.myFieldName = fieldName;
            this.myValueClass = valueClass;
        }

        @NonNls
        protected String getterName() {
            if (this.myValueClass.equals(Boolean.TYPE)) {
                return "is" + StringUtil.capitalize((String)this.myFieldName);
            }
            return "get" + StringUtil.capitalize((String)this.myFieldName);
        }

        @Override
        Object getBeanValue(@NotNull Object instance) {
            if (instance == null) {
                BeanFieldAccessor.$$$reportNull$$$0(0);
            }
            try {
                Field field = instance.getClass().getField(this.myFieldName);
                return field.get(instance);
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method2 = instance.getClass().getMethod(this.getterName(), new Class[0]);
                    return method2.invoke(instance, new Object[0]);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        void setBeanValue(@NotNull Object instance, @NotNull Object value2) {
            if (instance == null) {
                BeanFieldAccessor.$$$reportNull$$$0(1);
            }
            if (value2 == null) {
                BeanFieldAccessor.$$$reportNull$$$0(2);
            }
            try {
                Field field = instance.getClass().getField(this.myFieldName);
                field.set(instance, value2);
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method2 = instance.getClass().getMethod("set" + StringUtil.capitalize((String)this.myFieldName), this.myValueClass);
                    method2.invoke(instance, value2);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instance";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/options/BeanConfigurable$BeanFieldAccessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBeanValue";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setBeanValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class BeanPropertyAccessor {
        private BeanPropertyAccessor() {
        }

        abstract Object getBeanValue(Object var1);

        abstract void setBeanValue(Object var1, @NotNull Object var2);
    }
}

