/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.settings;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalProjectSettingsControl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemConfigurable<ProjectSettings extends ExternalProjectSettings, L extends ExternalSystemSettingsListener<ProjectSettings>, SystemSettings extends AbstractExternalSystemSettings<SystemSettings, ProjectSettings, L>>
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final List<ExternalSystemSettingsControl<ProjectSettings>> myProjectSettingsControls;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final Project myProject;
    @Nullable
    private ExternalSystemSettingsControl<SystemSettings> mySystemSettingsControl;
    @Nullable
    private ExternalSystemSettingsControl<ProjectSettings> myActiveProjectSettingsControl;
    private PaintAwarePanel myComponent;
    private JBList myProjectsList;
    private DefaultListModel myProjectsModel;

    protected AbstractExternalSystemConfigurable(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        if (project == null) {
            AbstractExternalSystemConfigurable.$$$reportNull$$$0(0);
        }
        if (externalSystemId == null) {
            AbstractExternalSystemConfigurable.$$$reportNull$$$0(1);
        }
        this.myProjectSettingsControls = new ArrayList<ExternalSystemSettingsControl<ProjectSettings>>();
        this.myProject = project;
        this.myExternalSystemId = externalSystemId;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractExternalSystemConfigurable.$$$reportNull$$$0(2);
        }
        return project;
    }

    @Nls
    public String getDisplayName() {
        return this.myExternalSystemId.getReadableName();
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = new PaintAwarePanel(new GridBagLayout());
            SystemSettings settings = this.getSettings();
            this.prepareSystemSettings(settings);
            this.prepareProjectSettings(settings);
            JScrollPane component2 = ScrollPaneFactory.createScrollPane((Component)this.myComponent, (boolean)true);
            component2.setSize(this.myComponent.getPreferredSize());
            this.myComponent.setPreferredSize(this.myComponent.getMinimumSize());
            return component2;
        }
        return this.myComponent;
    }

    @NotNull
    private SystemSettings getSettings() {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.myExternalSystemId);
        assert (manager != null);
        AbstractExternalSystemSettings abstractExternalSystemSettings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject);
        if (abstractExternalSystemSettings == null) {
            AbstractExternalSystemConfigurable.$$$reportNull$$$0(3);
        }
        return (SystemSettings)abstractExternalSystemSettings;
    }

    private void prepareProjectSettings(@NotNull SystemSettings s) {
        ArrayList settings;
        if (s == null) {
            AbstractExternalSystemConfigurable.$$$reportNull$$$0(4);
        }
        if ((settings = new ArrayList(s.getLinkedProjectsSettings())).isEmpty()) {
            ExternalSystemUiUtil.fillBottom(this.myComponent);
            return;
        }
        this.myComponent.add((Component)new TitledSeparator(ExternalSystemBundle.message((String)"settings.title.projects.settings", (Object[])new Object[]{this.myExternalSystemId.getReadableName()})), ExternalSystemUiUtil.getFillLineConstraints(0));
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.16f);
        this.myProjectsModel = new DefaultListModel();
        this.myProjectsList = new JBList((ListModel)this.myProjectsModel);
        this.myProjectsList.setSelectionMode(0);
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myProjectsList);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)11));
        splitter.setFirstComponent((JComponent)scrollPane);
        PaintAwarePanel details = new PaintAwarePanel(new GridBagLayout());
        splitter.setSecondComponent((JComponent)details);
        this.myComponent.add((Component)splitter, ExternalSystemUiUtil.getFillLineConstraints(1).fillCell().weighty(1.0).pady(JBUIScale.scale((int)30)));
        ContainerUtil.sort(settings, Comparator.comparing(s2 -> this.getProjectName(s2.getExternalProjectPath())));
        this.myProjectSettingsControls.clear();
        for (ExternalProjectSettings setting : settings) {
            ExternalSystemSettingsControl<ExternalProjectSettings> control = this.createProjectSettingsControl(setting);
            control.fillUi(details, 1);
            this.myProjectsModel.addElement(this.getProjectName(setting.getExternalProjectPath()));
            this.myProjectSettingsControls.add(control);
            if (control instanceof AbstractExternalProjectSettingsControl) {
                ((AbstractExternalProjectSettingsControl)control).setCurrentProject(this.myProject);
            }
            control.showUi(false);
        }
        ExternalSystemUiUtil.fillBottom(details);
        this.myProjectsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int i2 = AbstractExternalSystemConfigurable.this.myProjectsList.getSelectedIndex();
                if (i2 < 0) {
                    return;
                }
                if (AbstractExternalSystemConfigurable.this.myActiveProjectSettingsControl != null) {
                    AbstractExternalSystemConfigurable.this.myActiveProjectSettingsControl.showUi(false);
                }
                AbstractExternalSystemConfigurable.this.myActiveProjectSettingsControl = (ExternalSystemSettingsControl)AbstractExternalSystemConfigurable.this.myProjectSettingsControls.get(i2);
                AbstractExternalSystemConfigurable.this.myActiveProjectSettingsControl.showUi(true);
            }
        });
        if (!this.myProjectsModel.isEmpty()) {
            this.myProjectsList.setSelectedIndex(0);
        }
    }

    public void selectProject(@NotNull String linkedProjectPath) {
        if (linkedProjectPath == null) {
            AbstractExternalSystemConfigurable.$$$reportNull$$$0(5);
        }
        this.myProjectsList.setSelectedValue((Object)this.getProjectName(linkedProjectPath), true);
    }

    @NotNull
    protected abstract ExternalSystemSettingsControl<ProjectSettings> createProjectSettingsControl(@NotNull ProjectSettings var1);

    @NotNull
    protected String getProjectName(@NotNull String path) {
        File file2;
        if (path == null) {
            AbstractExternalSystemConfigurable.$$$reportNull$$$0(6);
        }
        String string = (file2 = new File(path)).isDirectory() || file2.getParentFile() == null ? file2.getName() : file2.getParentFile().getName();
        if (string == null) {
            AbstractExternalSystemConfigurable.$$$reportNull$$$0(7);
        }
        return string;
    }

    private void prepareSystemSettings(@NotNull SystemSettings s) {
        if (s == null) {
            AbstractExternalSystemConfigurable.$$$reportNull$$$0(8);
        }
        this.mySystemSettingsControl = this.createSystemSettingsControl(s);
        if (this.mySystemSettingsControl != null) {
            PaintAwarePanel panel2 = new PaintAwarePanel();
            GridBag constraints2 = new GridBag().weightx(1.0).coverLine().fillCellHorizontally().anchor(17);
            constraints2.insetBottom(4);
            this.myComponent.add((Component)panel2, constraints2);
            constraints2 = ExternalSystemUiUtil.getFillLineConstraints(0);
            constraints2.insets.top = 0;
            panel2.add((Component)new TitledSeparator(ExternalSystemBundle.message((String)"settings.title.system.settings", (Object[])new Object[0])), constraints2);
            this.mySystemSettingsControl.fillUi(panel2, 1);
        }
    }

    @Nullable
    protected abstract ExternalSystemSettingsControl<SystemSettings> createSystemSettingsControl(@NotNull SystemSettings var1);

    public boolean isModified() {
        for (ExternalSystemSettingsControl<ProjectSettings> control : this.myProjectSettingsControls) {
            if (!control.isModified()) continue;
            return true;
        }
        return this.mySystemSettingsControl != null && this.mySystemSettingsControl.isModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() throws ConfigurationException {
        SystemSettings systemSettings = this.getSettings();
        ExternalSystemSettingsListener publisher = systemSettings.getPublisher();
        publisher.onBulkChangeStart();
        try {
            ArrayList<ProjectSettings> projectSettings = new ArrayList<ProjectSettings>();
            for (ExternalSystemSettingsControl<ProjectSettings> control : this.myProjectSettingsControls) {
                ProjectSettings s = this.newProjectSettings();
                s.setupNewProjectDefault();
                control.apply(s);
                projectSettings.add(s);
            }
            systemSettings.setLinkedProjectsSettings(projectSettings);
            for (ExternalSystemSettingsControl<ProjectSettings> control : this.myProjectSettingsControls) {
                if (!(control instanceof AbstractExternalProjectSettingsControl)) continue;
                ((AbstractExternalProjectSettingsControl)control).updateInitialSettings();
            }
            if (this.mySystemSettingsControl != null) {
                this.mySystemSettingsControl.apply(systemSettings);
            }
        }
        finally {
            publisher.onBulkChangeEnd();
        }
    }

    @NotNull
    protected abstract ProjectSettings newProjectSettings();

    public void reset() {
        for (ExternalSystemSettingsControl<ProjectSettings> control : this.myProjectSettingsControls) {
            control.reset(this.myProject);
        }
        if (this.mySystemSettingsControl != null) {
            this.mySystemSettingsControl.reset(this.myProject);
        }
    }

    public void disposeUIResources() {
        for (ExternalSystemSettingsControl<ProjectSettings> control : this.myProjectSettingsControls) {
            control.disposeUIResources();
        }
        if (this.mySystemSettingsControl != null) {
            this.mySystemSettingsControl.disposeUIResources();
        }
        this.myProjectSettingsControls.clear();
        this.myComponent = null;
        this.myProjectsList = null;
        this.myProjectsModel = null;
        this.mySystemSettingsControl = null;
    }

    @NotNull
    List<ExternalSystemSettingsControl<ProjectSettings>> getProjectSettingsControls() {
        List<ExternalSystemSettingsControl<ProjectSettings>> list2 = Collections.unmodifiableList(this.myProjectSettingsControls);
        if (list2 == null) {
            AbstractExternalSystemConfigurable.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/settings/AbstractExternalSystemConfigurable";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/settings/AbstractExternalSystemConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSettingsControls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareProjectSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProjectName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareSystemSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

