/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollingModel;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class CaretVisualPositionKeeper {
    private final Map<Editor, Integer> myCaretRelativeVerticalPositions;

    public CaretVisualPositionKeeper(@Nullable Editor editor) {
        Editor[] editorArray;
        if (editor == null) {
            editorArray = Editor.EMPTY_ARRAY;
        } else {
            Editor[] editorArray2 = new Editor[1];
            editorArray = editorArray2;
            editorArray2[0] = editor;
        }
        this(editorArray);
    }

    private CaretVisualPositionKeeper(Editor[] editors) {
        this.myCaretRelativeVerticalPositions = new HashMap<Editor, Integer>();
        for (Editor editor : editors) {
            Rectangle visibleArea = editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
            Point pos = editor.visualPositionToXY(editor.getCaretModel().getVisualPosition());
            int relativePosition = pos.y - visibleArea.y;
            this.myCaretRelativeVerticalPositions.put(editor, relativePosition);
        }
    }

    public void restoreOriginalLocation(boolean stopAnimation) {
        for (Map.Entry<Editor, Integer> e : this.myCaretRelativeVerticalPositions.entrySet()) {
            boolean disableAnimation;
            Editor editor = e.getKey();
            int relativePosition = e.getValue();
            Point caretLocation = editor.visualPositionToXY(editor.getCaretModel().getVisualPosition());
            int scrollOffset = caretLocation.y - relativePosition;
            ScrollingModel scrollingModel = editor.getScrollingModel();
            Rectangle targetArea = scrollingModel.getVisibleAreaOnScrollingFinished();
            boolean bl = disableAnimation = targetArea.equals(scrollingModel.getVisibleArea()) || stopAnimation;
            if (disableAnimation) {
                scrollingModel.disableAnimation();
            }
            scrollingModel.scroll(targetArea.x, scrollOffset);
            if (!disableAnimation) continue;
            scrollingModel.enableAnimation();
        }
    }
}

