/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.NotNull;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.FontSubstitution;

final class AccessingInternalJdkFontApi {
    private static final Method GET_FONT_2D_METHOD = ReflectionUtil.getDeclaredMethod(Font.class, (String)"getFont2D", (Class[])new Class[0]);
    private static final FontRenderContext DUMMY_CONTEXT = new FontRenderContext(null, false, false);

    AccessingInternalJdkFontApi() {
    }

    static List<String> getRelevantComponents(@NotNull Font font, @NotNull CharSequence text, int startOffset, int endOffset) throws Exception {
        Font2D font2D;
        if (font == null) {
            AccessingInternalJdkFontApi.$$$reportNull$$$0(0);
        }
        if (text == null) {
            AccessingInternalJdkFontApi.$$$reportNull$$$0(1);
        }
        if (GET_FONT_2D_METHOD != null && (font2D = (Font2D)GET_FONT_2D_METHOD.invoke((Object)font, new Object[0])) != null) {
            CompositeFont compositeFont = null;
            IntUnaryOperator charToGlyphMapper = null;
            if (font2D instanceof CompositeFont) {
                compositeFont = (CompositeFont)font2D;
                charToGlyphMapper = c -> font2D.charToGlyph(c);
            } else if (font2D instanceof FontSubstitution) {
                compositeFont = ((FontSubstitution)((Object)font2D)).getCompositeFont2D();
                charToGlyphMapper = c -> font.createGlyphVector(DUMMY_CONTEXT, new String(new int[]{c}, 0, 1)).getGlyphCode(0);
            }
            ArrayList<Font2D> components = new ArrayList<Font2D>();
            if (compositeFont == null) {
                components.add(font2D);
            } else {
                int codePoint;
                for (int i2 = startOffset; i2 < endOffset; i2 += Character.charCount(codePoint)) {
                    codePoint = Character.codePointAt(text, i2);
                    int glyph = charToGlyphMapper.applyAsInt(codePoint);
                    int slot = glyph >>> 24;
                    components.add(compositeFont.getSlotFont(slot));
                }
            }
            return ContainerUtil.map(components, f -> f.getFontName(null));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "font";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/actions/AccessingInternalJdkFontApi";
        objectArray[2] = "getRelevantComponents";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

