/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.impl.NotificationParentGroup;
import com.intellij.notification.impl.NotificationParentGroupBean;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.ui.NotificationSettingsWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.StripeTable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.IndexTreePathState;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class NotificationsConfigurablePanel
extends JPanel
implements Disposable {
    private static final String REMOVE_KEY = "REMOVE";
    private NotificationsTreeTable myTable;
    private final JCheckBox myDisplayBalloons;
    private final JCheckBox mySystemNotifications;

    public NotificationsConfigurablePanel() {
        this.setLayout(new BorderLayout(5, 5));
        this.myTable = new NotificationsTreeTable();
        this.myDisplayBalloons = new JCheckBox(IdeBundle.message((String)"notifications.configurable.display.balloon.notifications", (Object[])new Object[0]));
        this.myDisplayBalloons.setMnemonic('b');
        this.myDisplayBalloons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationsConfigurablePanel.this.myTable.repaint();
            }
        });
        this.mySystemNotifications = new JCheckBox(IdeBundle.message((String)"notifications.configurable.enable.system.notifications", (Object[])new Object[0]));
        this.mySystemNotifications.setMnemonic('s');
        JPanel boxes = new JPanel();
        boxes.setLayout(new BoxLayout(boxes, 1));
        boxes.add(this.myDisplayBalloons);
        boxes.add(this.mySystemNotifications);
        this.add((Component)boxes, "North");
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable)), "Center");
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), REMOVE_KEY);
        this.myTable.getActionMap().put(REMOVE_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationsConfigurablePanel.this.removeSelected();
            }
        });
    }

    private void removeSelected() {
        this.myTable.removeSelected();
    }

    public void dispose() {
        this.myTable = null;
    }

    public boolean isModified() {
        List<NotificationSettingsWrapper> list2 = this.myTable.getAllSettings();
        for (NotificationSettingsWrapper settingsWrapper : list2) {
            if (!settingsWrapper.hasChanged()) continue;
            return true;
        }
        NotificationsConfigurationImpl configuration = NotificationsConfigurationImpl.getInstanceImpl();
        return configuration.SHOW_BALLOONS != this.myDisplayBalloons.isSelected() || configuration.SYSTEM_NOTIFICATIONS != this.mySystemNotifications.isSelected();
    }

    public void apply() {
        List<NotificationSettingsWrapper> list2 = this.myTable.getAllSettings();
        for (NotificationSettingsWrapper settingsWrapper : list2) {
            settingsWrapper.apply();
        }
        NotificationsConfigurationImpl configuration = NotificationsConfigurationImpl.getInstanceImpl();
        configuration.SHOW_BALLOONS = this.myDisplayBalloons.isSelected();
        configuration.SYSTEM_NOTIFICATIONS = this.mySystemNotifications.isSelected();
    }

    public void reset() {
        List<NotificationSettingsWrapper> list2 = this.myTable.getAllSettings();
        for (NotificationSettingsWrapper settingsWrapper : list2) {
            settingsWrapper.reset();
        }
        NotificationsConfigurationImpl configuration = NotificationsConfigurationImpl.getInstanceImpl();
        this.myDisplayBalloons.setSelected(configuration.SHOW_BALLOONS);
        this.mySystemNotifications.setSelected(configuration.SYSTEM_NOTIFICATIONS);
        this.myTable.invalidate();
        this.myTable.repaint();
    }

    public void selectGroup(String searchQuery) {
        Objects.requireNonNull(SpeedSearchSupply.getSupply((JComponent)((Object)this.myTable), (boolean)true)).findAndSelectElement(searchQuery);
    }

    public static class NotificationsTreeTableModel
    extends DefaultTreeModel
    implements TreeTableModel {
        private final List<NotificationSettingsWrapper> mySettings = new ArrayList<NotificationSettingsWrapper>();
        private JTree myTree;

        NotificationsTreeTableModel() {
            super(null);
            ArrayList<DefaultMutableTreeNode> rootChildren = new ArrayList<DefaultMutableTreeNode>();
            HashMap<NotificationParentGroupBean, List<DefaultMutableTreeNode>> parentChildrenTable = new HashMap<NotificationParentGroupBean, List<DefaultMutableTreeNode>>();
            for (NotificationSettings setting : NotificationsConfigurationImpl.getInstanceImpl().getAllSettings()) {
                ArrayList<DefaultMutableTreeNode> children2;
                NotificationSettingsWrapper wrapper2 = new NotificationSettingsWrapper(setting);
                this.mySettings.add(wrapper2);
                NotificationParentGroupBean parentGroup = NotificationParentGroup.findParent(setting);
                DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(wrapper2, false);
                if (parentGroup == null) {
                    rootChildren.add(treeNode);
                    continue;
                }
                wrapper2.setTitle(NotificationParentGroup.getReplaceTitle(wrapper2.getGroupId()));
                if (wrapper2.getTitle() == null && parentGroup.titlePrefix != null) {
                    wrapper2.setTitle(StringUtil.substringAfter((String)wrapper2.getGroupId(), (String)parentGroup.titlePrefix));
                }
                if ((children2 = (ArrayList<DefaultMutableTreeNode>)parentChildrenTable.get((Object)parentGroup)) == null) {
                    children2 = new ArrayList<DefaultMutableTreeNode>();
                    parentChildrenTable.put(parentGroup, children2);
                }
                children2.add(treeNode);
            }
            for (NotificationParentGroupBean parentGroup : NotificationParentGroup.getParents()) {
                if (parentGroup.parentId != null) continue;
                DefaultMutableTreeNode node = new DefaultMutableTreeNode((Object)parentGroup);
                NotificationsTreeTableModel.addParentGroup(parentGroup, node, parentChildrenTable);
                rootChildren.add(node);
            }
            rootChildren.sort((node1, node2) -> {
                Object object1 = node1.getUserObject();
                Object object2 = node2.getUserObject();
                if (object1 instanceof NotificationParentGroupBean) {
                    if (object2 instanceof NotificationParentGroupBean) {
                        return object1.toString().compareTo(object2.toString());
                    }
                    return -1;
                }
                if (object2 instanceof NotificationSettingsWrapper) {
                    return ((NotificationSettingsWrapper)object1).getGroupId().compareTo(((NotificationSettingsWrapper)object2).getGroupId());
                }
                return 1;
            });
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            for (DefaultMutableTreeNode child2 : rootChildren) {
                root.add(child2);
            }
            this.setRoot(root);
        }

        private static void addParentGroup(@NotNull NotificationParentGroupBean parent, @NotNull DefaultMutableTreeNode node, @NotNull Map<NotificationParentGroupBean, List<DefaultMutableTreeNode>> parentChildrenTable) {
            if (parent == null) {
                NotificationsTreeTableModel.$$$reportNull$$$0(0);
            }
            if (node == null) {
                NotificationsTreeTableModel.$$$reportNull$$$0(1);
            }
            if (parentChildrenTable == null) {
                NotificationsTreeTableModel.$$$reportNull$$$0(2);
            }
            for (NotificationParentGroupBean child2 : NotificationParentGroup.getChildren(parent)) {
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode((Object)child2);
                NotificationsTreeTableModel.addParentGroup(child2, childNode, parentChildrenTable);
                node.add(childNode);
            }
            List<DefaultMutableTreeNode> nodes = parentChildrenTable.get((Object)parent);
            if (nodes != null) {
                for (DefaultMutableTreeNode childNode : nodes) {
                    node.add(childNode);
                }
            }
        }

        public int getColumnCount() {
            return SystemInfo.isMac ? 4 : 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return IdeBundle.message((String)"notifications.configurable.column.group", (Object[])new Object[0]);
                }
                case 2: {
                    return IdeBundle.message((String)"notifications.configurable.column.log", (Object[])new Object[0]);
                }
                case 3: {
                    return IdeBundle.message((String)"notifications.configurable.column.read.aloud", (Object[])new Object[0]);
                }
            }
            return IdeBundle.message((String)"notifications.configurable.column.popup", (Object[])new Object[0]);
        }

        public Class getColumnClass(int column) {
            if (1 == column) {
                return NotificationDisplayType.class;
            }
            if (2 == column) {
                return Boolean.class;
            }
            if (3 == column) {
                return Boolean.class;
            }
            return TreeTableModel.class;
        }

        public boolean isCellEditable(Object node, int column) {
            return column > 0 && ((DefaultMutableTreeNode)node).getUserObject() instanceof NotificationSettingsWrapper;
        }

        public Object getValueAt(Object node, int column) {
            if (column == 0) {
                return node;
            }
            Object object = ((DefaultMutableTreeNode)node).getUserObject();
            if (object instanceof NotificationParentGroupBean) {
                return null;
            }
            NotificationSettingsWrapper wrapper2 = (NotificationSettingsWrapper)object;
            switch (column) {
                case 2: {
                    return wrapper2.isShouldLog();
                }
                case 3: {
                    return wrapper2.isShouldReadAloud();
                }
            }
            return wrapper2.getDisplayType();
        }

        public void setValueAt(Object value2, Object node, int column) {
            NotificationSettingsWrapper wrapper2 = (NotificationSettingsWrapper)((DefaultMutableTreeNode)node).getUserObject();
            switch (column) {
                case 1: {
                    wrapper2.setDisplayType((NotificationDisplayType)value2);
                    break;
                }
                case 2: {
                    wrapper2.setShouldLog((Boolean)value2);
                    break;
                }
                case 3: {
                    wrapper2.setShouldReadAloud((Boolean)value2);
                }
            }
        }

        public void setTree(JTree tree) {
            this.myTree = tree;
            tree.setRootVisible(false);
        }

        public TreePath removeRow(int row) {
            Pair<DefaultMutableTreeNode, Object> rowValue = this.getRowValue(row);
            if (rowValue.second instanceof NotificationSettingsWrapper) {
                ((NotificationSettingsWrapper)rowValue.second).remove();
            } else {
                NotificationsTreeTableModel.removeChildSettings((DefaultMutableTreeNode)rowValue.first);
            }
            return this.removeNode((DefaultMutableTreeNode)rowValue.first);
        }

        private static void removeChildSettings(DefaultMutableTreeNode node) {
            int count = node.getChildCount();
            for (int i2 = 0; i2 < count; ++i2) {
                DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)node.getChildAt(i2);
                Object object = child2.getUserObject();
                if (object instanceof NotificationSettingsWrapper) {
                    ((NotificationSettingsWrapper)object).remove();
                    continue;
                }
                NotificationsTreeTableModel.removeChildSettings(child2);
            }
        }

        private TreePath removeNode(DefaultMutableTreeNode node) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            if (parent != null) {
                IndexTreePathState state = new IndexTreePathState(TreeUtil.getPathFromRoot((TreeNode)node));
                this.removeNodeFromParent(node);
                if (parent.isLeaf()) {
                    return this.removeNode(parent);
                }
                return state.getRestoredPath();
            }
            return null;
        }

        public Pair<DefaultMutableTreeNode, Object> getRowValue(int row) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.myTree.getPathForRow(row).getLastPathComponent();
            return Pair.create((Object)node, (Object)node.getUserObject());
        }

        public List<NotificationSettingsWrapper> getAllSettings() {
            return this.mySettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentChildrenTable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTreeTableModel";
            objectArray[2] = "addParentGroup";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TreeColumnCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private final JTable myTable;

        TreeColumnCellRenderer(@NotNull JTable table) {
            if (table == null) {
                TreeColumnCellRenderer.$$$reportNull$$$0(0);
            }
            this.myTable = table;
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setForeground(selected2 ? this.myTable.getSelectionForeground() : this.myTable.getForeground());
            this.setText(value2.toString());
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$TreeColumnCellRenderer", "<init>"));
        }
    }

    private class NotificationsTreeTable
    extends TreeTable {
        private static final int ID_COLUMN = 0;
        private static final int DISPLAY_TYPE_COLUMN = 1;
        private static final int LOG_COLUMN = 2;
        private static final int READ_ALOUD_COLUMN = 3;

        NotificationsTreeTable() {
            super((TreeTableModel)new NotificationsTreeTableModel());
            StripeTable.apply((JBTable)this);
            this.setSelectionMode(0);
            this.getTree().setCellRenderer((TreeCellRenderer)new TreeColumnCellRenderer((JTable)((Object)this)));
            this.initColumns();
        }

        public Dimension getPreferredScrollableViewportSize() {
            return new JBDimension(600, 400);
        }

        private void initColumns() {
            TableColumn displayTypeColumn = this.getColumnModel().getColumn(1);
            ComboBoxTableRenderer<NotificationDisplayType> displayTypeRenderer = new ComboBoxTableRenderer<NotificationDisplayType>(NotificationDisplayType.values()){

                protected void customizeComponent(NotificationDisplayType value2, JTable table, boolean isSelected) {
                    super.customizeComponent((Object)(NotificationsConfigurablePanel.this.myDisplayBalloons.isSelected() ? value2 : NotificationDisplayType.NONE), table, isSelected);
                    if (!NotificationsConfigurablePanel.this.myDisplayBalloons.isSelected() && !isSelected) {
                        this.setBackground(UIUtil.getComboBoxDisabledBackground());
                        this.setForeground(UIUtil.getComboBoxDisabledForeground());
                    }
                }

                protected String getTextFor(@NotNull NotificationDisplayType value2) {
                    if (value2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return value2.getTitle();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTreeTable$1", "getTextFor"));
                }
            };
            displayTypeColumn.setCellRenderer((TableCellRenderer)displayTypeRenderer);
            displayTypeColumn.setCellEditor((TableCellEditor)new ComboBoxTableRenderer<NotificationDisplayType>(NotificationDisplayType.values()){

                public boolean isCellEditable(EventObject event) {
                    if (!NotificationsConfigurablePanel.this.myDisplayBalloons.isSelected()) {
                        return false;
                    }
                    if (event instanceof MouseEvent) {
                        return ((MouseEvent)event).getClickCount() >= 1;
                    }
                    return false;
                }

                protected boolean isApplicable(NotificationDisplayType value2, int row) {
                    if (value2 != NotificationDisplayType.TOOL_WINDOW) {
                        return true;
                    }
                    Object wrapper2 = ((NotificationsTreeTableModel)NotificationsTreeTable.this.getTableModel()).getRowValue((int)row).second;
                    String groupId2 = ((NotificationSettingsWrapper)wrapper2).getGroupId();
                    return NotificationsConfigurationImpl.getInstanceImpl().hasToolWindowCapability(groupId2);
                }

                protected String getTextFor(@NotNull NotificationDisplayType value2) {
                    if (value2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return value2.getTitle();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTreeTable$2", "getTextFor"));
                }
            });
            displayTypeColumn.setPreferredWidth(displayTypeRenderer.getPreferredSize().width);
            displayTypeColumn.setMaxWidth(displayTypeRenderer.getMinimumSize().width);
            this.initBooleanColumn(2);
            if (SystemInfo.isMac) {
                this.initBooleanColumn(3);
            }
            new TableSpeedSearch((JTable)((Object)this));
            this.getEmptyText().setText(IdeBundle.message((String)"notifications.configurable.no.notifications.configured", (Object[])new Object[0]));
            TreeUtil.expandAll((JTree)this.getTree());
        }

        private void initBooleanColumn(int columnIndex) {
            TableColumn column = this.getColumnModel().getColumn(columnIndex);
            BooleanTableCellRenderer renderer = new BooleanTableCellRenderer();
            column.setCellRenderer((TableCellRenderer)renderer);
            Dimension headerSize = this.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)((Object)this), this.getModel().getColumnName(columnIndex), false, false, 0, columnIndex).getPreferredSize();
            column.setMaxWidth(Math.max(JBUIScale.scale((int)65), Math.max(headerSize.width, renderer.getPreferredSize().width)));
        }

        public Dimension getMinimumSize() {
            return this.calcSize(super.getMinimumSize());
        }

        public Dimension getPreferredSize() {
            return this.calcSize(super.getPreferredSize());
        }

        private Dimension calcSize(@NotNull Dimension s) {
            Container container2;
            if (s == null) {
                NotificationsTreeTable.$$$reportNull$$$0(0);
            }
            if ((container2 = this.getParent()) != null) {
                Dimension size = container2.getSize();
                return new Dimension(size.width, s.height);
            }
            return s;
        }

        public List<NotificationSettingsWrapper> getAllSettings() {
            return ((NotificationsTreeTableModel)this.getTableModel()).getAllSettings();
        }

        public void removeSelected() {
            ListSelectionModel selectionModel = this.getSelectionModel();
            if (!selectionModel.isSelectionEmpty()) {
                int selection = selectionModel.getMinSelectionIndex();
                TreePath newSelection = ((NotificationsTreeTableModel)this.getTableModel()).removeRow(selection);
                this.addSelectedPath(newSelection);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/notification/impl/ui/NotificationsConfigurablePanel$NotificationsTreeTable", "calcSize"));
        }
    }
}

